/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.manager;

import it.auties.whatsapp4j.listener.WhatsappListener;
import it.auties.whatsapp4j.media.MediaConnection;
import it.auties.whatsapp4j.protobuf.chat.Chat;
import it.auties.whatsapp4j.protobuf.chat.ChatMute;
import it.auties.whatsapp4j.protobuf.contact.Contact;
import it.auties.whatsapp4j.protobuf.info.MessageInfo;
import it.auties.whatsapp4j.protobuf.message.server.ProtocolMessage;
import it.auties.whatsapp4j.protobuf.model.Node;
import it.auties.whatsapp4j.request.model.Request;
import it.auties.whatsapp4j.response.impl.json.PhoneBatteryResponse;
import it.auties.whatsapp4j.response.model.binary.BinaryResponseModel;
import it.auties.whatsapp4j.response.model.common.Response;
import it.auties.whatsapp4j.response.model.json.JsonResponse;
import it.auties.whatsapp4j.utils.WhatsappUtils;
import it.auties.whatsapp4j.whatsapp.internal.WhatsappWebSocket;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class WhatsappDataManager {
    private static final WhatsappDataManager singletonInstance = new WhatsappDataManager(Executors.newSingleThreadExecutor(), new ArrayList<Chat>(), new ArrayList<Contact>(), new ArrayList(), new ArrayList<WhatsappListener>(), Instant.now().getEpochSecond());
    @NonNull
    private final ExecutorService requestsService;
    @NonNull
    private final List<Chat> chats;
    @NonNull
    private final List<Contact> contacts;
    @NonNull
    private final List<Request<?, ?>> pendingRequests;
    @NonNull
    private final List<WhatsappListener> listeners;
    private final long initializationTimeStamp;
    private String phoneNumberJid;
    private MediaConnection mediaConnection;
    private long tag;

    @NonNull
    public Optional<Contact> findContactByJid(@NonNull String jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return Collections.synchronizedList(this.contacts).stream().filter(e -> Objects.equals(e.jid(), WhatsappUtils.parseJid(jid))).findAny();
    }

    @NonNull
    public Optional<Contact> findContactByName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Collections.synchronizedList(this.contacts).stream().filter(e -> Objects.equals(e.bestName().orElse(null), name)).findAny();
    }

    @NonNull
    public Set<Contact> findContactsByName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Collections.synchronizedList(this.contacts).stream().filter(e -> Objects.equals(e.bestName().orElse(null), name)).collect(Collectors.toUnmodifiableSet());
    }

    @NonNull
    public Optional<Chat> findChatByJid(@NonNull String jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return Collections.synchronizedList(this.chats).stream().filter(e -> Objects.equals(e.jid(), WhatsappUtils.parseJid(jid))).findAny();
    }

    @NonNull
    public Optional<MessageInfo> findMessageById(@NonNull Chat chat, @NonNull String id) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return chat.messages().stream().filter(e -> Objects.equals(e.key().id(), id)).findAny();
    }

    @NonNull
    public Optional<Chat> findChatByMessage(@NonNull MessageInfo message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.findChatByJid(message.key().chatJid());
    }

    @NonNull
    public Optional<Chat> findChatByName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Collections.synchronizedList(this.chats).stream().filter(e -> Objects.equals(e.displayName(), name)).findAny();
    }

    @NonNull
    public Set<Chat> findChatsByName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Collections.synchronizedList(this.chats).stream().filter(e -> Objects.equals(e.displayName(), name)).collect(Collectors.toUnmodifiableSet());
    }

    @NonNull
    public Optional<Request<?, ?>> findPendingRequest(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        return Collections.synchronizedList(this.pendingRequests).stream().filter(req -> req.tag().equals(tag)).findAny();
    }

    public boolean resolvePendingRequest(@NonNull String messageTag, @NonNull Response<?> response) {
        if (messageTag == null) {
            throw new NullPointerException("messageTag is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Optional<Request<?, ?>> req = this.findPendingRequest(messageTag);
        if (req.isEmpty()) {
            return false;
        }
        Request<?, ?> request = req.get();
        request.complete(response);
        this.pendingRequests.remove(request);
        return true;
    }

    @NonNull
    public Chat addChat(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        this.chats.add(chat);
        return chat;
    }

    public long pinnedChats() {
        return this.chats.stream().filter(Chat::isPinned).count();
    }

    public void clear() {
        this.chats.clear();
        this.contacts.clear();
        this.pendingRequests.clear();
    }

    public long tagAndIncrement() {
        return this.tag++;
    }

    @NonNull
    public String phoneNumberJid() {
        return Objects.requireNonNull(this.phoneNumberJid, "WhatsappAPI: Phone number is missing");
    }

    @NonNull
    public MediaConnection mediaConnection() {
        return Objects.requireNonNull(this.mediaConnection, "WhatsappAPI: Media connection is missing");
    }

    public void callListeners(@NonNull Consumer<WhatsappListener> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        this.listeners.forEach(listener -> this.callOnListenerThread(() -> consumer.accept((WhatsappListener)listener)));
    }

    public void digestWhatsappNode(@NonNull WhatsappWebSocket socket, @NonNull Node node) {
        if (socket == null) {
            throw new NullPointerException("socket is marked non-null but is null");
        }
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        String description = node.description();
        Map<String, String> attrs = node.attrs();
        Object content = node.content();
        boolean duplicate = Boolean.parseBoolean(attrs.getOrDefault("duplicate", "false"));
        if (duplicate) {
            return;
        }
        switch (description) {
            case "response": {
                this.parseResponse(socket, node, content);
                break;
            }
            case "action": {
                this.parseAction(socket, node, content);
            }
        }
    }

    private void parseAction(@NonNull WhatsappWebSocket socket, @NonNull Node node, Object content) {
        if (socket == null) {
            throw new NullPointerException("socket is marked non-null but is null");
        }
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (!(content instanceof List)) {
            return;
        }
        List listContent = (List)content;
        List<Node> nodes = Node.fromGenericList(listContent);
        if (nodes.isEmpty()) {
            return;
        }
        Node firstChildNode = nodes.get(0);
        switch (firstChildNode.description()) {
            case "chat": {
                this.parseChatAction(firstChildNode);
                break;
            }
            case "user": {
                this.parseContact(node);
                break;
            }
            case "battery": {
                this.parseBattery(node);
                break;
            }
            case "read": {
                this.parseReadStatus(firstChildNode);
                break;
            }
            case "received": {
                this.parseReceivedStatus(firstChildNode);
                break;
            }
            case "contacts": 
            case "broadcast": {
                break;
            }
            case "message": {
                this.processMessages(socket, node, nodes);
            }
        }
    }

    private void parseChatAction(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        String jid = node.attrs().get("jid");
        if (jid == null) {
            return;
        }
        Chat chat = this.findChatByJid(jid).orElse(null);
        if (chat == null) {
            return;
        }
        String type = node.attrs().get("type");
        if (type == null) {
            return;
        }
        switch (type) {
            case "archive": {
                this.archiveChat(chat, true);
                break;
            }
            case "unarchive": {
                this.archiveChat(chat, false);
                break;
            }
            case "mute": {
                this.muteChat(node, chat);
                break;
            }
            case "star": {
                this.starMessage(node, chat);
                break;
            }
            case "unstar": {
                this.unstarMessage(node, chat);
                break;
            }
            case "clear": {
                this.deleteMessage(node, chat);
                break;
            }
            case "delete": {
                this.chats.remove(chat);
            }
        }
    }

    private void parseContact(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        Object object = node.content();
        if (!(object instanceof List)) {
            return;
        }
        List content = (List)object;
        Node.fromGenericList(content).forEach(childNode -> this.addOrReplaceContact(Contact.fromAttributes(childNode.attrs())));
    }

    private void addOrReplaceContact(@NonNull Contact contact) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        if (this.findContactByJid(contact.jid()).isPresent()) {
            this.contacts.remove(contact);
            this.contacts.add(contact);
            this.callListeners(listener -> listener.onContactUpdate(contact));
            return;
        }
        this.contacts.add(contact);
        this.callListeners(listener -> listener.onNewContact(contact));
    }

    private void parseBattery(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        Object object = node.content();
        if (!(object instanceof List)) {
            return;
        }
        List content = (List)object;
        List<Node> nodes = Node.fromGenericList(content);
        nodes.forEach(childNode -> this.callListeners(listener -> this.parseBattery((Node)childNode, (WhatsappListener)listener)));
    }

    private void parseBattery(@NonNull Node childNode, @NonNull WhatsappListener listener) {
        if (childNode == null) {
            throw new NullPointerException("childNode is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        JsonResponse json = JsonResponse.fromMap(childNode.attrs());
        PhoneBatteryResponse battery = json.toModel(PhoneBatteryResponse.class);
        listener.onPhoneBatteryStatusUpdate(battery);
    }

    private void muteChat(@NonNull Node node, @NonNull Chat chat) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        chat.mute(new ChatMute(Long.parseLong(node.attrs().get("mute"))));
        this.callListeners(listener -> listener.onChatMuteChange(chat));
    }

    private void archiveChat(@NonNull Chat chat, boolean archive) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        chat.isArchived(archive);
        this.callListeners(listener -> this.archiveChat(chat, (WhatsappListener)listener, archive));
    }

    private void archiveChat(@NonNull Chat chat, @NonNull WhatsappListener listener, boolean archive) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (archive) {
            listener.onChatArchived(chat);
            return;
        }
        listener.onChatUnarchived(chat);
    }

    private void deleteMessage(@NonNull Node node, @NonNull Chat chat) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (node.content() == null) {
            chat.messages().clear();
            return;
        }
        Object object = node.content();
        if (!(object instanceof List)) {
            return;
        }
        List content = (List)object;
        List<Node> childNodes = Node.fromGenericList(content);
        if (childNodes.isEmpty()) {
            return;
        }
        this.findMessagesFromNode(chat, childNodes).forEach(message -> {
            chat.messages().remove(message);
            this.callListeners(listener -> listener.onMessageDeleted(chat, (MessageInfo)message, false));
        });
    }

    private void unstarMessage(@NonNull Node node, @NonNull Chat chat) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        Object object = node.content();
        if (!(object instanceof List)) {
            return;
        }
        List content = (List)object;
        List<Node> childNodes = Node.fromGenericList(content);
        if (childNodes.isEmpty()) {
            return;
        }
        this.findMessagesFromNode(chat, childNodes).forEach(message -> this.unstarMessage(chat, (MessageInfo)message));
    }

    @NonNull
    private Stream<MessageInfo> findMessagesFromNode(@NonNull Chat chat, @NonNull List<Node> childNodes) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (childNodes == null) {
            throw new NullPointerException("childNodes is marked non-null but is null");
        }
        return childNodes.stream().map(Node::attrs).map(entry -> (String)entry.get("index")).filter(Objects::nonNull).map(id -> this.findMessageById(chat, (String)id)).map(Optional::orElseThrow);
    }

    private void unstarMessage(@NonNull Chat chat, @NonNull MessageInfo message) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        message.starred(false);
        this.callListeners(listener -> listener.onMessageUnstarred(chat, message));
    }

    private void starMessage(@NonNull Node node, @NonNull Chat chat) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        Object object = node.content();
        if (!(object instanceof List)) {
            return;
        }
        List content = (List)object;
        List<Node> childNodes = Node.fromGenericList(content);
        if (childNodes.isEmpty()) {
            return;
        }
        this.findMessagesFromNodes(childNodes).forEach(message -> this.starMessage(chat, (MessageInfo)message));
    }

    private void starMessage(Chat chat, MessageInfo message) {
        chat.messages().addOrReplace(message);
        this.callListeners(listener -> listener.onMessageStarred(chat, message));
    }

    @NonNull
    private Stream<MessageInfo> findMessagesFromNodes(@NonNull List<Node> childNodes) {
        if (childNodes == null) {
            throw new NullPointerException("childNodes is marked non-null but is null");
        }
        return childNodes.stream().map(Node::content).filter(entry -> entry instanceof MessageInfo).map(entry -> (MessageInfo)entry);
    }

    private void parseResponse(@NonNull WhatsappWebSocket socket, @NonNull Node node, Object content) {
        if (socket == null) {
            throw new NullPointerException("socket is marked non-null but is null");
        }
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        String type = node.attrs().get("type");
        if (type == null) {
            return;
        }
        if (!(content instanceof List)) {
            return;
        }
        List listContent = (List)content;
        List<Node> nodes = Node.fromGenericList(listContent);
        if (nodes.isEmpty()) {
            return;
        }
        switch (type) {
            case "contacts": {
                this.parseContacts(nodes);
                break;
            }
            case "chat": {
                this.parseChats(nodes);
                break;
            }
            case "message": {
                this.processMessages(socket, node, nodes);
            }
        }
    }

    private void processMessages(@NonNull WhatsappWebSocket socket, @NonNull Node node, List<Node> nodes) {
        if (socket == null) {
            throw new NullPointerException("socket is marked non-null but is null");
        }
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        String action = node.attrs().get("add");
        if (action == null) {
            return;
        }
        boolean last = Boolean.parseBoolean(node.attrs().getOrDefault("last", "false"));
        Set<CompletableFuture<Chat>> chats = this.processMessagesFromNodes(socket, nodes);
        if (!action.equals("last") && !last) {
            return;
        }
        chats.forEach(this::processMessages);
    }

    private void processMessages(@NonNull CompletableFuture<Chat> future) {
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
        this.callListeners(listener -> this.processMessages(future, (WhatsappListener)listener));
    }

    private void processMessages(@NonNull CompletableFuture<Chat> future, @NonNull WhatsappListener listener) {
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        future.thenAcceptAsync(listener::onChatRecentMessages);
    }

    private void parseReceivedStatus(@NonNull Node firstChildNode) {
        if (firstChildNode == null) {
            throw new NullPointerException("firstChildNode is marked non-null but is null");
        }
        Optional<Chat> chatOpt = this.findChatByJid(firstChildNode.attrs().get("jid"));
        if (chatOpt.isEmpty()) {
            return;
        }
        Chat chat = chatOpt.get();
        Optional<MessageInfo> messageOpt = this.findMessageById(chat, firstChildNode.attrs().get("index"));
        if (messageOpt.isEmpty()) {
            return;
        }
        MessageInfo message = messageOpt.get();
        MessageInfo.MessageInfoStatus status = MessageInfo.MessageInfoStatus.forName(firstChildNode.attrs().get("type"));
        if (status == null) {
            return;
        }
        if (status.index() <= message.globalStatus().index() && status != MessageInfo.MessageInfoStatus.ERROR) {
            return;
        }
        message.globalStatus(status);
        this.callListeners(listener -> listener.onMessageGlobalReadStatusUpdate(chat, message));
    }

    private void parseReadStatus(@NonNull Node firstChildNode) {
        if (firstChildNode == null) {
            throw new NullPointerException("firstChildNode is marked non-null but is null");
        }
        String jid = firstChildNode.attrs().get("jid");
        if (jid == null) {
            return;
        }
        boolean type = Boolean.parseBoolean(firstChildNode.attrs().getOrDefault("type", "true"));
        Optional<Chat> chatOpt = this.findChatByJid(jid);
        if (chatOpt.isEmpty()) {
            return;
        }
        Chat chat = chatOpt.get();
        chat.unreadMessages(type ? 0 : -1);
        this.callListeners(listener -> listener.onChatReadStatusChange(chat));
    }

    private void parseChats(@NonNull List<Node> nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes is marked non-null but is null");
        }
        nodes.stream().map(Node::attrs).map(Chat::fromAttributes).forEach(this::addChat);
        this.callListeners(WhatsappListener::onChats);
    }

    private void parseContacts(@NonNull List<Node> nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes is marked non-null but is null");
        }
        nodes.stream().map(Node::attrs).map(Contact::fromAttributes).forEach(this.contacts::add);
        this.callListeners(WhatsappListener::onContacts);
    }

    private Set<CompletableFuture<Chat>> processMessagesFromNodes(@NonNull WhatsappWebSocket socket, @NonNull List<Node> nodes) {
        if (socket == null) {
            throw new NullPointerException("socket is marked non-null but is null");
        }
        if (nodes == null) {
            throw new NullPointerException("nodes is marked non-null but is null");
        }
        return nodes.stream().filter(node -> node.content() instanceof MessageInfo).map(node -> (MessageInfo)node.content()).map(messageInfo -> this.processMessageFromNode(socket, (MessageInfo)messageInfo)).collect(Collectors.toUnmodifiableSet());
    }

    @NonNull
    private CompletableFuture<Chat> processMessageFromNode(@NonNull WhatsappWebSocket socket, @NonNull MessageInfo messageInfo) {
        if (socket == null) {
            throw new NullPointerException("socket is marked non-null but is null");
        }
        if (messageInfo == null) {
            throw new NullPointerException("messageInfo is marked non-null but is null");
        }
        return this.findChatByMessage(messageInfo).map(CompletableFuture::completedFuture).orElseGet(() -> this.queryMissingChat(socket, messageInfo.key().chatJid())).thenApplyAsync(chat -> this.processMessageFromNode(messageInfo, (Chat)chat));
    }

    @NonNull
    private Chat processMessageFromNode(@NonNull MessageInfo messageInfo, @NonNull Chat chat) {
        if (messageInfo == null) {
            throw new NullPointerException("messageInfo is marked non-null but is null");
        }
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        this.processMessage(chat, messageInfo);
        return chat;
    }

    private void processMessage(@NonNull Chat chat, @NonNull MessageInfo message) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.processServerMessage(chat, message);
        this.commitMessage(chat, message);
        this.broadcastMessage(chat, message);
    }

    private void broadcastMessage(@NonNull Chat chat, @NonNull MessageInfo message) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (this.initializationTimeStamp > message.timestamp()) {
            return;
        }
        this.updateUnreadMessages(message, chat);
        this.callListeners(listener -> listener.onNewMessage(chat, message));
    }

    private void commitMessage(@NonNull Chat chat, @NonNull MessageInfo message) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (!chat.messages().addOrReplace(message)) {
            return;
        }
        this.callListeners(listener -> listener.onMessageUpdate(chat, message));
    }

    private void processServerMessage(@NonNull Chat chat, @NonNull MessageInfo message) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (!message.container().isServerMessage()) {
            return;
        }
        ProtocolMessage protocolMessage = message.container().protocolMessage();
        switch (protocolMessage.type()) {
            case REVOKE: {
                this.processRevokeMessage(chat, protocolMessage);
                break;
            }
            case EPHEMERAL_SETTING: 
            case EPHEMERAL_SYNC_RESPONSE: {
                this.processEphemeralUpdate(chat, protocolMessage);
                break;
            }
            case HISTORY_SYNC_NOTIFICATION: {
                throw new UnsupportedOperationException("WhatsappWeb4j cannot handle history syncs as of now");
            }
        }
    }

    private void processEphemeralUpdate(@NonNull Chat chat, @NonNull ProtocolMessage protocolMessage) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (protocolMessage == null) {
            throw new NullPointerException("protocolMessage is marked non-null but is null");
        }
        chat.ephemeralMessagesToggleTime(protocolMessage.ephemeralSettingTimestamp());
        chat.ephemeralMessageDuration(protocolMessage.ephemeralExpiration());
    }

    private void processRevokeMessage(@NonNull Chat chat, @NonNull ProtocolMessage message) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        String id = message.key().id();
        this.findMessageById(chat, id).ifPresent(oldMessage -> this.processRevokeMessage(chat, (MessageInfo)oldMessage));
    }

    private void processRevokeMessage(@NonNull Chat chat, @NonNull MessageInfo oldMessage) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (oldMessage == null) {
            throw new NullPointerException("oldMessage is marked non-null but is null");
        }
        chat.messages().remove(oldMessage);
        this.callListeners(listener -> listener.onMessageDeleted(chat, oldMessage, true));
    }

    private void updateUnreadMessages(@NonNull MessageInfo message, Chat chat) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (message.key().fromMe() || message.globalStatus() == MessageInfo.MessageInfoStatus.READ || message.ignore()) {
            return;
        }
        chat.unreadMessages(chat.unreadMessages() + 1);
    }

    @NonNull
    private CompletableFuture<Chat> queryMissingChat(@NonNull WhatsappWebSocket socket, @NonNull String jid) {
        if (socket == null) {
            throw new NullPointerException("socket is marked non-null but is null");
        }
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return ((CompletableFuture)socket.queryChat(jid).thenApplyAsync(BinaryResponseModel::data)).thenApplyAsync(optional -> optional.isEmpty() ? null : this.addChat((Chat)optional.get()));
    }

    private void callOnListenerThread(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        this.requestsService.execute(runnable);
    }

    private WhatsappDataManager(@NonNull ExecutorService requestsService, @NonNull List<Chat> chats, @NonNull List<Contact> contacts, @NonNull List<Request<?, ?>> pendingRequests, @NonNull List<WhatsappListener> listeners, long initializationTimeStamp) {
        if (requestsService == null) {
            throw new NullPointerException("requestsService is marked non-null but is null");
        }
        if (chats == null) {
            throw new NullPointerException("chats is marked non-null but is null");
        }
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        if (pendingRequests == null) {
            throw new NullPointerException("pendingRequests is marked non-null but is null");
        }
        if (listeners == null) {
            throw new NullPointerException("listeners is marked non-null but is null");
        }
        this.requestsService = requestsService;
        this.chats = chats;
        this.contacts = contacts;
        this.pendingRequests = pendingRequests;
        this.listeners = listeners;
        this.initializationTimeStamp = initializationTimeStamp;
    }

    @NonNull
    public ExecutorService requestsService() {
        return this.requestsService;
    }

    @NonNull
    public List<Chat> chats() {
        return this.chats;
    }

    @NonNull
    public List<Contact> contacts() {
        return this.contacts;
    }

    @NonNull
    public List<Request<?, ?>> pendingRequests() {
        return this.pendingRequests;
    }

    @NonNull
    public List<WhatsappListener> listeners() {
        return this.listeners;
    }

    public long initializationTimeStamp() {
        return this.initializationTimeStamp;
    }

    public long tag() {
        return this.tag;
    }

    public WhatsappDataManager phoneNumberJid(String phoneNumberJid) {
        this.phoneNumberJid = phoneNumberJid;
        return this;
    }

    public WhatsappDataManager mediaConnection(MediaConnection mediaConnection) {
        this.mediaConnection = mediaConnection;
        return this;
    }

    public WhatsappDataManager tag(long tag) {
        this.tag = tag;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhatsappDataManager)) {
            return false;
        }
        WhatsappDataManager other = (WhatsappDataManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.initializationTimeStamp() != other.initializationTimeStamp()) {
            return false;
        }
        if (this.tag() != other.tag()) {
            return false;
        }
        ExecutorService this$requestsService = this.requestsService();
        ExecutorService other$requestsService = other.requestsService();
        if (this$requestsService == null ? other$requestsService != null : !this$requestsService.equals(other$requestsService)) {
            return false;
        }
        List<Chat> this$chats = this.chats();
        List<Chat> other$chats = other.chats();
        if (this$chats == null ? other$chats != null : !((Object)this$chats).equals(other$chats)) {
            return false;
        }
        List<Contact> this$contacts = this.contacts();
        List<Contact> other$contacts = other.contacts();
        if (this$contacts == null ? other$contacts != null : !((Object)this$contacts).equals(other$contacts)) {
            return false;
        }
        List<Request<?, ?>> this$pendingRequests = this.pendingRequests();
        List<Request<?, ?>> other$pendingRequests = other.pendingRequests();
        if (this$pendingRequests == null ? other$pendingRequests != null : !((Object)this$pendingRequests).equals(other$pendingRequests)) {
            return false;
        }
        List<WhatsappListener> this$listeners = this.listeners();
        List<WhatsappListener> other$listeners = other.listeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        String this$phoneNumberJid = this.phoneNumberJid();
        String other$phoneNumberJid = other.phoneNumberJid();
        if (this$phoneNumberJid == null ? other$phoneNumberJid != null : !this$phoneNumberJid.equals(other$phoneNumberJid)) {
            return false;
        }
        MediaConnection this$mediaConnection = this.mediaConnection();
        MediaConnection other$mediaConnection = other.mediaConnection();
        return !(this$mediaConnection == null ? other$mediaConnection != null : !((Object)this$mediaConnection).equals(other$mediaConnection));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WhatsappDataManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $initializationTimeStamp = this.initializationTimeStamp();
        result = result * 59 + (int)($initializationTimeStamp >>> 32 ^ $initializationTimeStamp);
        long $tag = this.tag();
        result = result * 59 + (int)($tag >>> 32 ^ $tag);
        ExecutorService $requestsService = this.requestsService();
        result = result * 59 + ($requestsService == null ? 43 : $requestsService.hashCode());
        List<Chat> $chats = this.chats();
        result = result * 59 + ($chats == null ? 43 : ((Object)$chats).hashCode());
        List<Contact> $contacts = this.contacts();
        result = result * 59 + ($contacts == null ? 43 : ((Object)$contacts).hashCode());
        List<Request<?, ?>> $pendingRequests = this.pendingRequests();
        result = result * 59 + ($pendingRequests == null ? 43 : ((Object)$pendingRequests).hashCode());
        List<WhatsappListener> $listeners = this.listeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        String $phoneNumberJid = this.phoneNumberJid();
        result = result * 59 + ($phoneNumberJid == null ? 43 : $phoneNumberJid.hashCode());
        MediaConnection $mediaConnection = this.mediaConnection();
        result = result * 59 + ($mediaConnection == null ? 43 : ((Object)$mediaConnection).hashCode());
        return result;
    }

    public String toString() {
        return "WhatsappDataManager(requestsService=" + this.requestsService() + ", chats=" + this.chats() + ", contacts=" + this.contacts() + ", pendingRequests=" + this.pendingRequests() + ", listeners=" + this.listeners() + ", initializationTimeStamp=" + this.initializationTimeStamp() + ", phoneNumberJid=" + this.phoneNumberJid() + ", mediaConnection=" + this.mediaConnection() + ", tag=" + this.tag() + ")";
    }

    public static WhatsappDataManager singletonInstance() {
        return singletonInstance;
    }
}

