/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.listener;

import it.auties.whatsapp4j.listener.RegisterListener;
import it.auties.whatsapp4j.listener.WhatsappListener;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import lombok.NonNull;

public final class RegisterListenerProcessor {
    private static final ClassLoader CLASS_LOADER = ClassLoader.getSystemClassLoader();
    private static final StandardJavaFileManager FILE_MANAGER = ToolProvider.getSystemJavaCompiler().getStandardFileManager(null, Locale.getDefault(), StandardCharsets.UTF_8);
    private static final StandardLocation CLASS_LOCATION = StandardLocation.CLASS_PATH;

    @NonNull
    public static List<WhatsappListener> queryAllListeners() {
        return Arrays.stream(CLASS_LOADER.getDefinedPackages()).flatMap(RegisterListenerProcessor::findClassesInPackage).filter(RegisterListenerProcessor::isListener).map(RegisterListenerProcessor::cast).map(RegisterListenerProcessor::newInstance).toList();
    }

    @NonNull
    private static Stream<Class<?>> findClassesInPackage(@NonNull Package pack) {
        if (pack == null) {
            throw new NullPointerException("pack is marked non-null but is null");
        }
        return StreamSupport.stream(FILE_MANAGER.list(CLASS_LOCATION, pack.getName(), Set.of(JavaFileObject.Kind.CLASS), true).spliterator(), true).map(RegisterListenerProcessor::loadClassFromFile).filter(Optional::isPresent).map(Optional::get);
    }

    @NonNull
    private static Optional<Class<?>> loadClassFromFile(@NonNull JavaFileObject file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try {
            return Optional.of(Class.forName(FILE_MANAGER.inferBinaryName(CLASS_LOCATION, file), false, CLASS_LOADER));
        }
        catch (ClassNotFoundException | NoClassDefFoundError error) {
            return Optional.empty();
        }
    }

    private static boolean isListener(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return clazz.isAnnotationPresent(RegisterListener.class);
    }

    @NonNull
    private static Class<? extends WhatsappListener> cast(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        try {
            return clazz.asSubclass(WhatsappListener.class);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("WhatsappAPI: Cannot initialize class %s, classes annotated with @RegisterListener should implement WhatsappListener".formatted(clazz.getName()));
        }
    }

    @NonNull
    private static WhatsappListener newInstance(@NonNull Class<? extends WhatsappListener> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException operationException) {
            throw new RuntimeException("WhatsappAPI: Cannot initialize class %s".formatted(clazz.getName()), operationException);
        }
    }

    private RegisterListenerProcessor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

