/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.binary;

import it.auties.whatsapp4j.binary.BinaryArray;
import java.util.stream.IntStream;
import lombok.NonNull;

public enum BinaryMetric {
    DEBUG_LOG(1),
    QUERY_RESUME(2),
    LIVE_LOCATION(3),
    QUERY_MEDIA(4),
    QUERY_CHAT(5),
    QUERY_CONTACT(6),
    QUERY_MESSAGES(7),
    PRESENCE(8),
    PRESENCE_SUBSCRIBE(9),
    GROUP(10),
    READ(11),
    CHAT(12),
    RECEIVED(13),
    PICTURE(14),
    STATUS(15),
    MESSAGE(16),
    QUERY_ACTIONS(17),
    BLOCK(18),
    QUERY_GROUP(19),
    QUERY_PREVIEW(20),
    QUERY_EMOJI(21),
    QUERY_VCARD(29),
    QUERY_STATUS(30),
    QUERY_STATUS_UPDATE(31),
    QUERY_LIVE_LOCATION(33),
    QUERY_LABEL(36),
    QUERY_QUICK_REPLY(39);

    private final int data;

    @NonNull
    public static BinaryArray toArray(BinaryMetric ... tags) {
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        byte[] data = new byte[tags.length];
        IntStream.range(0, tags.length).forEach(index -> {
            data[index] = (byte)tags[index].data();
        });
        return BinaryArray.forArray(data);
    }

    private BinaryMetric(int data) {
        this.data = data;
    }

    public int data() {
        return this.data;
    }
}

