/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.binary;

import it.auties.protobuf.encoder.ProtobufEncoder;
import it.auties.whatsapp4j.binary.BinaryTag;
import it.auties.whatsapp4j.binary.BinaryTokens;
import it.auties.whatsapp4j.protobuf.info.MessageInfo;
import it.auties.whatsapp4j.protobuf.model.Node;
import it.auties.whatsapp4j.utils.internal.Validate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import lombok.NonNull;

public record BinaryEncoder(@NonNull List<Byte> cache) {
    public BinaryEncoder(@NonNull List<Byte> cache) {
        if (cache == null) {
            throw new NullPointerException("cache is marked non-null but is null");
        }
    }

    public BinaryEncoder() {
        this(new ArrayList<Byte>());
    }

    public byte @NonNull [] encodeMessage(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        this.cache.clear();
        return this.writeNode(node);
    }

    private byte @NonNull [] writeNode(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        this.writeListStart(2 * node.attrs().size() + 1 + (node.content() != null ? 1 : 0));
        this.writeString(node.description(), false);
        this.writeAttributes(node.attrs());
        this.writeContent(node.content());
        return this.toByteArray();
    }

    private void pushUnsignedInt(int value) {
        this.cache.add((byte)(value & 0xFF));
    }

    private void pushInt4(int value) {
        IntStream.range(0, 4).map(i -> 3 - i).mapToObj(curShift -> (byte)(value >> curShift * 8 & 0xFF)).forEach(this.cache::add);
    }

    private void pushInt20(int value) {
        this.pushUnsignedInts(value >> 16 & 0xF, value >> 8 & 0xFF, value & 0xFF);
    }

    private void pushUnsignedInts(int ... ints) {
        if (ints == null) {
            throw new NullPointerException("ints is marked non-null but is null");
        }
        Arrays.stream(ints).mapToObj(entry -> (byte)entry).forEachOrdered(this.cache::add);
    }

    private void pushString(@NonNull String str) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        this.pushUnsignedInts(this.toUnsignedIntArray(str.getBytes()));
    }

    private void writeByteLength(int length) {
        BinaryTag tag = length >= 0x100000 ? BinaryTag.BINARY_32 : (length >= 256 ? BinaryTag.BINARY_20 : BinaryTag.BINARY_8);
        this.pushUnsignedInt(tag.data());
        switch (tag) {
            case BINARY_32: {
                this.pushInt4(length);
                break;
            }
            case BINARY_20: {
                this.pushInt20(length);
                break;
            }
            case BINARY_8: {
                this.pushUnsignedInt(length);
            }
        }
    }

    private void writeStringRaw(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        this.writeByteLength(string.length());
        this.pushString(string);
    }

    private void writeJid(String left, @NonNull String right) {
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        this.pushUnsignedInt(BinaryTag.JID_PAIR.data());
        if (left != null && left.length() > 0) {
            this.writeStrings(left, right);
            return;
        }
        this.writeToken(BinaryTag.LIST_EMPTY.data());
        this.writeString(right, false);
    }

    private void writeToken(int token) {
        Validate.isTrue(token <= 500, "Invalid token", new Object[0]);
        this.pushUnsignedInt(token);
    }

    private void writeString(@NonNull String token, boolean i) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        int tokenIndex = BinaryTokens.SINGLE_BYTE.indexOf(token);
        if (!i && token.equals("s.whatsapp.net")) {
            this.writeToken(tokenIndex);
            return;
        }
        if (tokenIndex >= 0) {
            if (tokenIndex < BinaryTag.SINGLE_BYTE_MAX.data()) {
                this.writeToken(tokenIndex);
                return;
            }
            int overflow = tokenIndex - BinaryTag.SINGLE_BYTE_MAX.data();
            int dictionaryIndex = overflow >> 8;
            Validate.isTrue(dictionaryIndex >= 0 && dictionaryIndex <= 3, "Token out of range!", new Object[0]);
            this.writeToken(BinaryTag.DICTIONARY_0.data() + dictionaryIndex);
            this.writeToken(overflow % 256);
            return;
        }
        int jidSepIndex = token.indexOf(64);
        if (jidSepIndex <= 0) {
            this.writeStringRaw(token);
            return;
        }
        this.writeJid(token.substring(0, jidSepIndex), token.substring(jidSepIndex + 1));
    }

    private void writeStrings(String ... tokens) {
        if (tokens == null) {
            throw new NullPointerException("tokens is marked non-null but is null");
        }
        Arrays.stream(tokens).forEach(token -> this.writeString((String)token, false));
    }

    private void writeAttributes(@NonNull Map<String, String> attrs) {
        if (attrs == null) {
            throw new NullPointerException("attrs is marked non-null but is null");
        }
        attrs.forEach((xva$0, xva$1) -> this.writeStrings((String)xva$0, (String)xva$1));
    }

    private void writeListStart(int listSize) {
        BinaryTag tag = listSize == 0 ? BinaryTag.LIST_EMPTY : (listSize < 256 ? BinaryTag.LIST_8 : BinaryTag.LIST_16);
        this.pushUnsignedInts(tag.data(), listSize);
    }

    private void writeContent(Object content) {
        if (content == null) {
            return;
        }
        if (content instanceof String) {
            String contentAsString = (String)content;
            this.writeString(contentAsString, true);
            return;
        }
        if (content instanceof List) {
            List contentAsList = (List)content;
            Validate.isTrue(this.validateList(contentAsList), "Cannot encode content(%s): expected List<WhatsappNode>, got %s<?>", content, contentAsList.getClass().getTypeName());
            this.writeListStart(contentAsList.size());
            Node.fromGenericList(contentAsList).forEach(this::writeNode);
            return;
        }
        if (content instanceof MessageInfo) {
            MessageInfo contentAsMessage = (MessageInfo)content;
            byte[] data = ProtobufEncoder.encode((Object)contentAsMessage);
            this.writeByteLength(data.length);
            this.pushUnsignedInts(this.toUnsignedIntArray(data));
            return;
        }
        throw new IllegalArgumentException("Cannot encode content " + content);
    }

    private boolean validateList(@NonNull List<?> list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        return list.stream().map(Object::getClass).allMatch(Node.class::isAssignableFrom);
    }

    private byte @NonNull [] toByteArray() {
        byte[] array = new byte[this.cache.size()];
        IntStream.range(0, this.cache.size()).forEachOrdered(x -> {
            array[x] = this.cache.get(x);
        });
        return array;
    }

    private int @NonNull [] toUnsignedIntArray(byte @NonNull [] input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return IntStream.range(0, input.length).map(x -> Byte.toUnsignedInt(input[x])).toArray();
    }
}

