/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.binary;

import it.auties.protobuf.decoder.ProtobufDecoder;
import it.auties.whatsapp4j.binary.BinaryArray;
import it.auties.whatsapp4j.binary.BinaryTag;
import it.auties.whatsapp4j.binary.BinaryTokens;
import it.auties.whatsapp4j.protobuf.info.MessageInfo;
import it.auties.whatsapp4j.protobuf.model.Node;
import it.auties.whatsapp4j.utils.internal.Validate;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;

public class BinaryDecoder {
    private BinaryArray buffer;
    private int index;

    @NonNull
    public Node decodeDecryptedMessage(@NonNull BinaryArray buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        this.buffer = buffer;
        this.index = 0;
        return this.readNode();
    }

    private int unpackNibble(int value) {
        int n;
        if (value >= 0 && value <= 9) {
            n = 48 + value;
        } else {
            switch (value) {
                case 10: {
                    n = 45;
                    break;
                }
                case 11: {
                    n = 46;
                    break;
                }
                case 15: {
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        return n;
    }

    private int unpackHex(int value) {
        return value >= 0 && value <= 15 ? (value < 10 ? 48 + value : 65 + value - 10) : 0;
    }

    private int unpackByte(int data, int value) {
        return switch (BinaryTag.forData(data)) {
            case BinaryTag.NIBBLE_8 -> this.unpackNibble(value);
            case BinaryTag.HEX_8 -> this.unpackHex(value);
            default -> throw new IllegalStateException("BinaryReader#unpackByte: unexpected tag: " + data);
        };
    }

    private int readInt(int n) {
        this.checkEOS(n);
        int val = 0;
        for (int i = 0; i < n; ++i) {
            int shift = n - 1 - i;
            val |= this.readUnsignedInt() << shift * 8;
        }
        return val;
    }

    private int readInt20() {
        this.checkEOS(3);
        int a = this.readUnsignedInt();
        int b = this.readUnsignedInt();
        int c = this.readUnsignedInt();
        return ((a & 0xF) << 16) + (b << 8) + c;
    }

    @NonNull
    private String readPacked8(int tag) {
        byte startByte = this.readByte();
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < (startByte & 0x7F); ++i) {
            byte curByte = this.readByte();
            value.append(String.valueOf(Character.toChars(this.unpackByte(tag, (curByte & 0xF0) >> 4))));
            value.append(String.valueOf(Character.toChars(this.unpackByte(tag, curByte & 0xF))));
        }
        return startByte >> 7 != 0 ? value.substring(0, value.length() - 1) : value.toString();
    }

    @NonNull
    private BinaryArray readBytes(int n) {
        this.checkEOS(n);
        BinaryArray byteArray = this.buffer.slice(this.index, this.index + n);
        this.index += n;
        return byteArray;
    }

    private byte readByte() {
        this.checkEOS(1);
        return this.buffer.at(this.index++);
    }

    private int readUnsignedInt() {
        return Byte.toUnsignedInt(this.readByte());
    }

    private boolean isListTag(int tag) {
        return tag == BinaryTag.LIST_EMPTY.data() || tag == BinaryTag.LIST_8.data() || tag == BinaryTag.LIST_16.data();
    }

    private boolean isBinaryTag(int tag) {
        return tag == BinaryTag.BINARY_8.data() || tag == BinaryTag.BINARY_20.data() || tag == BinaryTag.BINARY_32.data();
    }

    private int readListSize(int data) {
        return switch (BinaryTag.forData(data)) {
            case BinaryTag.LIST_EMPTY -> 0;
            case BinaryTag.LIST_8 -> this.readUnsignedInt();
            case BinaryTag.LIST_16 -> this.readInt(2);
            default -> throw new IllegalStateException("BinaryReader#readListSize: unexpected tag: " + data);
        };
    }

    @NonNull
    private String readStringFromCharacters(int length) {
        this.checkEOS(length);
        BinaryArray value = this.buffer.slice(this.index, this.index + length);
        this.index += length;
        return value.toString();
    }

    private String getToken(int index) {
        Validate.isTrue(index >= 3 && index < BinaryTokens.SINGLE_BYTE.size(), "Unexpected value: %s", index);
        return BinaryTokens.SINGLE_BYTE.get(index);
    }

    private String getDoubleToken(int index1, int index2) {
        int n = 256 * index1 + index2;
        Validate.isTrue(n >= 0 && n <= BinaryTokens.DOUBLE_BYTE.size(), "Unexpected value: " + n, new Object[0]);
        return BinaryTokens.DOUBLE_BYTE.get(n);
    }

    @NonNull
    private String readString(int data) {
        String string;
        if (data >= 3 && data <= 235) {
            string = this.getToken(data);
        } else {
            switch (BinaryTag.forData(data)) {
                case DICTIONARY_0: 
                case DICTIONARY_1: 
                case DICTIONARY_2: 
                case DICTIONARY_3: {
                    string = this.getDoubleToken(data - BinaryTag.DICTIONARY_0.data(), this.readByte());
                    break;
                }
                case BINARY_8: {
                    string = this.readStringFromCharacters(this.readByte());
                    break;
                }
                case BINARY_20: {
                    string = this.readStringFromCharacters(this.readInt20());
                    break;
                }
                case BINARY_32: {
                    string = this.readStringFromCharacters(this.readInt(4));
                    break;
                }
                case JID_PAIR: {
                    string = "%s@%s".formatted(this.readString(this.readUnsignedInt()), this.readString(this.readUnsignedInt()));
                    break;
                }
                case NIBBLE_8: 
                case HEX_8: {
                    string = this.readPacked8(data);
                    break;
                }
                default: {
                    throw new IllegalStateException("BinaryReader#readString: unexpected tag: " + data);
                }
            }
        }
        return string;
    }

    private Map<String, String> readAttributes(int n) {
        return IntStream.range(0, n).boxed().collect(Collectors.toMap(x -> this.readString(this.readUnsignedInt()), x -> this.readString(this.readUnsignedInt()), (a, b) -> b, HashMap::new));
    }

    @NonNull
    private Node readNode() {
        int listSize = this.readListSize(this.readUnsignedInt());
        Validate.isTrue(listSize != 0, "List size is empty", new Object[0]);
        int descriptionTag = this.readUnsignedInt();
        Validate.isTrue(descriptionTag != BinaryTag.STREAM_END.data(), "Unexpected stream end", new Object[0]);
        String description = this.readString(descriptionTag);
        Map<String, String> attrs = this.readAttributes(listSize - 1 >> 1);
        if (listSize % 2 != 0) {
            return new Node(description, attrs, null);
        }
        int tag = this.readUnsignedInt();
        return new Node(description, attrs, this.isListTag(tag) ? this.readList(tag) : (this.isBinaryTag(tag) ? this.parseMessage(description, tag) : this.readString(tag)));
    }

    @NonNull
    private Object parseMessage(@NonNull String description, int tag) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        BinaryArray data = switch (BinaryTag.forData(tag)) {
            case BinaryTag.BINARY_8 -> this.readBytes(this.readUnsignedInt());
            case BinaryTag.BINARY_20 -> this.readBytes(this.readInt20());
            case BinaryTag.BINARY_32 -> this.readBytes(this.readInt(4));
            default -> throw new IllegalStateException("BinaryReader#readNode: unexpected tag: " + tag);
        };
        return description.equals("message") ? this.decodeMessage(data) : data.toString();
    }

    @NonNull
    private MessageInfo decodeMessage(@NonNull BinaryArray data) throws IOException {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        try {
            return (MessageInfo)ProtobufDecoder.forType(MessageInfo.class).decode(data.data());
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Cannot deserialize %s".formatted(ProtobufDecoder.forType(MessageInfo.class).decodeAsJson(data.data())), ex);
        }
    }

    @NonNull
    private List<Node> readList(int tag) {
        return IntStream.range(0, this.readListSize(tag)).mapToObj(e -> this.readNode()).toList();
    }

    private void checkEOS(int length) {
        Validate.isTrue(this.index + length <= this.buffer.size(), "End of stream!", new Object[0]);
    }
}

