/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.encoder;

import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.protobuf.encoder.ArrayOutputStream;
import it.auties.protobuf.encoder.ProtobufField;
import it.auties.protobuf.util.IllegalReflection;
import it.auties.protobuf.util.ProtobufUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Stream;

public final class ProtobufEncoder {
    public static byte[] encode(Object object) {
        ArrayOutputStream output = new ArrayOutputStream();
        if (object == null) {
            return output.readResult();
        }
        return ProtobufEncoder.encodeObject(object, output);
    }

    private static byte[] encodeObject(Object object, ArrayOutputStream output) {
        Stream.of(object.getClass().getFields(), object.getClass().getDeclaredFields()).flatMap(Arrays::stream).filter(ProtobufEncoder::isProperty).map(IllegalReflection::opened).map(field -> ProtobufEncoder.createFieldOrThrow(object, field)).filter(ProtobufField::valid).forEach(field -> ProtobufEncoder.encodeField(output, field));
        return output.readResult();
    }

    private static boolean isProperty(Field field) {
        return field.isAnnotationPresent(JsonProperty.class);
    }

    private static ProtobufField createFieldOrThrow(Object object, Field field) {
        try {
            int index = ProtobufUtils.parseIndex(field);
            boolean required = ProtobufUtils.isRequired(field);
            Object value = field.get(object);
            String type = ProtobufUtils.parseType(field, value);
            return new ProtobufField(index, type, value, required);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException("Access failed: reflection opener failed", exception);
        }
    }

    private static void encodeField(ArrayOutputStream output, ProtobufField field) {
        switch (field.type()) {
            case "float": 
            case "fixed32": 
            case "sfixed32": {
                output.writeFixed32(field.index(), Float.floatToRawIntBits(((Float)field.value()).floatValue()));
                break;
            }
            case "double": 
            case "fixed64": 
            case "sfixed64": {
                output.writeFixed64(field.index(), Double.doubleToRawLongBits((Double)field.value()));
                break;
            }
            case "bool": {
                output.writeBool(field.index(), (Boolean)field.value());
                break;
            }
            case "string": {
                output.writeString(field.index(), (String)field.value());
                break;
            }
            case "bytes": {
                output.writeBytes(field.index(), (byte[])field.value());
                break;
            }
            case "int32": 
            case "uint32": 
            case "sint32": {
                output.writeUInt32(field.index(), (Integer)field.value());
                break;
            }
            case "int64": 
            case "uint64": 
            case "sint64": {
                output.writeUInt64(field.index(), (Long)field.value());
                break;
            }
            default: {
                ProtobufEncoder.encodeFieldFallback(output, field, field.index());
            }
        }
    }

    private static void encodeFieldFallback(ArrayOutputStream output, ProtobufField field, int number) {
        if (field.value() instanceof Enum) {
            output.writeUInt64(number, ProtobufEncoder.findEnumIndex(field.value()));
            return;
        }
        output.writeBytes(number, ProtobufEncoder.encode(field.value()));
    }

    private static int findEnumIndex(Object object) {
        try {
            return (Integer)IllegalReflection.opened(object.getClass().getMethod("index", new Class[0])).invoke(object, new Object[0]);
        }
        catch (Throwable throwable) {
            return ProtobufEncoder.findEnumIndexFallback(object);
        }
    }

    private static int findEnumIndexFallback(Object object) {
        try {
            return (Integer)IllegalReflection.opened(object.getClass().getMethod("ordinal", new Class[0])).invoke(object, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("An exception occurred while invoking the index method for the enum", throwable);
        }
    }

    private ProtobufEncoder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

