/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.encoder;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;

public record ArrayOutputStream(ByteArrayOutputStream buffer) {
    private static final int VAR_INT = 0;
    private static final int FIXED_32 = 5;
    private static final int FIXED_64 = 1;
    private static final int DELIMITED = 2;

    public ArrayOutputStream() {
        this(new ByteArrayOutputStream());
    }

    public void writeTag(int fieldNumber, int wireType) {
        this.writeUInt32NoTag(fieldNumber << 3 | wireType);
    }

    public void writeUInt32(int fieldNumber, int value) {
        this.writeTag(fieldNumber, 0);
        this.writeUInt32NoTag(value);
    }

    public void writeFixed32(int fieldNumber, int value) {
        this.writeTag(fieldNumber, 5);
        this.writeFixed32NoTag(value);
    }

    public void writeUInt64(int fieldNumber, long value) {
        this.writeTag(fieldNumber, 0);
        this.writeUInt64NoTag(value);
    }

    public void writeFixed64(int fieldNumber, long value) {
        this.writeTag(fieldNumber, 1);
        this.writeFixed64NoTag(value);
    }

    public void writeBool(int fieldNumber, boolean value) {
        this.writeTag(fieldNumber, 0);
        this.write((byte)(value ? 1 : 0));
    }

    public void writeString(int fieldNumber, String value) {
        this.writeTag(fieldNumber, 2);
        this.writeStringNoTag(value);
    }

    public void writeBytes(int fieldNumber, byte[] value) {
        this.writeTag(fieldNumber, 2);
        this.writeBytesNoTag(value);
    }

    public void writeBytesNoTag(byte[] value) {
        this.writeUInt32NoTag(value.length);
        this.buffer.write(value);
    }

    public void write(byte value) {
        this.buffer.write(value);
    }

    public void writeUInt32NoTag(int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.write((byte)value);
                return;
            }
            this.write((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    public void writeFixed32NoTag(int value) {
        this.write((byte)(value & 0xFF));
        this.write((byte)(value >> 8 & 0xFF));
        this.write((byte)(value >> 16 & 0xFF));
        this.write((byte)(value >> 24 & 0xFF));
    }

    public void writeUInt64NoTag(long value) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.write((byte)value);
                return;
            }
            this.write((byte)((int)value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    public void writeFixed64NoTag(long value) {
        this.write((byte)((int)value & 0xFF));
        this.write((byte)((int)(value >> 8) & 0xFF));
        this.write((byte)((int)(value >> 16) & 0xFF));
        this.write((byte)((int)(value >> 24) & 0xFF));
        this.write((byte)((int)(value >> 32) & 0xFF));
        this.write((byte)((int)(value >> 40) & 0xFF));
        this.write((byte)((int)(value >> 48) & 0xFF));
        this.write((byte)((int)(value >> 56) & 0xFF));
    }

    public void writeStringNoTag(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeBytesNoTag(bytes);
    }

    public byte[] readResult() {
        return this.buffer.toByteArray();
    }
}

