/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import com.alamkanak.weekview.Constants;
import com.alamkanak.weekview.WeekView;
import com.alamkanak.weekview.WeekViewConfig;
import java.util.Calendar;

final class WeekViewViewState {
    Calendar scrollToDay = null;
    int scrollToHour = -1;
    boolean isFirstDraw = true;
    boolean areDimensionsInvalid = true;
    Calendar firstVisibleDay;
    Calendar lastVisibleDay;
    boolean shouldRefreshEvents;

    WeekViewViewState() {
    }

    void update(WeekViewConfig config, UpdateListener listener) {
        if (!this.areDimensionsInvalid) {
            return;
        }
        float totalHeaderHeight = config.drawingConfig.headerHeight + (float)(config.headerRowPadding * 2) + config.drawingConfig.headerMarginBottom;
        int height = WeekView.getViewHeight();
        config.effectiveMinHourHeight = Math.max(config.minHourHeight, (int)(((float)height - totalHeaderHeight) / (float)Constants.HOURS_PER_DAY));
        this.areDimensionsInvalid = false;
        if (this.scrollToDay != null) {
            listener.goToDate(this.scrollToDay);
        }
        this.areDimensionsInvalid = false;
        if (this.scrollToHour >= 0) {
            listener.goToHour(this.scrollToHour);
        }
        this.scrollToDay = null;
        this.scrollToHour = -1;
        this.areDimensionsInvalid = false;
    }

    void invalidate() {
        this.areDimensionsInvalid = false;
    }

    static interface UpdateListener {
        public void goToDate(Calendar var1);

        public void goToHour(int var1);
    }
}

