/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.view.MotionEvent;
import com.alamkanak.weekview.DateUtils;
import com.alamkanak.weekview.WeekViewConfig;
import com.alamkanak.weekview.WeekViewDrawingConfig;
import java.util.Calendar;

final class WeekViewTouchHandler {
    private WeekViewConfig config;
    private WeekViewDrawingConfig drawingConfig;

    WeekViewTouchHandler(WeekViewConfig config) {
        this.config = config;
        this.drawingConfig = config.drawingConfig;
    }

    Calendar getTimeFromPoint(MotionEvent event) {
        float touchX = event.getX();
        float touchY = event.getY();
        float widthPerDay = this.drawingConfig.widthPerDay;
        float totalDayWidth = widthPerDay + (float)this.config.columnGap;
        float originX = this.drawingConfig.currentOrigin.x;
        float timeColumnWidth = this.drawingConfig.timeColumnWidth;
        int leftDaysWithGaps = (int)(Math.ceil(originX / totalDayWidth) * -1.0);
        float startPixel = originX + totalDayWidth * (float)leftDaysWithGaps + timeColumnWidth;
        int begin = leftDaysWithGaps + 1;
        int end = leftDaysWithGaps + this.config.numberOfVisibleDays + 1;
        for (int dayNumber = begin; dayNumber <= end; ++dayNumber) {
            float start = Math.max(startPixel, timeColumnWidth);
            boolean isVisibleHorizontally = startPixel + widthPerDay - start > 0.0f;
            boolean isWithinDay = touchX > start & touchX < startPixel + widthPerDay;
            if (isVisibleHorizontally && isWithinDay) {
                Calendar day = DateUtils.today();
                day.add(5, dayNumber - 1);
                float originY = this.drawingConfig.currentOrigin.y;
                float headerHeight = this.drawingConfig.headerHeight + (float)(this.config.headerRowPadding * 2) + this.drawingConfig.headerMarginBottom;
                float hourHeight = this.config.hourHeight;
                float pixelsFromZero = touchY - originY - headerHeight;
                int hour = (int)(pixelsFromZero / hourHeight);
                int minute = (int)(60.0f * (pixelsFromZero - (float)hour * hourHeight) / hourHeight);
                day.add(10, hour);
                day.set(12, minute);
                return day;
            }
            startPixel += totalDayWidth;
        }
        return null;
    }
}

