/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.graphics.Canvas;
import com.alamkanak.weekview.Constants;
import com.alamkanak.weekview.WeekView;
import com.alamkanak.weekview.WeekViewConfig;
import com.alamkanak.weekview.WeekViewDrawingConfig;

class TimeColumnDrawer {
    private WeekViewConfig config;
    private WeekViewDrawingConfig drawingConfig;

    TimeColumnDrawer(WeekViewConfig config) {
        this.config = config;
        this.drawingConfig = config.drawingConfig;
    }

    void drawTimeColumn(Canvas canvas) {
        float top = this.drawingConfig.headerHeight + (float)(this.config.headerRowPadding * 2) + (float)this.config.headerRowBottomLineWidth;
        int bottom = WeekView.getViewHeight();
        canvas.drawRect(0.0f, top, this.drawingConfig.timeColumnWidth, (float)bottom, this.drawingConfig.timeColumnBackgroundPaint);
        canvas.restore();
        canvas.save();
        canvas.clipRect(0.0f, top, this.drawingConfig.timeColumnWidth, (float)bottom);
        float headerHeight = top;
        for (int i = 1; i < Constants.HOURS_PER_DAY; ++i) {
            float headerBottomMargin = this.drawingConfig.headerMarginBottom;
            float heightOfHour = this.config.hourHeight * i;
            top = headerHeight + this.drawingConfig.currentOrigin.y + heightOfHour + headerBottomMargin;
            String time = this.drawingConfig.dateTimeInterpreter.interpretTime(i);
            if (time == null) {
                throw new IllegalStateException("A DateTimeInterpreter must not return null time");
            }
            if (!(top < (float)bottom)) continue;
            float x = this.drawingConfig.timeTextWidth + (float)this.config.timeColumnPadding;
            float y = top + this.drawingConfig.timeTextHeight / 2.0f;
            canvas.drawText(time, x, y, this.drawingConfig.timeTextPaint);
        }
        if (this.config.showTimeColumnSeparator) {
            float lineX = this.drawingConfig.timeColumnWidth - (float)this.config.timeColumnSeparatorStrokeWidth;
            canvas.drawLine(lineX, headerHeight, lineX, (float)bottom, this.drawingConfig.timeColumnSeparatorPaint);
        }
        canvas.restore();
    }
}

