/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.graphics.Canvas;
import com.alamkanak.weekview.DateUtils;
import com.alamkanak.weekview.DrawingContext;
import com.alamkanak.weekview.WeekViewConfig;
import com.alamkanak.weekview.WeekViewDrawingConfig;
import java.util.Calendar;

class NowLineDrawer {
    private WeekViewConfig config;
    private WeekViewDrawingConfig drawConfig;

    NowLineDrawer(WeekViewConfig config) {
        this.config = config;
        this.drawConfig = config.drawingConfig;
    }

    void draw(DrawingContext drawingContext, Canvas canvas) {
        Calendar today = DateUtils.today();
        float startPixel = drawingContext.startPixel;
        for (Calendar day : drawingContext.dayRange) {
            boolean isSameDay = DateUtils.isSameDay(day, today);
            float startX = Math.max(startPixel, this.drawConfig.timeColumnWidth);
            if (this.config.isSingleDay()) {
                startPixel += (float)this.config.eventMarginHorizontal;
            }
            if (this.config.showNowLine && isSameDay) {
                this.drawLine(startX, startPixel, canvas);
            }
            startPixel += this.config.getTotalDayWidth();
        }
    }

    private void drawLine(float startX, float startPixel, Canvas canvas) {
        float headerHeight = this.drawConfig.headerHeight + (float)(this.config.headerRowPadding * 2) + this.drawConfig.headerMarginBottom;
        float startY = headerHeight + this.drawConfig.currentOrigin.y;
        Calendar now = Calendar.getInstance();
        float portionOfDay = (float)now.get(11) + (float)now.get(12) / 60.0f;
        float beforeNow = portionOfDay * (float)this.config.hourHeight;
        float lineStartY = startY + beforeNow;
        canvas.drawLine(startX, lineStartY, startPixel + this.drawConfig.widthPerDay, lineStartY, this.drawConfig.nowLinePaint);
        if (this.config.showNowLineDot) {
            float dotRadius = this.drawConfig.nowDotPaint.getStrokeWidth();
            float dotMargin = 32.0f;
            canvas.drawCircle(startPixel + 32.0f, lineStartY, dotRadius, this.drawConfig.nowDotPaint);
        }
    }
}

