/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import com.alamkanak.weekview.DateUtils;
import com.alamkanak.weekview.WeekViewDisplayable;
import com.alamkanak.weekview.WeekViewEvent;
import com.alamkanak.weekview.WeekViewLoader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class MonthLoader<T>
implements WeekViewLoader<T> {
    private MonthChangeListener<T> onMonthChangeListener;

    MonthLoader(MonthChangeListener<T> listener) {
        this.onMonthChangeListener = listener;
    }

    @Override
    public double toWeekViewPeriodIndex(Calendar instance) {
        return (double)(instance.get(1) * 12 + instance.get(2)) + (double)(instance.get(5) - 1) / 30.0;
    }

    @Override
    public List<WeekViewEvent<T>> onLoad(int periodIndex) {
        int year = periodIndex / 12;
        int month = periodIndex % 12;
        Calendar startDate = DateUtils.withTimeAtStartOfDay(DateUtils.today());
        startDate.set(1, year);
        startDate.set(2, month);
        startDate.set(5, 1);
        int maxDays = startDate.getActualMaximum(5);
        Calendar endDate = DateUtils.withTimeAtEndOfDay(DateUtils.today());
        endDate.set(1, year);
        endDate.set(2, month);
        endDate.set(5, maxDays);
        List<WeekViewDisplayable<T>> displayableItems = this.onMonthChangeListener.onMonthChange(startDate, endDate);
        ArrayList<WeekViewEvent<T>> events = new ArrayList<WeekViewEvent<T>>();
        for (WeekViewDisplayable<T> displayableItem : displayableItems) {
            events.add(displayableItem.toWeekViewEvent());
        }
        return events;
    }

    MonthChangeListener getOnMonthChangeListener() {
        return this.onMonthChangeListener;
    }

    void setOnMonthChangeListener(MonthChangeListener<T> onMonthChangeListener) {
        this.onMonthChangeListener = onMonthChangeListener;
    }

    public static interface MonthChangeListener<T> {
        public List<WeekViewDisplayable<T>> onMonthChange(Calendar var1, Calendar var2);
    }
}

