/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.view.View;
import com.alamkanak.weekview.EventChip;
import com.alamkanak.weekview.WeekViewConfig;
import com.alamkanak.weekview.WeekViewData;
import com.alamkanak.weekview.WeekViewEvent;
import com.alamkanak.weekview.WeekViewException;
import com.alamkanak.weekview.WeekViewLoader;
import com.alamkanak.weekview.WeekViewViewState;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

class EventChipsProvider<T> {
    private WeekViewConfig config;
    private WeekViewData<T> data;
    private WeekViewLoader<T> weekViewLoader;
    private WeekViewViewState viewState;

    EventChipsProvider(WeekViewConfig config, WeekViewData<T> data, WeekViewViewState viewState) {
        this.config = config;
        this.data = data;
        this.viewState = viewState;
    }

    void setWeekViewLoader(WeekViewLoader<T> weekViewLoader) {
        this.weekViewLoader = weekViewLoader;
    }

    void loadEventsIfNecessary(View view, List<Calendar> dayRange) {
        if (view.isInEditMode()) {
            return;
        }
        if (this.weekViewLoader == null) {
            throw new WeekViewException("No WeekViewLoader or MonthChangeListener provided. This is necessary to load new events");
        }
        for (Calendar day : dayRange) {
            boolean needsToFetchPeriod;
            boolean hasNoEvents = this.data.getAllEventChips() == null;
            boolean bl = needsToFetchPeriod = (double)this.data.fetchedPeriod != this.weekViewLoader.toWeekViewPeriodIndex(day) && Math.abs((double)this.data.fetchedPeriod - this.weekViewLoader.toWeekViewPeriodIndex(day)) > 0.5;
            if (!hasNoEvents && !this.viewState.shouldRefreshEvents && !needsToFetchPeriod) continue;
            this.loadEventsAndCalculateEventChipPositions(view, day);
            this.viewState.shouldRefreshEvents = false;
        }
    }

    private void loadEventsAndCalculateEventChipPositions(View view, Calendar day) {
        if (this.data.getAllEventChips() == null) {
            this.data.setEventChips(new ArrayList());
        }
        if (this.weekViewLoader == null && !view.isInEditMode()) {
            throw new IllegalStateException("You must provide a MonthChangeListener");
        }
        if (this.viewState.shouldRefreshEvents) {
            this.data.clear();
        }
        if (this.weekViewLoader != null) {
            this.loadEvents(day);
        }
        this.calculateEventChipPositions();
    }

    private void loadEvents(Calendar day) {
        boolean isRefreshEligible;
        int periodToFetch = (int)this.weekViewLoader.toWeekViewPeriodIndex(day);
        boolean bl = isRefreshEligible = this.data.fetchedPeriod < 0 || this.data.fetchedPeriod != periodToFetch || this.viewState.shouldRefreshEvents;
        if (!isRefreshEligible) {
            return;
        }
        List<WeekViewEvent<T>> previousPeriodEvents = null;
        List<WeekViewEvent<T>> currentPeriodEvents = null;
        List<WeekViewEvent<T>> nextPeriodEvents = null;
        if (this.data.previousPeriodEvents != null && this.data.currentPeriodEvents != null && this.data.nextPeriodEvents != null) {
            if (periodToFetch == this.data.fetchedPeriod - 1) {
                currentPeriodEvents = this.data.previousPeriodEvents;
                nextPeriodEvents = this.data.currentPeriodEvents;
            } else if (periodToFetch == this.data.fetchedPeriod) {
                previousPeriodEvents = this.data.previousPeriodEvents;
                currentPeriodEvents = this.data.currentPeriodEvents;
                nextPeriodEvents = this.data.nextPeriodEvents;
            } else if (periodToFetch == this.data.fetchedPeriod + 1) {
                previousPeriodEvents = this.data.currentPeriodEvents;
                currentPeriodEvents = this.data.nextPeriodEvents;
            }
        }
        if (currentPeriodEvents == null) {
            currentPeriodEvents = this.weekViewLoader.onLoad(periodToFetch);
        }
        if (previousPeriodEvents == null) {
            previousPeriodEvents = this.weekViewLoader.onLoad(periodToFetch - 1);
        }
        if (nextPeriodEvents == null) {
            nextPeriodEvents = this.weekViewLoader.onLoad(periodToFetch + 1);
        }
        this.data.getAllEventChips().clear();
        this.data.sortAndCacheEvents(previousPeriodEvents);
        this.data.sortAndCacheEvents(currentPeriodEvents);
        this.data.sortAndCacheEvents(nextPeriodEvents);
        this.data.previousPeriodEvents = previousPeriodEvents;
        this.data.currentPeriodEvents = currentPeriodEvents;
        this.data.nextPeriodEvents = nextPeriodEvents;
        this.data.fetchedPeriod = periodToFetch;
    }

    private void calculateEventChipPositions() {
        List<EventChip<T>> tempEvents = this.data.getAllEventChips();
        ArrayList results = new ArrayList();
        while (!tempEvents.isEmpty()) {
            ArrayList<EventChip<T>> eventChips = new ArrayList<EventChip<T>>();
            EventChip<T> firstRect = tempEvents.remove(0);
            eventChips.add(firstRect);
            int i = 0;
            while (i < tempEvents.size()) {
                EventChip<T> eventChip = tempEvents.get(i);
                WeekViewEvent event = eventChip.event;
                if (firstRect.event.isSameDay(event)) {
                    tempEvents.remove(i);
                    eventChips.add(eventChip);
                    continue;
                }
                ++i;
            }
            this.computePositionOfEvents(eventChips);
            results.addAll(eventChips);
        }
        this.data.setEventChips(results);
    }

    private void computePositionOfEvents(List<EventChip<T>> eventChips) {
        ArrayList collisionGroups = new ArrayList();
        for (EventChip<T> eventChip : eventChips) {
            boolean isPlaced = false;
            block1: for (List list : collisionGroups) {
                for (EventChip groupEvent : list) {
                    if (!groupEvent.event.collidesWith(eventChip.event) || groupEvent.event.isAllDay() != eventChip.event.isAllDay()) continue;
                    list.add(eventChip);
                    isPlaced = true;
                    break block1;
                }
            }
            if (isPlaced) continue;
            ArrayList<EventChip<T>> newGroup = new ArrayList<EventChip<T>>();
            newGroup.add(eventChip);
            collisionGroups.add(newGroup);
        }
        for (List list : collisionGroups) {
            this.expandEventsToMaxWidth(list);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void expandEventsToMaxWidth(List<EventChip> collisionGroup) {
        void var4_8;
        ArrayList columns = new ArrayList();
        columns.add(new ArrayList());
        for (EventChip eventChip : collisionGroup) {
            boolean bl = false;
            for (List list : columns) {
                if (list.size() == 0) {
                    list.add(eventChip);
                    bl = true;
                    continue;
                }
                if (eventChip.event.collidesWith(((EventChip)list.get((int)(list.size() - 1))).event)) continue;
                list.add(eventChip);
                bl = true;
                break;
            }
            if (bl) continue;
            ArrayList<EventChip> newColumn = new ArrayList<EventChip>();
            newColumn.add(eventChip);
            columns.add(newColumn);
        }
        int maxRowCount = 0;
        for (List list : columns) {
            maxRowCount = Math.max(maxRowCount, list.size());
        }
        boolean bl = false;
        while (var4_8 < maxRowCount) {
            float f = 0.0f;
            for (List list : columns) {
                if (list.size() >= var4_8 + true) {
                    EventChip eventChip = (EventChip)list.get((int)var4_8);
                    eventChip.width = 1.0f / (float)columns.size();
                    eventChip.left = f / (float)columns.size();
                    if (!eventChip.event.isAllDay()) {
                        eventChip.top = eventChip.event.getStartTime().get(11) * 60 + eventChip.event.getStartTime().get(12);
                        eventChip.bottom = eventChip.event.getEndTime().get(11) * 60 + eventChip.event.getEndTime().get(12);
                    } else {
                        eventChip.top = 0.0f;
                        eventChip.bottom = this.config.allDayEventHeight;
                    }
                }
                f += 1.0f;
            }
            ++var4_8;
        }
    }
}

