/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.graphics.RectF;
import com.alamkanak.weekview.Constants;
import com.alamkanak.weekview.EventChip;
import com.alamkanak.weekview.WeekViewConfig;

class EventChipRectCalculator {
    private WeekViewConfig config;

    EventChipRectCalculator(WeekViewConfig config) {
        this.config = config;
    }

    RectF calculateSingleEvent(EventChip eventChip, float startFromPixel) {
        boolean hasNoOverlaps;
        float right;
        float eventMargin = this.config.eventMarginVertical;
        float verticalOrigin = this.config.drawingConfig.currentOrigin.y;
        float widthPerDay = this.config.drawingConfig.widthPerDay;
        float headerHeight = this.config.drawingConfig.headerHeight;
        float headerPadding = this.config.headerRowPadding * 2;
        float headerBottomMargin = this.config.drawingConfig.headerMarginBottom;
        float totalHeaderHeight = headerHeight + headerPadding + headerBottomMargin;
        float verticalDistanceFromTop = (float)(this.config.hourHeight * Constants.HOURS_PER_DAY) * eventChip.top / (float)Constants.MINUTES_PER_DAY;
        float top = verticalDistanceFromTop + verticalOrigin + totalHeaderHeight + eventMargin;
        float verticalDistanceFromBottom = (float)(this.config.hourHeight * Constants.HOURS_PER_DAY) * eventChip.bottom / (float)Constants.MINUTES_PER_DAY;
        float bottom = verticalDistanceFromBottom + verticalOrigin + totalHeaderHeight - eventMargin;
        float left = startFromPixel + eventChip.left * widthPerDay;
        if (left < startFromPixel) {
            left += (float)this.config.overlappingEventGap;
        }
        if ((right = left + eventChip.width * widthPerDay) < startFromPixel + widthPerDay) {
            right -= (float)this.config.overlappingEventGap;
        }
        boolean bl = hasNoOverlaps = right == startFromPixel + widthPerDay;
        if (this.config.numberOfVisibleDays == 1 && hasNoOverlaps) {
            right -= (float)(this.config.eventMarginHorizontal * 2);
        }
        return new RectF(left, top, right, bottom);
    }

    RectF calculateAllDayEvent(EventChip eventChip, float startFromPixel) {
        boolean hasNoOverlaps;
        float right;
        float headerHeight = (float)(this.config.headerRowPadding * 2) + this.config.drawingConfig.headerMarginBottom;
        float widthPerDay = this.config.drawingConfig.widthPerDay;
        float halfTextHeight = this.config.drawingConfig.timeTextHeight / 2.0f;
        float top = headerHeight + halfTextHeight + (float)this.config.eventMarginVertical;
        float bottom = top + eventChip.bottom;
        float left = startFromPixel + eventChip.left * widthPerDay;
        if (left < startFromPixel) {
            left += (float)this.config.overlappingEventGap;
        }
        if ((right = left + eventChip.width * widthPerDay) < startFromPixel + widthPerDay) {
            right -= (float)this.config.overlappingEventGap;
        }
        boolean bl = hasNoOverlaps = right == startFromPixel + widthPerDay;
        if (this.config.numberOfVisibleDays == 1 && hasNoOverlaps) {
            right -= (float)(this.config.eventMarginHorizontal * 2);
        }
        return new RectF(left, top, right, bottom);
    }
}

