/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.view.MotionEvent;
import com.alamkanak.weekview.WeekViewConfig;
import com.alamkanak.weekview.WeekViewEvent;

class EventChip<T> {
    WeekViewEvent<T> event;
    WeekViewEvent<T> originalEvent;
    RectF rect;
    float left;
    float width;
    float top;
    float bottom;

    EventChip(WeekViewEvent<T> event, WeekViewEvent<T> originalEvent, RectF rect) {
        this.event = event;
        this.rect = rect;
        this.originalEvent = originalEvent;
    }

    void draw(WeekViewConfig config, Canvas canvas) {
        this.draw(config, null, canvas);
    }

    void draw(WeekViewConfig config, @Nullable StaticLayout textLayout, Canvas canvas) {
        float cornerRadius = config.eventCornerRadius;
        Paint backgroundPaint = this.getBackgroundPaint();
        canvas.drawRoundRect(this.rect, cornerRadius, cornerRadius, backgroundPaint);
        if (textLayout != null) {
            this.drawEventTitle(config, textLayout, canvas);
        } else {
            this.calculateTextHeightAndDrawTitle(config, canvas);
        }
    }

    private Paint getBackgroundPaint() {
        Paint paint = new Paint();
        paint.setColor(this.event.getColorOrDefault());
        return paint;
    }

    private void calculateTextHeightAndDrawTitle(WeekViewConfig config, Canvas canvas) {
        int availableWidth;
        TextPaint textPaint;
        StaticLayout textLayout;
        int lineHeight;
        int availableHeight;
        boolean negativeHeight;
        boolean negativeWidth = this.rect.right - this.rect.left - (float)(config.eventPadding * 2) < 0.0f;
        boolean bl = negativeHeight = this.rect.bottom - this.rect.top - (float)(config.eventPadding * 2) < 0.0f;
        if (negativeWidth || negativeHeight) {
            return;
        }
        SpannableStringBuilder stringBuilder = new SpannableStringBuilder();
        if (this.event.getTitle() != null) {
            stringBuilder.append((CharSequence)this.event.getTitle());
            stringBuilder.setSpan((Object)new StyleSpan(1), 0, stringBuilder.length(), 0);
        }
        if (this.event.getLocation() != null) {
            stringBuilder.append(' ');
            stringBuilder.append((CharSequence)this.event.getLocation());
        }
        if ((availableHeight = (int)(this.rect.bottom - this.rect.top - (float)(config.eventPadding * 2))) >= (lineHeight = (textLayout = new StaticLayout((CharSequence)stringBuilder, textPaint = config.drawingConfig.eventTextPaint, availableWidth = (int)(this.rect.right - this.rect.left - (float)(config.eventPadding * 2)), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false)).getHeight() / textLayout.getLineCount())) {
            int availableLineCount = availableHeight / lineHeight;
            do {
                int availableArea = availableLineCount * availableWidth;
                CharSequence ellipsized = TextUtils.ellipsize((CharSequence)stringBuilder, (TextPaint)textPaint, (float)availableArea, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
                int width = (int)(this.rect.right - this.rect.left - (float)(config.eventPadding * 2));
                textLayout = new StaticLayout(ellipsized, textPaint, width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
                --availableLineCount;
            } while (textLayout.getHeight() > availableHeight);
            this.drawEventTitle(config, textLayout, canvas);
        }
    }

    private void drawEventTitle(WeekViewConfig config, StaticLayout textLayout, Canvas canvas) {
        canvas.save();
        canvas.translate(this.rect.left + (float)config.eventPadding, this.rect.top + (float)config.eventPadding);
        textLayout.draw(canvas);
        canvas.restore();
    }

    boolean isHit(MotionEvent e) {
        if (this.rect == null) {
            return false;
        }
        return e.getX() > this.rect.left && e.getX() < this.rect.right && e.getY() > this.rect.top && e.getY() < this.rect.bottom;
    }
}

