/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.content.Context;
import android.text.format.DateFormat;
import com.alamkanak.weekview.Constants;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

class DateUtils {
    DateUtils() {
    }

    static List<Calendar> getDateRange(int daysSinceToday, int size) {
        ArrayList<Calendar> days = new ArrayList<Calendar>();
        for (int dayNumber = daysSinceToday; dayNumber <= size; ++dayNumber) {
            Calendar day = DateUtils.today();
            day.add(5, dayNumber - 1);
            days.add(day);
        }
        return days;
    }

    static Calendar withTimeAtStartOfDay(Calendar date) {
        Calendar newDate = (Calendar)date.clone();
        newDate.set(11, 0);
        newDate.set(12, 0);
        newDate.set(13, 0);
        newDate.set(14, 0);
        return newDate;
    }

    static Calendar withTimeAtEndOfDay(Calendar date) {
        Calendar newDate = (Calendar)date.clone();
        newDate.set(11, 23);
        newDate.set(12, 59);
        newDate.set(13, 59);
        newDate.set(14, 999);
        return newDate;
    }

    static int getDaysUntilDate(Calendar date) {
        long dateInMillis = date.getTimeInMillis();
        long todayInMillis = DateUtils.today().getTimeInMillis();
        long diff = dateInMillis - todayInMillis;
        return (int)(diff / Constants.DAY_IN_MILLIS);
    }

    static boolean isSameDay(Calendar dayOne, Calendar dayTwo) {
        return dayOne.get(1) == dayTwo.get(1) && dayOne.get(6) == dayTwo.get(6);
    }

    static boolean isAtStartOfNewDay(Calendar date1, Calendar date2) {
        if (date2 == DateUtils.withTimeAtStartOfDay(date2)) {
            date2.add(14, -1);
            return DateUtils.isSameDay(date1, date2);
        }
        return false;
    }

    static Calendar today() {
        Calendar today = Calendar.getInstance();
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        return today;
    }

    static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("EEEEE M/dd", Locale.getDefault());
    }

    static SimpleDateFormat getTimeFormat(Context context) {
        return DateFormat.is24HourFormat((Context)context) ? new SimpleDateFormat("HH:mm", Locale.getDefault()) : new SimpleDateFormat("hh a", Locale.getDefault());
    }
}

