/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.graphics.Canvas;
import com.alamkanak.weekview.Constants;
import com.alamkanak.weekview.DrawingContext;
import com.alamkanak.weekview.WeekView;
import com.alamkanak.weekview.WeekViewConfig;
import com.alamkanak.weekview.WeekViewDrawingConfig;

class BackgroundGridDrawer {
    private WeekViewConfig config;
    private WeekViewDrawingConfig drawConfig;

    BackgroundGridDrawer(WeekViewConfig config) {
        this.config = config;
        this.drawConfig = config.drawingConfig;
    }

    public void draw(DrawingContext drawingContext, Canvas canvas) {
        int size = drawingContext.dayRange.size();
        float startPixel = drawingContext.startPixel;
        for (int i = 0; i < size; ++i) {
            float startX = Math.max(startPixel, this.drawConfig.timeColumnWidth);
            float[] hourLines = this.getHourLines();
            this.drawGrid(hourLines, startX, startPixel, canvas);
            if (this.config.isSingleDay()) {
                startPixel += (float)this.config.eventMarginHorizontal;
            }
            startPixel += this.config.getTotalDayWidth();
        }
    }

    private float[] getHourLines() {
        WeekViewDrawingConfig drawConfig = this.config.drawingConfig;
        int height = WeekView.getViewHeight();
        float headerHeight = drawConfig.headerHeight + (float)(this.config.headerRowPadding * 2) + drawConfig.headerMarginBottom;
        int lineCount = (int)(((float)height - headerHeight) / (float)this.config.hourHeight) + 1;
        return new float[(lineCount *= this.config.numberOfVisibleDays + 1) * 4];
    }

    private void drawGrid(float[] hourLines, float startX, float startPixel, Canvas canvas) {
        if (this.config.showHourSeparator) {
            this.drawHourLines(hourLines, startX, startPixel, canvas);
        }
        if (this.config.showDaySeparator) {
            this.drawDaySeparators(startPixel, canvas);
        }
    }

    private void drawDaySeparators(float startPixel, Canvas canvas) {
        int days = this.config.numberOfVisibleDays;
        float widthPerDay = this.config.getTotalDayWidth();
        float top = this.drawConfig.headerHeight + (float)(this.config.headerRowPadding * 2) + this.drawConfig.headerMarginBottom;
        int height = WeekView.getViewHeight();
        for (int i = 0; i < days; ++i) {
            float start = startPixel + widthPerDay * (float)(i + 1);
            canvas.drawLine(start, top, start, top + (float)height, this.drawConfig.daySeparatorPaint);
        }
    }

    private void drawHourLines(float[] hourLines, float startX, float startPixel, Canvas canvas) {
        int height = WeekView.getViewHeight();
        float headerHeight = this.drawConfig.headerHeight + (float)(this.config.headerRowPadding * 2);
        int i = 0;
        for (int hour = 1; hour < Constants.HOURS_PER_DAY; ++hour) {
            boolean isVisibleHorizontally;
            float heightOfHour = this.config.hourHeight * hour;
            float top = headerHeight + this.drawConfig.currentOrigin.y + heightOfHour;
            float widthPerDay = this.config.getTotalDayWidth();
            float separatorWidth = this.config.hourSeparatorStrokeWidth;
            boolean isNotHiddenByHeader = top > headerHeight - separatorWidth;
            boolean isWithinVisibleRange = top < (float)height;
            boolean bl = isVisibleHorizontally = startPixel + widthPerDay - startX > 0.0f;
            if (!isNotHiddenByHeader || !isWithinVisibleRange || !isVisibleHorizontally) continue;
            hourLines[i * 4] = startX;
            hourLines[i * 4 + 1] = top;
            hourLines[i * 4 + 2] = startPixel + widthPerDay;
            hourLines[i * 4 + 3] = top;
            ++i;
        }
        canvas.drawLines(hourLines, this.drawConfig.hourSeparatorPaint);
    }
}

