/*
 * Decompiled with CFR 0.152.
 */
package com.github.arturopala.bufferandslice;

import com.github.arturopala.bufferandslice.Buffer;
import com.github.arturopala.bufferandslice.DeferredArrayBuffer;
import com.github.arturopala.bufferandslice.Slice;
import com.github.arturopala.bufferandslice.Slice$;
import scala.Function1;
import scala.runtime.BoxesRunTime;

public class RangeMapSlice<T>
implements Slice<T> {
    private final int fromIndex;
    private final int toIndex;
    private final Function1<Object, T> mapF;
    private final int length;

    public RangeMapSlice(int fromIndex, int toIndex, Function1<Object, T> mapF) {
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.mapF = mapF;
        this.length = toIndex - fromIndex;
    }

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public final T read(int index) {
        return (T)this.mapF.apply((Object)BoxesRunTime.boxToInteger((int)(this.fromIndex + index)));
    }

    @Override
    public final <T1> Slice<T1> update(int index, T1 value) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException(new StringBuilder(58).append("Expected an `update` index in the interval [0,").append(this.length()).append("), but was ").append(index).append(".").toString());
        }
        return Slice$.MODULE$.of(this.toBuffer().update(index, value).asArray());
    }

    @Override
    public final <K> RangeMapSlice<K> map(Function1<T, K> f) {
        return new RangeMapSlice<T>(this.fromIndex, this.toIndex, this.mapF.andThen(f));
    }

    @Override
    public final RangeMapSlice slice(int from, int to) {
        int t = RangeMapSlice.fit$1(to, this.length());
        int f = RangeMapSlice.fit$1(from, t);
        return f == 0 && t == this.length() ? this : new RangeMapSlice<T>(this.fromIndex + f, this.fromIndex + t, this.mapF);
    }

    @Override
    public final Object asArray() {
        return this.toBuffer().asArray();
    }

    @Override
    public final RangeMapSlice detach() {
        return this;
    }

    @Override
    public final <T1> Buffer<T1> toBuffer() {
        return new DeferredArrayBuffer(0).appendSlice((Slice)this);
    }

    @Override
    public final Buffer<T> asBuffer() {
        return this.toBuffer();
    }

    private static final int fit$1(int value, int upper) {
        return Math.min(Math.max(0, value), upper);
    }
}

