/*
 * Decompiled with CFR 0.152.
 */
package com.github.arturopala.bufferandslice;

import com.github.arturopala.bufferandslice.ArrayBufferLike;
import com.github.arturopala.bufferandslice.ArrayOps$;
import com.github.arturopala.bufferandslice.ArraySlice;
import com.github.arturopala.bufferandslice.Buffer;
import com.github.arturopala.bufferandslice.DeferredArrayBuffer$;
import com.github.arturopala.bufferandslice.Slice;
import com.github.arturopala.bufferandslice.Slice$;
import scala.Array$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.ScalaRunTime$;

public final class DeferredArrayBuffer<T>
implements ArrayBufferLike<T> {
    private int com$github$arturopala$bufferandslice$Buffer$$topIndex;
    private final int initialLength;
    private boolean pristine;
    private int initialSize;
    private Object _array;

    public static <T> int apply$default$1() {
        return DeferredArrayBuffer$.MODULE$.apply$default$1();
    }

    public DeferredArrayBuffer(int initialLength) {
        this.initialLength = initialLength;
        Buffer.$init$(this);
        this.pristine = true;
        this.initialSize = initialLength;
        this.set(initialLength - 1);
    }

    @Override
    public int com$github$arturopala$bufferandslice$Buffer$$topIndex() {
        return this.com$github$arturopala$bufferandslice$Buffer$$topIndex;
    }

    @Override
    public void com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(int x$1) {
        this.com$github$arturopala$bufferandslice$Buffer$$topIndex = x$1;
    }

    private void initializeWith(T value) {
        if (this.pristine) {
            this._array = ArrayOps$.MODULE$.newArray(value, this.initialSize);
            this.pristine = false;
        }
    }

    @Override
    public T read(int index) {
        if (this.pristine) {
            throw new RuntimeException("Deferred buffer not yet initialized.");
        }
        return (T)ScalaRunTime$.MODULE$.array_apply(this._array, index);
    }

    @Override
    public void write(int index, T value) {
        this.initializeWith(value);
        ScalaRunTime$.MODULE$.array_update(this._array, index, value);
    }

    @Override
    public void copyFrom(Object sourceArray, int sourceIndex, int targetIndex, int copyLength) {
        if (this.pristine && sourceArray != null) {
            this.initializeWith(ScalaRunTime$.MODULE$.array_apply(sourceArray, sourceIndex));
        }
        if (sourceArray != null) {
            System.arraycopy(sourceArray, sourceIndex, this._array, targetIndex, copyLength);
        }
    }

    @Override
    public void copyFrom(Slice<T> slice, int targetIndex) {
        if (slice.nonEmpty()) {
            this.initializeWith(slice.head());
            slice.copyToArray(targetIndex, this._array);
        }
    }

    @Override
    public void copyFromSelf(int sourceIndex, int targetIndex, int copyLength) {
        if (!this.pristine) {
            System.arraycopy(this._array, sourceIndex, this._array, targetIndex, copyLength);
        }
    }

    @Override
    public Object emptyArray(int length) {
        return this.pristine ? null : ArrayOps$.MODULE$.copyOf(ArrayOps$.MODULE$.copyOf(this._array, 0), length);
    }

    @Override
    public T apply(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pristine) {
            throw new RuntimeException("Deferred buffer not yet initialized.");
        }
        return (T)ScalaRunTime$.MODULE$.array_apply(this._array, index);
    }

    @Override
    public void ensureIndex(int index) {
        if (this.pristine) {
            this.initialSize = Math.max(index + 1, this.initialSize);
        } else if (index >= ScalaRunTime$.MODULE$.array_length(this._array)) {
            int upswing = Math.max(1, Math.min(ScalaRunTime$.MODULE$.array_length(this._array), 0x100000));
            this._array = ArrayOps$.MODULE$.copyOf(this._array, Math.max(ScalaRunTime$.MODULE$.array_length(this._array) + upswing, index + 1));
        }
    }

    @Override
    public DeferredArrayBuffer copy() {
        return this.pristine ? new DeferredArrayBuffer(this.initialLength) : (DeferredArrayBuffer)new DeferredArrayBuffer<T>(0).appendArray(this._array);
    }

    @Override
    public DeferredArrayBuffer emptyCopy() {
        return new DeferredArrayBuffer<T>(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T1> Object toArray(ClassTag<T1> evidence$1) {
        void var2_2;
        Object newArray = Arrays$.MODULE$.newGenericArray(this.length(), evidence$1);
        if (!this.pristine) {
            System.arraycopy(this._array, 0, newArray, 0, this.length());
        }
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object asArray() {
        Object object;
        if (this.pristine) {
            if (this.initialSize != 0) throw new RuntimeException("Deferred buffer not yet initialized. Maybe try using .toArray instead.");
            object = Array$.MODULE$.empty(ClassTag$.MODULE$.Any());
            return object;
        } else {
            object = ArrayOps$.MODULE$.copyOf(this._array, this.length());
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Slice<T> asSlice() {
        Slice slice;
        if (this.pristine) {
            if (this.initialSize != 0) throw new RuntimeException("Deferred buffer not yet initialized. Maybe try using ArrayBuffer instead.");
            slice = Slice$.MODULE$.empty();
            return slice;
        } else {
            slice = new ArraySlice(0, this.length(), this._array, false);
        }
        return slice;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Slice<T> slice(int from, int to) {
        ArraySlice arraySlice;
        if (this.pristine) {
            if (this.initialSize != 0) throw new RuntimeException("Deferred buffer not yet initialized. Maybe try ArrayBuffer instead.");
            arraySlice = Slice$.MODULE$.empty();
            return arraySlice;
        } else {
            int t = Math.min(this.length(), to);
            int f = Math.min(from, t);
            arraySlice = new ArraySlice(f, t, this._array, false);
        }
        return arraySlice;
    }
}

