/*
 * Decompiled with CFR 0.152.
 */
package com.github.arturopala.bufferandslice;

import com.github.arturopala.bufferandslice.Buffer;
import com.github.arturopala.bufferandslice.Slice;
import scala.runtime.ScalaRunTime$;

public interface ArrayBufferLike<T>
extends Buffer<T> {
    public void copyFrom(Object var1, int var2, int var3, int var4);

    public void copyFrom(Slice<T> var1, int var2);

    public void copyFromSelf(int var1, int var2, int var3);

    public Object emptyArray(int var1);

    public static ArrayBufferLike update$(ArrayBufferLike $this, int index, Object value) {
        return $this.update(index, value);
    }

    @Override
    default public ArrayBufferLike update(int index, T value) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureIndex(index);
        this.write(index, value);
        this.set(Math.max(index, this.top()));
        return this;
    }

    public static String toString$(ArrayBufferLike $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.iterator().take(Math.min(20, this.length())).mkString("[", ",", this.length() > 20 ? ", ... ]" : "]");
    }

    public static ArrayBufferLike insertArray$(ArrayBufferLike $this, int index, int sourceIndex, int insertLength, Object sourceArray) {
        return $this.insertArray(index, sourceIndex, insertLength, sourceArray);
    }

    @Override
    default public ArrayBufferLike insertArray(int index, int sourceIndex, int insertLength, Object sourceArray) {
        if (index < 0 || sourceIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int copyLength = Math.min(insertLength, ScalaRunTime$.MODULE$.array_length(sourceArray));
        if (copyLength > 0) {
            this.shiftRight(index, copyLength);
            this.copyFrom(sourceArray, sourceIndex, index, copyLength);
        }
        this.set(Math.max(this.top(), index + copyLength - 1));
        return this;
    }

    public static ArrayBufferLike insertSlice$(ArrayBufferLike $this, int index, Slice slice) {
        return $this.insertSlice(index, slice);
    }

    @Override
    default public ArrayBufferLike insertSlice(int index, Slice<T> slice) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.shiftRight(index, slice.length());
        this.copyFrom(slice, index);
        this.set(Math.max(this.top(), index + slice.length() - 1));
        return this;
    }

    public static ArrayBufferLike replaceFromArray$(ArrayBufferLike $this, int index, int sourceIndex, int replaceLength, Object sourceArray) {
        return $this.replaceFromArray(index, sourceIndex, replaceLength, sourceArray);
    }

    @Override
    default public ArrayBufferLike replaceFromArray(int index, int sourceIndex, int replaceLength, Object sourceArray) {
        if (index < 0 || sourceIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int copyLength = Math.min(replaceLength, ScalaRunTime$.MODULE$.array_length(sourceArray));
        if (copyLength > 0) {
            this.ensureIndex(index + replaceLength);
            this.copyFrom(sourceArray, sourceIndex, index, copyLength);
        }
        this.set(Math.max(this.top(), index + copyLength - 1));
        return this;
    }

    public static ArrayBufferLike replaceFromSlice$(ArrayBufferLike $this, int index, Slice slice) {
        return $this.replaceFromSlice(index, slice);
    }

    @Override
    default public ArrayBufferLike replaceFromSlice(int index, Slice<T> slice) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureIndex(index + slice.length());
        this.copyFrom(slice, index);
        this.set(Math.max(this.top(), index + slice.length() - 1));
        return this;
    }

    public static ArrayBufferLike shiftRight$(ArrayBufferLike $this, int index, int distance) {
        return $this.shiftRight(index, distance);
    }

    @Override
    default public ArrayBufferLike shiftRight(int index, int distance) {
        if (distance > 0 && index >= 0) {
            this.ensureIndex(Math.max(this.length(), index) + distance);
            if (this.length() - index > 0) {
                this.copyFromSelf(index, index + distance, this.length() - index);
            }
            if (this.top() == -1) {
                this.set(distance - 1);
            } else if (this.top() >= index) {
                this.set(this.top() + distance);
            }
        }
        return this;
    }

    public static ArrayBufferLike shiftLeft$(ArrayBufferLike $this, int index, int distance) {
        return $this.shiftLeft(index, distance);
    }

    @Override
    default public ArrayBufferLike shiftLeft(int index, int distance) {
        if (distance > 0 && index >= 0) {
            int distance2 = Math.min(index, distance);
            int offset = distance - distance2;
            if (this.length() - index - offset > 0) {
                this.copyFromSelf(index + offset, index - distance2, this.length() - index - offset);
            }
            if (this.top() >= index - distance2) {
                this.set(Math.max(-1, this.top() - distance));
            }
        }
        return this;
    }

    public static ArrayBufferLike moveRangeRight$(ArrayBufferLike $this, int fromIndex, int toIndex, int distance) {
        return $this.moveRangeRight(fromIndex, toIndex, distance);
    }

    @Override
    default public ArrayBufferLike moveRangeRight(int fromIndex, int toIndex, int distance) {
        if (distance > 0 && fromIndex >= 0 && toIndex > fromIndex && fromIndex < this.length()) {
            int to = Math.min(toIndex, this.length());
            this.ensureIndex(to + distance - 1);
            Object backup = this.emptyArray(distance);
            this.slice(to, Math.min(to + distance, this.length())).copyToArray(0, backup);
            this.copyFromSelf(fromIndex, fromIndex + distance, to - fromIndex);
            this.copyFrom(backup, 0, fromIndex, ScalaRunTime$.MODULE$.array_length(backup));
            this.set(Math.max(this.top(), to + distance - 1));
        }
        return this;
    }

    public static ArrayBufferLike moveRangeLeft$(ArrayBufferLike $this, int fromIndex, int toIndex, int distance) {
        return $this.moveRangeLeft(fromIndex, toIndex, distance);
    }

    @Override
    default public ArrayBufferLike moveRangeLeft(int fromIndex, int toIndex, int distance) {
        if (distance > 0 && fromIndex >= 0 && toIndex > fromIndex && fromIndex < this.length()) {
            int from = Math.max(fromIndex, distance);
            int to = Math.min(toIndex, this.length());
            Object backup = this.emptyArray(distance);
            Slice relocating = this.slice(from - distance, fromIndex);
            relocating.copyToArray(ScalaRunTime$.MODULE$.array_length(backup) - relocating.length(), backup);
            int gap = Math.max(0, distance - fromIndex);
            this.shiftRight(0, gap);
            this.copyFromSelf(fromIndex + gap, fromIndex - distance + gap, to - fromIndex);
            this.copyFrom(backup, 0, to - distance + gap, ScalaRunTime$.MODULE$.array_length(backup));
        }
        return this;
    }

    public static ArrayBufferLike swapRange$(ArrayBufferLike $this, int first, int second, int swapLength) {
        return $this.swapRange(first, second, swapLength);
    }

    @Override
    default public ArrayBufferLike swapRange(int first, int second, int swapLength) {
        if (swapLength > 0 && first >= 0 && second >= 0 && first != second && first < this.length() && second < this.length() && first + swapLength >= 0 && second + swapLength >= 0) {
            int backupLength = Math.min(swapLength, this.length() - Math.max(first, second));
            Object backup = this.emptyArray(backupLength);
            this.slice(second, second + backupLength).copyToArray(0, backup);
            this.copyFromSelf(first, second, backupLength);
            this.copyFrom(backup, 0, first, backupLength);
        }
        return this;
    }

    public static ArrayBufferLike optimize$(ArrayBufferLike $this) {
        return $this.optimize();
    }

    @Override
    default public ArrayBufferLike optimize() {
        return (ArrayBufferLike)this.copy();
    }
}

