/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.widget.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.location.Address;
import android.location.Geocoder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatAutoCompleteTextView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Filter;
import android.widget.TextView;
import com.artemkopan.widget.R;
import com.artemkopan.widget.vector.VectorCompatViewHelper;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PlacesAutoCompleteView
extends AppCompatAutoCompleteTextView {
    private static final String TAG = "PlacesAutoCompleteView";
    private static final int DEBOUNCE = 800;
    private static final int MIN_START_SEARCH = 2;
    private static final int MAX_RESULT = 10;
    private Geocoder geocoder;
    private Predicate<String> filter;
    private Consumer<List<Address>> consumer;
    private Function<CharSequence, String> convert;
    private PublishSubject<CharSequence> textChangeSubject;
    private Function<String, ObservableSource<List<Address>>> findItem;
    @Nullable
    private ArrayAdapter<Address> addressAdapter;
    private OnLocationListener loadingListener;
    private String oldValue;
    private int debounce = 800;
    private int minStartSearch = 2;
    private int maxResult = 10;
    private boolean initAdapter = true;
    private boolean blocked;

    public PlacesAutoCompleteView(Context context) {
        super(context);
        this.init(null);
    }

    public PlacesAutoCompleteView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public PlacesAutoCompleteView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.geocoder = new Geocoder(this.getContext());
        this.textChangeSubject = PublishSubject.create();
        if (attrs != null) {
            TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.PlacesAutoCompleteView);
            try {
                this.debounce = ta.getInteger(R.styleable.PlacesAutoCompleteView_gac_debounce, 800);
                this.minStartSearch = ta.getInteger(R.styleable.PlacesAutoCompleteView_gac_min_start_search, 2);
                this.maxResult = ta.getInteger(R.styleable.PlacesAutoCompleteView_gac_max_result, 10);
                this.initAdapter = ta.getBoolean(R.styleable.PlacesAutoCompleteView_gac_init_adapter, true);
            }
            finally {
                ta.recycle();
            }
        }
        VectorCompatViewHelper.loadFromAttributes((TextView)this, attrs);
        if (this.initAdapter) {
            this.addressAdapter = new AddressAdapter(this.getContext(), 0, new ArrayList<Address>());
            super.setAdapter(this.addressAdapter);
        }
    }

    public void setText(CharSequence text, boolean blocked) {
        if (blocked) {
            this.replaceText(text);
        } else {
            this.setText(text);
        }
    }

    protected void replaceText(CharSequence text) {
        this.blocked = true;
        super.replaceText(text);
        this.oldValue = text.toString();
        this.blocked = false;
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        if (text.length() >= this.minStartSearch && this.textChangeSubject != null && !this.blocked) {
            Log.i((String)TAG, (String)("onNext " + text + " " + this.oldValue));
            this.textChangeSubject.onNext((Object)PlacesAutoCompleteView.trim(text));
        } else if (!this.blocked && this.addressAdapter != null) {
            Log.i((String)TAG, (String)"clear");
            this.addressAdapter.clear();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.textChangeSubject.subscribeOn(Schedulers.io()).map(this.getRxConvert()).filter(this.getRxFilter()).debounce((long)this.debounce, TimeUnit.MILLISECONDS, Schedulers.io()).switchMap(this.getRxFinder()).observeOn(AndroidSchedulers.mainThread()).subscribe(this.getRxConsumer());
    }

    protected void onDetachedFromWindow() {
        this.textChangeSubject.onComplete();
        super.onDetachedFromWindow();
    }

    public void setAdapter(ArrayAdapter<Address> adapter) {
        super.setAdapter(adapter);
        this.addressAdapter = adapter;
    }

    public void setLoadingListener(OnLocationListener loadingListener) {
        this.loadingListener = loadingListener;
    }

    private Function<CharSequence, String> getRxConvert() {
        if (this.convert == null) {
            this.convert = new Function<CharSequence, String>(){

                public String apply(CharSequence charSequence) throws Exception {
                    return charSequence.toString();
                }
            };
        }
        return this.convert;
    }

    private Function<String, ObservableSource<List<Address>>> getRxFinder() {
        if (this.findItem == null) {
            this.findItem = new Function<String, ObservableSource<List<Address>>>(){

                public ObservableSource<List<Address>> apply(final String s) throws Exception {
                    return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<List<Address>>(){

                        public void subscribe(ObservableEmitter<List<Address>> e) throws Exception {
                            block2: {
                                AndroidSchedulers.mainThread().scheduleDirect(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (PlacesAutoCompleteView.this.loadingListener != null) {
                                            PlacesAutoCompleteView.this.loadingListener.startLoad();
                                        }
                                    }
                                });
                                try {
                                    e.onNext((Object)PlacesAutoCompleteView.this.geocoder.getFromLocationName(s, PlacesAutoCompleteView.this.maxResult));
                                }
                                catch (Exception ex) {
                                    if (PlacesAutoCompleteView.this.loadingListener == null) break block2;
                                    PlacesAutoCompleteView.this.loadingListener.error(ex);
                                }
                            }
                            AndroidSchedulers.mainThread().scheduleDirect(new Runnable(){

                                @Override
                                public void run() {
                                    if (PlacesAutoCompleteView.this.loadingListener != null) {
                                        PlacesAutoCompleteView.this.loadingListener.stopLoad();
                                    }
                                }
                            });
                            e.onComplete();
                        }
                    });
                }
            };
        }
        return this.findItem;
    }

    private Predicate<String> getRxFilter() {
        if (this.filter == null) {
            this.filter = new Predicate<String>(){

                public boolean test(String string) throws Exception {
                    if (string.equals(PlacesAutoCompleteView.this.oldValue)) {
                        return false;
                    }
                    PlacesAutoCompleteView.this.oldValue = string;
                    return !TextUtils.isEmpty((CharSequence)string) && TextUtils.getTrimmedLength((CharSequence)string) != 0;
                }
            };
        }
        return this.filter;
    }

    private Consumer<List<Address>> getRxConsumer() {
        if (this.consumer == null) {
            this.consumer = new Consumer<List<Address>>(){

                public void accept(List<Address> addresses) throws Exception {
                    if (PlacesAutoCompleteView.this.addressAdapter == null) {
                        return;
                    }
                    PlacesAutoCompleteView.this.addressAdapter.clear();
                    PlacesAutoCompleteView.this.addressAdapter.addAll(addresses);
                }
            };
        }
        return this.consumer;
    }

    public static String getCompleteAddressLine(@Nullable Address address) {
        StringBuilder strReturnedAddress = new StringBuilder("");
        if (address != null) {
            int count = address.getMaxAddressLineIndex();
            if (count == 0) {
                strReturnedAddress.append(address.getAddressLine(0));
                return strReturnedAddress.toString();
            }
            for (int i = 0; i < count; ++i) {
                strReturnedAddress.append(address.getAddressLine(i));
                if (i >= count - 1) continue;
                strReturnedAddress.append(", ");
            }
        }
        return strReturnedAddress.toString();
    }

    private static CharSequence trim(CharSequence s) {
        int end;
        int start;
        if (s == null) {
            return null;
        }
        int len = s.length();
        for (start = 0; start < len && s.charAt(start) <= ' '; ++start) {
        }
        for (end = len; end > start && s.charAt(end - 1) <= ' '; --end) {
        }
        return s.subSequence(start, end);
    }

    private static class AddressAdapter
    extends ArrayAdapter<Address> {
        private static final Filter NO_FILTER = new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                return null;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            }

            public CharSequence convertResultToString(Object resultValue) {
                return super.convertResultToString((Object)PlacesAutoCompleteView.getCompleteAddressLine((Address)resultValue));
            }
        };

        AddressAdapter(Context context, int resource, List<Address> objects) {
            super(context, resource, objects);
        }

        @NonNull
        public View getView(int position, View convertView, @NonNull ViewGroup parent) {
            return this.createView(position, convertView, parent);
        }

        public View getDropDownView(int position, View convertView, @NonNull ViewGroup parent) {
            return this.createView(position, convertView, parent);
        }

        private View createView(int position, View convertView, ViewGroup parent) {
            TextView view = convertView == null ? (TextView)LayoutInflater.from((Context)parent.getContext()).inflate(17367050, parent, false) : (TextView)convertView;
            view.setText((CharSequence)PlacesAutoCompleteView.getCompleteAddressLine((Address)this.getItem(position)));
            return view;
        }

        @NonNull
        public Filter getFilter() {
            return NO_FILTER;
        }
    }

    public static interface OnLocationListener {
        public void startLoad();

        public void stopLoad();

        public void error(Throwable var1);
    }
}

