/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.widget.common;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import com.artemkopan.widget.R;
import com.artemkopan.widget.drawable.CircularProgressDrawable;

public class CircularProgressView
extends View {
    private CircularProgressDrawable drawable;
    private boolean heightAccent = false;

    public CircularProgressView(Context context) {
        this(context, null, 0);
    }

    public CircularProgressView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircularProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public CircularProgressView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs) {
        int color = -16777216;
        int borderWidth = -1;
        if (attrs != null) {
            TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.CircularProgressView);
            try {
                color = array.getColor(R.styleable.CircularProgressView_cpv_progressColor, color);
                borderWidth = array.getDimensionPixelSize(R.styleable.CircularProgressView_cpv_border_width, this.getContext().getResources().getDimensionPixelSize(R.dimen.base_progress_border_width));
                this.heightAccent = array.getBoolean(R.styleable.CircularProgressView_cpv_height_accent, this.heightAccent);
            }
            finally {
                array.recycle();
            }
        }
        this.drawable = new CircularProgressDrawable(color, borderWidth);
        this.drawable.setCallback((Drawable.Callback)this);
        if (this.getVisibility() == 0) {
            this.drawable.start();
        }
    }

    public void setProgressColor(@ColorInt int color) {
        if (this.drawable != null) {
            this.drawable.setColor(color);
        }
    }

    public void setBorderWidth(int borderWidth) {
        if (this.drawable != null) {
            this.drawable.setStrokeWidth(borderWidth);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.drawable == null) {
            return;
        }
        if (visibility == 0) {
            this.drawable.start();
        } else {
            this.drawable.stop();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.heightAccent) {
            this.drawable.setBounds(this.getPaddingLeft(), this.getPaddingTop(), h - this.getPaddingRight(), h - this.getPaddingBottom());
        } else {
            this.drawable.setBounds(this.getPaddingLeft(), this.getPaddingTop(), w - this.getPaddingRight(), w - this.getPaddingBottom());
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.drawable.draw(canvas);
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return who == this.drawable || super.verifyDrawable(who);
    }
}

