/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.widget.drawable;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.util.Property;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;

public class CircularProgressDrawable
extends Drawable
implements Animatable {
    private static final Interpolator ANGLE_INTERPOLATOR = new LinearInterpolator();
    private static final Interpolator SWEEP_INTERPOLATOR = new DecelerateInterpolator();
    private static final int ANGLE_ANIMATOR_DURATION = 2000;
    private static final int SWEEP_ANIMATOR_DURATION = 600;
    private static final int MIN_SWEEP_ANGLE = 30;
    private final RectF fBounds = new RectF();
    private ObjectAnimator objectAnimatorSweep;
    private ObjectAnimator objectAnimatorAngle;
    private boolean modeAppearing;
    private Paint paint;
    private float currentGlobalAngleOffset;
    private float currentGlobalAngle;
    private float currentSweepAngle;
    private float borderWidth;
    private boolean running;
    private Property<CircularProgressDrawable, Float> mAngleProperty = new Property<CircularProgressDrawable, Float>(Float.class, "angle"){

        public Float get(CircularProgressDrawable object) {
            return Float.valueOf(object.getCurrentGlobalAngle());
        }

        public void set(CircularProgressDrawable object, Float value) {
            object.setCurrentGlobalAngle(value.floatValue());
        }
    };
    private Property<CircularProgressDrawable, Float> mSweepProperty = new Property<CircularProgressDrawable, Float>(Float.class, "arc"){

        public Float get(CircularProgressDrawable object) {
            return Float.valueOf(object.getCurrentSweepAngle());
        }

        public void set(CircularProgressDrawable object, Float value) {
            object.setCurrentSweepAngle(value.floatValue());
        }
    };

    public CircularProgressDrawable(int color, float borderWidth) {
        this.borderWidth = borderWidth;
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(borderWidth);
        this.paint.setColor(color);
        this.setupAnimations();
    }

    public void draw(@NonNull Canvas canvas) {
        int count = canvas.save();
        float startAngle = this.currentGlobalAngle - this.currentGlobalAngleOffset;
        float sweepAngle = this.currentSweepAngle;
        if (!this.modeAppearing) {
            startAngle += sweepAngle;
            sweepAngle = 360.0f - sweepAngle - 30.0f;
        } else {
            sweepAngle += 30.0f;
        }
        canvas.drawArc(this.fBounds, startAngle, sweepAngle, false, this.paint);
        canvas.restoreToCount(count);
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.paint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -2;
    }

    private void toggleAppearingMode() {
        boolean bl = this.modeAppearing = !this.modeAppearing;
        if (this.modeAppearing) {
            this.currentGlobalAngleOffset = (this.currentGlobalAngleOffset + 60.0f) % 360.0f;
        }
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.fBounds.left = (float)bounds.left + this.borderWidth / 2.0f + 0.5f;
        this.fBounds.right = (float)bounds.right - this.borderWidth / 2.0f - 0.5f;
        this.fBounds.top = (float)bounds.top + this.borderWidth / 2.0f + 0.5f;
        this.fBounds.bottom = (float)bounds.bottom - this.borderWidth / 2.0f - 0.5f;
    }

    private void setupAnimations() {
        this.objectAnimatorAngle = ObjectAnimator.ofFloat((Object)((Object)this), this.mAngleProperty, (float[])new float[]{360.0f});
        this.objectAnimatorAngle.setInterpolator((TimeInterpolator)ANGLE_INTERPOLATOR);
        this.objectAnimatorAngle.setDuration(2000L);
        this.objectAnimatorAngle.setRepeatMode(1);
        this.objectAnimatorAngle.setRepeatCount(-1);
        this.objectAnimatorSweep = ObjectAnimator.ofFloat((Object)((Object)this), this.mSweepProperty, (float[])new float[]{300.0f});
        this.objectAnimatorSweep.setInterpolator((TimeInterpolator)SWEEP_INTERPOLATOR);
        this.objectAnimatorSweep.setDuration(600L);
        this.objectAnimatorSweep.setRepeatMode(1);
        this.objectAnimatorSweep.setRepeatCount(-1);
        this.objectAnimatorSweep.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
                CircularProgressDrawable.this.toggleAppearingMode();
            }
        });
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.running = true;
        this.objectAnimatorAngle.start();
        this.objectAnimatorSweep.start();
        this.invalidateSelf();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.running = false;
        this.objectAnimatorAngle.cancel();
        this.objectAnimatorSweep.cancel();
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setCurrentGlobalAngle(float currentGlobalAngle) {
        this.currentGlobalAngle = currentGlobalAngle;
        this.invalidateSelf();
    }

    public float getCurrentGlobalAngle() {
        return this.currentGlobalAngle;
    }

    public void setCurrentSweepAngle(float currentSweepAngle) {
        this.currentSweepAngle = currentSweepAngle;
        this.invalidateSelf();
    }

    public float getCurrentSweepAngle() {
        return this.currentSweepAngle;
    }

    public void setColor(@ColorInt int color) {
        this.paint.setColor(color);
        this.invalidateSelf();
    }

    public void setStrokeWidth(float borderWidth) {
        this.paint.setStrokeWidth(borderWidth);
        this.invalidateSelf();
    }
}

