/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.widget.places;

import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ArrayAdapter;
import com.artemkopan.widget.places.PlacesAdapter;
import com.artemkopan.widget.places.PlacesAutoCompleteUtils;
import com.artemkopan.widget.places.PlacesAutoCompleteView;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

class PlacesAutoCompleteDelegate {
    private static final String TAG = "PlacesAutoComplete";
    static final int DEBOUNCE = 800;
    static final int MIN_START_SEARCH = 2;
    static final int MAX_RESULT = 10;
    @Nullable
    private ArrayAdapter<Address> addressAdapter;
    private Geocoder geocoder;
    private Predicate<String> filter;
    private Consumer<List<Address>> consumer;
    private Function<CharSequence, String> convert;
    private PublishSubject<CharSequence> textChangeSubject;
    private Function<String, ObservableSource<List<Address>>> findItem;
    private PlacesAutoCompleteView.OnLocationListener loadingListener;
    @LayoutRes
    private int layoutRes = 17367050;
    private int debounce = 800;
    private int minStartSearch = 2;
    private int maxResult = 10;
    private boolean blocked;
    private String oldText;
    private Disposable subscribe;

    PlacesAutoCompleteDelegate(Context context) {
        this.geocoder = new Geocoder(context);
        this.textChangeSubject = PublishSubject.create();
    }

    void setLayoutRes(int layoutRes) {
        this.layoutRes = layoutRes;
    }

    void setDebounce(int debounce) {
        this.debounce = debounce;
    }

    void setMinStartSearch(int minStartSearch) {
        this.minStartSearch = minStartSearch;
    }

    void setMaxResult(int maxResult) {
        this.maxResult = maxResult;
    }

    void setOldText(String oldText) {
        this.oldText = oldText;
    }

    void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    ArrayAdapter<Address> initAdapter(Context context) {
        this.addressAdapter = new PlacesAdapter(context, this.layoutRes, new ArrayList<Address>(10));
        return this.addressAdapter;
    }

    void setAdapter(ArrayAdapter<Address> adapter) {
        this.addressAdapter = adapter;
    }

    void setLoadingListener(PlacesAutoCompleteView.OnLocationListener loadingListener) {
        this.loadingListener = loadingListener;
    }

    void onTextChanged(CharSequence text) {
        if (text.length() >= this.minStartSearch && this.textChangeSubject != null && !this.blocked) {
            Log.i((String)TAG, (String)("onNext " + text + " " + this.oldText));
            this.textChangeSubject.onNext((Object)PlacesAutoCompleteUtils.trim(text));
        } else if (!this.blocked && this.addressAdapter != null) {
            Log.i((String)TAG, (String)"clear");
            this.addressAdapter.clear();
        }
    }

    void onAttachedToWindow() {
        this.subscribe = this.textChangeSubject.subscribeOn(Schedulers.io()).map(this.getRxConvert()).filter(this.getRxFilter()).debounce((long)this.debounce, TimeUnit.MILLISECONDS, AndroidSchedulers.mainThread()).switchMap(this.getRxFinder()).subscribe(this.getRxConsumer(), (Consumer)new Consumer<Throwable>(){

            public void accept(@NonNull Throwable throwable) throws Exception {
                if (PlacesAutoCompleteDelegate.this.loadingListener != null) {
                    PlacesAutoCompleteDelegate.this.loadingListener.error(throwable);
                }
            }
        });
    }

    void onDetachedFromWindow() {
        this.textChangeSubject.onComplete();
        if (this.subscribe != null) {
            this.subscribe.dispose();
        }
    }

    private Function<CharSequence, String> getRxConvert() {
        if (this.convert == null) {
            this.convert = new Function<CharSequence, String>(){

                public String apply(CharSequence charSequence) throws Exception {
                    return charSequence.toString();
                }
            };
        }
        return this.convert;
    }

    private Function<String, ObservableSource<List<Address>>> getRxFinder() {
        if (this.findItem == null) {
            this.findItem = new Function<String, ObservableSource<List<Address>>>(){

                public ObservableSource<List<Address>> apply(final String s) throws Exception {
                    if (PlacesAutoCompleteDelegate.this.loadingListener != null) {
                        PlacesAutoCompleteDelegate.this.loadingListener.startLoad();
                    }
                    return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<List<Address>>(){

                        public void subscribe(ObservableEmitter<List<Address>> e) throws Exception {
                            try {
                                e.onNext((Object)PlacesAutoCompleteDelegate.this.geocoder.getFromLocationName(s, PlacesAutoCompleteDelegate.this.maxResult));
                                e.onComplete();
                            }
                            catch (Exception ex) {
                                e.onError((Throwable)ex);
                            }
                        }
                    }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doFinally(new Action(){

                        public void run() throws Exception {
                            if (PlacesAutoCompleteDelegate.this.loadingListener != null) {
                                PlacesAutoCompleteDelegate.this.loadingListener.stopLoad();
                            }
                        }
                    });
                }
            };
        }
        return this.findItem;
    }

    private Predicate<String> getRxFilter() {
        if (this.filter == null) {
            this.filter = new Predicate<String>(){

                public boolean test(String string) throws Exception {
                    if (string.equals(PlacesAutoCompleteDelegate.this.oldText)) {
                        return false;
                    }
                    PlacesAutoCompleteDelegate.this.oldText = string;
                    return !TextUtils.isEmpty((CharSequence)string) && TextUtils.getTrimmedLength((CharSequence)string) != 0;
                }
            };
        }
        return this.filter;
    }

    private Consumer<List<Address>> getRxConsumer() {
        if (this.consumer == null) {
            this.consumer = new Consumer<List<Address>>(){

                public void accept(List<Address> addresses) throws Exception {
                    if (PlacesAutoCompleteDelegate.this.addressAdapter == null) {
                        return;
                    }
                    PlacesAutoCompleteDelegate.this.addressAdapter.clear();
                    PlacesAutoCompleteDelegate.this.addressAdapter.addAll(addresses);
                }
            };
        }
        return this.consumer;
    }
}

