/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.adapter;

import android.support.annotation.Nullable;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.ViewGroup;
import com.artemkopan.recycler.adapter.RecyclerAdapter;
import java.util.Collection;

public abstract class RecyclerSortedAdapter<M, VH extends RecyclerView.ViewHolder>
extends RecyclerAdapter<M, VH> {
    private static final String TAG = "RecyclerSortedAdapter";
    private SortedList<M> list;

    public void initList(Class<M> clazz, SortedList.Callback<M> callback) {
        this.list = new SortedList(clazz, callback);
    }

    public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

    @Override
    public void onBindViewHolder(VH holder, int position) {
        this.onBindViewHolder(holder, this.getItemByPos(position), position);
    }

    @Override
    public abstract void onBindViewHolder(VH var1, M var2, int var3);

    public SortedList<M> getList() {
        if (this.list == null) {
            throw new NullPointerException("List is null. Please call iniList() method");
        }
        return this.list;
    }

    @Override
    @Nullable
    protected M getListItemByPos(int position) {
        if (position >= this.getList().size() || position < 0) {
            Log.w((String)TAG, (String)"Index is out of bounds");
            return null;
        }
        return (M)this.getList().get(position);
    }

    @Override
    public int getListSize() {
        return this.list == null ? 0 : this.list.size();
    }

    public int getItemIndex(M item) {
        return this.getList().indexOf(item);
    }

    public int getObjectIndex(Object item) {
        if (item == null) {
            return -1;
        }
        for (int i = 0; i < this.getList().size(); ++i) {
            Object findItem = this.getList().get(i);
            if (!findItem.equals(item)) continue;
            return i;
        }
        return -1;
    }

    public void remove(M item) {
        this.getList().remove(item);
    }

    public void clear() {
        this.getList().clear();
    }

    public void replaceItems(Collection<M> items) {
        this.getList().beginBatchedUpdates();
        this.getList().clear();
        this.getList().addAll(items);
        this.getList().endBatchedUpdates();
    }
}

