/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.artemkopan.recycler.holder.BaseHolder;
import com.artemkopan.recycler.listeners.OnItemClickListener;

public abstract class RecyclerAdapter<M, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    public static final int HEADER = 98;
    public static final int FOOTER = 99;
    private boolean isShowHeader = false;
    private boolean isShowFooter = false;
    private OnItemClickListener<M> onItemClickListener;

    public void onBindViewHolder(VH holder, int position) {
        this.onBindViewHolder(holder, this.getItemByPos(position), position);
    }

    public void onViewRecycled(VH holder) {
        super.onViewRecycled(holder);
        if (holder != null && holder instanceof BaseHolder) {
            ((BaseHolder)((Object)holder)).clear();
        }
    }

    public abstract void onBindViewHolder(VH var1, M var2, int var3);

    protected abstract M getListItemByPos(int var1);

    public abstract int getListSize();

    public boolean isEmpty() {
        return this.getListSize() == 0;
    }

    public int getItemCount() {
        return this.getListSize() + this.getPosOffset() + (this.isShowFooter ? 1 : 0);
    }

    public M getItemByPos(int position) {
        return this.getListItemByPos(position - this.getPosOffset());
    }

    public int getItemViewType(int position) {
        if (this.isShowHeader && position == 0) {
            return 98;
        }
        if (this.isShowFooter && this.getItemCount() - 1 == position) {
            return 99;
        }
        return super.getItemViewType(position);
    }

    public void setOnItemClickListener(OnItemClickListener<M> onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    protected void callOnItemClick(RecyclerView.ViewHolder holder, View view, View ... transactionViews) {
        int position = holder.getAdapterPosition();
        if (this.onItemClickListener != null && position >= 0 && position < this.getItemCount()) {
            this.onItemClickListener.onItemClickListener(view, position, this.getItemByPos(position), transactionViews);
        }
    }

    public boolean isShowHeader() {
        return this.isShowHeader;
    }

    public void showHeader(boolean show) {
        if (this.isShowHeader == show) {
            return;
        }
        this.isShowHeader = show;
        if (show) {
            this.notifyItemInserted(0);
        } else {
            this.notifyItemRemoved(0);
        }
    }

    public boolean isShowFooter() {
        return this.isShowFooter;
    }

    public void showFooter(boolean show) {
        if (this.isShowFooter == show) {
            return;
        }
        this.isShowFooter = show;
        if (show) {
            this.notifyItemInserted(this.getItemCount());
        } else {
            this.notifyItemRemoved(this.getItemCount() + 1);
        }
    }

    public int getPosOffset() {
        return this.isShowHeader ? 1 : 0;
    }
}

