/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.adapter;

import android.support.v7.widget.RecyclerView;
import com.artemkopan.recycler.adapter.RecyclerBaseAdapter;
import com.artemkopan.recycler.adapter.RecyclerList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class RecyclerListAdapter<M, VH extends RecyclerView.ViewHolder>
extends RecyclerBaseAdapter<M, VH>
implements RecyclerList<M> {
    protected List<M> list;

    public RecyclerListAdapter() {
        this(new ArrayList());
    }

    public RecyclerListAdapter(List<M> list) {
        this.list = list;
    }

    @Override
    protected M getListItemByPos(int pos) {
        return this.get(pos);
    }

    @Override
    protected int getListSize() {
        return this.listSize();
    }

    public void setList(List<M> list) {
        this.setList(list, true);
    }

    public void setList(List<M> list, boolean notify) {
        if (this.list != null && this.list.isEmpty()) {
            this.list.clear();
        }
        this.list = list;
        if (notify) {
            this.notifyDataSetChanged();
        }
    }

    public void setList(Collection<M> list, boolean notify) {
        if (this.list == null) {
            this.list = new ArrayList<M>();
            this.list.addAll(list);
        } else {
            this.list.clear();
            this.list.addAll(list);
        }
        this.notifyDataSetChanged();
    }

    public List<M> getList() {
        return this.list;
    }

    public void moveItem(int fromPosition, int toPosition) {
        M model = this.list.remove(fromPosition);
        this.list.add(toPosition, model);
        this.notifyItemMoved(fromPosition, toPosition);
    }

    @Override
    public void clear() {
        if (this.list != null) {
            this.list.clear();
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void addItem(M item) {
        if (this.list.add(item)) {
            this.notifyItemChanged(this.listSize() - 1);
        }
    }

    @Override
    public void addItem(Collection<M> items) {
        int prevSize = this.listSize();
        if (this.list.addAll(items)) {
            this.notifyItemRangeChanged(prevSize, this.listSize());
        }
    }

    @Override
    @SafeVarargs
    public final void addItem(M ... items) {
        this.addItem((Collection<M>)Arrays.asList(items));
    }

    @Override
    public boolean remove(M item) {
        int index = this.list.indexOf(item);
        if (index != -1) {
            this.list.remove(index);
            this.notifyItemRemoved(index);
            return true;
        }
        return false;
    }

    @Override
    public M removeAt(int index) {
        this.notifyItemRemoved(index);
        return this.list.remove(index);
    }

    @Override
    public void updateAt(int index, M item) {
        this.list.set(index, item);
        this.notifyItemChanged(index);
    }

    @Override
    public M get(int index) {
        if (index >= this.list.size() || index < 0) {
            return null;
        }
        return this.list.get(index);
    }

    @Override
    public int indexOf(M item) {
        return this.list.indexOf(item);
    }

    @Override
    public int listSize() {
        return this.list == null ? 0 : this.list.size();
    }
}

