/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.listeners;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;

public abstract class EndlessRecyclerViewScrollListener
extends RecyclerView.OnScrollListener {
    private int visibleThreshold = 5;
    private int previousTotalItemCount = 0;
    private boolean loading = true;
    private boolean isEnable;
    private RecyclerView.LayoutManager layoutManager;

    public <L extends RecyclerView.LayoutManager> EndlessRecyclerViewScrollListener(L layoutManager) {
        this.layoutManager = layoutManager;
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            this.visibleThreshold *= ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
        } else if (layoutManager instanceof GridLayoutManager) {
            this.visibleThreshold *= ((GridLayoutManager)layoutManager).getSpanCount();
        }
    }

    private int getLastVisibleItem(int[] lastVisibleItemPositions) {
        int maxSize = 0;
        for (int i = 0; i < lastVisibleItemPositions.length; ++i) {
            if (i == 0) {
                maxSize = lastVisibleItemPositions[i];
                continue;
            }
            if (lastVisibleItemPositions[i] <= maxSize) continue;
            maxSize = lastVisibleItemPositions[i];
        }
        return maxSize;
    }

    public void onScrolled(RecyclerView view, int dx, int dy) {
        if (!this.isEnable) {
            return;
        }
        int lastVisibleItemPosition = 0;
        int totalItemCount = this.layoutManager.getItemCount();
        if (this.layoutManager instanceof StaggeredGridLayoutManager) {
            int[] lastVisibleItemPositions = ((StaggeredGridLayoutManager)this.layoutManager).findLastVisibleItemPositions(null);
            lastVisibleItemPosition = this.getLastVisibleItem(lastVisibleItemPositions);
        } else if (this.layoutManager instanceof LinearLayoutManager) {
            lastVisibleItemPosition = ((LinearLayoutManager)this.layoutManager).findLastVisibleItemPosition();
        } else if (this.layoutManager instanceof GridLayoutManager) {
            lastVisibleItemPosition = ((GridLayoutManager)this.layoutManager).findLastVisibleItemPosition();
        }
        if (totalItemCount < this.previousTotalItemCount) {
            this.previousTotalItemCount = totalItemCount;
            if (totalItemCount == 0) {
                this.loading = true;
            }
        }
        if (this.loading && totalItemCount > this.previousTotalItemCount) {
            this.loading = false;
            this.previousTotalItemCount = totalItemCount;
        }
        if (!this.loading && lastVisibleItemPosition + this.visibleThreshold > totalItemCount) {
            this.onLoadMore(totalItemCount);
            this.loading = true;
        }
    }

    public abstract void onLoadMore(int var1);

    public void reset() {
        this.previousTotalItemCount = 0;
        this.loading = true;
    }

    public void enable(boolean isEnable) {
        this.isEnable = isEnable;
    }
}

