/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.artemkopan.recycler.adapter.FooterAdapterDelegate;
import com.artemkopan.recycler.adapter.HeaderAdapterDelegate;
import com.artemkopan.recycler.holder.BaseHolder;
import com.artemkopan.recycler.listeners.OnItemClickListener;

public abstract class RecyclerBaseAdapter<M, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    public static final int HEADER = 98;
    public static final int FOOTER = 99;
    private OnItemClickListener<M> onItemClickListener;
    private FooterAdapterDelegate footerDelegate = new FooterAdapterDelegate();
    private HeaderAdapterDelegate headerDelegate = new HeaderAdapterDelegate();

    public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

    public final void onBindViewHolder(VH holder, int position) {
        if (this.headerDelegate.isHeaderPosition(position)) {
            this.onBindHeaderHolder(holder);
        } else if (this.footerDelegate.isFooterPosition(position, this.headerDelegate.getItemCount(this.getListSize()))) {
            this.onBindFooterHolder(holder);
        } else {
            this.onBindViewHolder(holder, this.getItemByPos(position), position);
        }
    }

    public abstract void onBindViewHolder(VH var1, M var2, int var3);

    public void onBindHeaderHolder(VH holder) {
    }

    public void onBindFooterHolder(VH holder) {
    }

    protected abstract M getListItemByPos(int var1);

    protected abstract int getListSize();

    public boolean isEmpty() {
        return this.getListSize() == 0;
    }

    public void onViewRecycled(VH holder) {
        super.onViewRecycled(holder);
        if (holder != null && holder instanceof BaseHolder) {
            ((BaseHolder)((Object)holder)).clear();
        }
    }

    public int getItemCount() {
        return this.footerDelegate.getItemCount(this.headerDelegate.getItemCount(this.getListSize()));
    }

    public M getItemByPos(int position) {
        return this.getListItemByPos(this.headerDelegate.getItemPosition(position));
    }

    public int getItemViewType(int position) {
        if (this.headerDelegate.isHeaderPosition(position)) {
            return 98;
        }
        if (this.footerDelegate.isFooterPosition(position, this.headerDelegate.getItemCount(this.getListSize()))) {
            return 99;
        }
        return super.getItemViewType(position);
    }

    public void setOnItemClickListener(OnItemClickListener<M> onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    protected void callOnItemClick(RecyclerView.ViewHolder holder, View view, View ... transactionViews) {
        int position = holder.getAdapterPosition();
        this.callOnItemClick(view, position, this.getItemByPos(position), transactionViews);
    }

    protected void callOnItemClick(View view, int pos, M item, View ... transactionViews) {
        if (this.onItemClickListener != null) {
            this.onItemClickListener.onItemClickListener(view, pos, item, transactionViews);
        }
    }

    public boolean isShowHeader() {
        return this.headerDelegate.isShowHeader();
    }

    public void showHeader(boolean show) {
        this.headerDelegate.showHeader(this, show);
    }

    public int getHeaderOffset() {
        return this.headerDelegate.getItemPosition(0);
    }

    public boolean isShowFooter() {
        return this.footerDelegate.isShowFooter();
    }

    public void showFooter(boolean show) {
        this.footerDelegate.showFooter(this, show);
    }
}

