/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.adapter;

import android.support.annotation.Nullable;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import com.artemkopan.recycler.adapter.RecyclerBaseAdapter;
import com.artemkopan.recycler.adapter.RecyclerList;
import java.util.Collection;

public abstract class RecyclerSortedAdapter<M, VH extends RecyclerView.ViewHolder>
extends RecyclerBaseAdapter<M, VH>
implements RecyclerList<M> {
    private SortedList<M> list;

    public void initList(Class<M> clazz, SortedList.Callback<M> callback) {
        this.list = new SortedList(clazz, callback);
    }

    public SortedList<M> getList() {
        if (this.list == null) {
            throw new NullPointerException("List is null. Please call iniList() method");
        }
        return this.list;
    }

    @Override
    @Nullable
    protected M getListItemByPos(int position) {
        return this.get(position);
    }

    @Override
    protected int getListSize() {
        return this.listSize();
    }

    @Override
    public void addItem(M item) {
        this.list.add(item);
    }

    @Override
    public void addItem(Collection<M> items) {
        this.list.addAll(items);
    }

    @Override
    @SafeVarargs
    public final void addItem(M ... items) {
        this.list.addAll((Object[])items);
    }

    @Override
    public M removeAt(int index) {
        return (M)this.list.removeItemAt(index);
    }

    @Override
    public boolean remove(M item) {
        return this.list.remove(item);
    }

    @Override
    public void updateAt(int index, M item) {
        this.list.updateItemAt(index, item);
    }

    @Override
    public M get(int index) {
        if (index >= this.list.size() || index < 0) {
            return null;
        }
        return (M)this.list.get(index);
    }

    @Override
    public int indexOf(M item) {
        return this.list.indexOf(item);
    }

    @Override
    public int listSize() {
        return this.list == null ? 0 : this.list.size();
    }

    @Override
    public void clear() {
        this.list.clear();
    }
}

