/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.listeners;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;

public abstract class EndlessRecyclerViewScrollListener
extends RecyclerView.OnScrollListener {
    private static final int STARTING_PAGE_INDEX = 1;
    private int visibleThreshold = 5;
    private int currentPage = 1;
    private int previousTotalItemCount = 0;
    private boolean loading = true;
    private RecyclerView.LayoutManager mLayoutManager;

    public <L extends RecyclerView.LayoutManager> EndlessRecyclerViewScrollListener(L layoutManager) {
        this.mLayoutManager = layoutManager;
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            this.visibleThreshold *= ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
        } else if (layoutManager instanceof GridLayoutManager) {
            this.visibleThreshold *= ((GridLayoutManager)layoutManager).getSpanCount();
        }
    }

    private int getLastVisibleItem(int[] lastVisibleItemPositions) {
        int maxSize = 0;
        for (int i = 0; i < lastVisibleItemPositions.length; ++i) {
            if (i == 0) {
                maxSize = lastVisibleItemPositions[i];
                continue;
            }
            if (lastVisibleItemPositions[i] <= maxSize) continue;
            maxSize = lastVisibleItemPositions[i];
        }
        return maxSize;
    }

    public void onScrolled(RecyclerView view, int dx, int dy) {
        int lastVisibleItemPosition = 0;
        int totalItemCount = this.mLayoutManager.getItemCount();
        if (this.mLayoutManager instanceof StaggeredGridLayoutManager) {
            int[] lastVisibleItemPositions = ((StaggeredGridLayoutManager)this.mLayoutManager).findLastVisibleItemPositions(null);
            lastVisibleItemPosition = this.getLastVisibleItem(lastVisibleItemPositions);
        } else if (this.mLayoutManager instanceof LinearLayoutManager) {
            lastVisibleItemPosition = ((LinearLayoutManager)this.mLayoutManager).findLastVisibleItemPosition();
        } else if (this.mLayoutManager instanceof GridLayoutManager) {
            lastVisibleItemPosition = ((GridLayoutManager)this.mLayoutManager).findLastVisibleItemPosition();
        }
        if (totalItemCount < this.previousTotalItemCount) {
            this.currentPage = 1;
            this.previousTotalItemCount = totalItemCount;
            if (totalItemCount == 0) {
                this.loading = true;
            }
        }
        if (this.loading && totalItemCount > this.previousTotalItemCount) {
            this.loading = false;
            this.previousTotalItemCount = totalItemCount;
        }
        if (!this.loading && lastVisibleItemPosition + this.visibleThreshold > totalItemCount) {
            ++this.currentPage;
            this.onLoadMore(this.currentPage, totalItemCount);
            this.loading = true;
        }
    }

    public abstract void onLoadMore(int var1, int var2);

    public void reset() {
        this.currentPage = 1;
        this.previousTotalItemCount = 0;
        this.loading = true;
    }
}

