/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.decoration;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class SpaceItemDecoration
extends RecyclerView.ItemDecoration {
    private int spacing;
    private boolean isHorizontal = false;
    private boolean addFirst = true;
    private boolean addLast = true;

    public SpaceItemDecoration(int spacing) {
        this.spacing = spacing;
    }

    public SpaceItemDecoration(int spacing, boolean isHorizontal) {
        this.spacing = spacing;
        this.isHorizontal = isHorizontal;
    }

    public SpaceItemDecoration(int spacing, boolean isHorizontal, boolean addFirst) {
        this.spacing = spacing;
        this.isHorizontal = isHorizontal;
        this.addFirst = addFirst;
    }

    public SpaceItemDecoration(int spacing, boolean isHorizontal, boolean addFirst, boolean addLast) {
        this.spacing = spacing;
        this.isHorizontal = isHorizontal;
        this.addFirst = addFirst;
        this.addLast = addLast;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        if (position == 0 && this.addFirst) {
            if (this.isHorizontal) {
                outRect.left = this.spacing;
            } else {
                outRect.top = this.spacing;
            }
        }
        if (!this.addLast) {
            if (position != parent.getAdapter().getItemCount() - 1) {
                if (this.isHorizontal) {
                    outRect.right = this.spacing;
                } else {
                    outRect.bottom = this.spacing;
                }
            }
        } else if (this.isHorizontal) {
            outRect.right = this.spacing;
        } else {
            outRect.bottom = this.spacing;
        }
    }
}

