/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.adapter;

import android.support.v7.util.SortedList;
import com.artemkopan.recycler.adapter.RecyclerBaseAdapter;

public abstract class RecyclerSortedCallback<T2>
extends SortedList.Callback<T2> {
    private final RecyclerBaseAdapter adapter;

    public RecyclerSortedCallback(RecyclerBaseAdapter adapter) {
        this.adapter = adapter;
    }

    public void onInserted(int position, int count) {
        this.adapter.notifyItemRangeInserted(position + this.adapter.getPosOffset(), count);
    }

    public void onRemoved(int position, int count) {
        this.adapter.notifyItemRangeRemoved(position + this.adapter.getPosOffset(), count);
    }

    public void onMoved(int fromPosition, int toPosition) {
        int offset = this.adapter.getPosOffset();
        this.adapter.notifyItemMoved(fromPosition + offset, toPosition + offset);
    }

    public void onChanged(int position, int count) {
        this.adapter.notifyItemRangeChanged(position + this.adapter.getPosOffset(), count);
    }
}

