/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.diff;

import android.support.v7.util.DiffUtil;
import java.util.List;

public abstract class BaseDiffCallback<T>
extends DiffUtil.Callback {
    private List<T> oldList;
    private List<T> newList;

    public BaseDiffCallback(List<T> oldList, List<T> newList) {
        this.oldList = oldList;
        this.newList = newList;
    }

    protected T getOldItem(int pos) {
        return this.oldList.get(pos);
    }

    protected T getNewItem(int pos) {
        return this.newList.get(pos);
    }

    public int getOldListSize() {
        return this.oldList != null ? this.oldList.size() : 0;
    }

    public int getNewListSize() {
        return this.newList != null ? this.newList.size() : 0;
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        return this.areItemsTheSame(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
    }

    public boolean areItemsTheSame(T oldItem, T newItem) {
        return oldItem == null && newItem == null || oldItem != null && oldItem.equals(newItem);
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        return this.areContentsTheSame(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
    }

    public boolean areContentsTheSame(T oldItem, T newItem) {
        return false;
    }

    public static class SimpleDiffCallback<T>
    extends BaseDiffCallback<T> {
        private SimpleDiffCallback(List<T> oldList, List<T> newList) {
            super(oldList, newList);
        }

        public static <T> SimpleDiffCallback<T> init(List<T> oldList, List<T> newList) {
            return new SimpleDiffCallback<T>(oldList, newList);
        }
    }
}

