/*
 * Decompiled with CFR 0.152.
 */
package com.luseen.screenshotobserver;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import java.io.File;

abstract class ScreenShotContentObserver
extends ContentObserver {
    private Context context;
    private boolean isFromEdit = false;
    private String previousPath;

    ScreenShotContentObserver(Handler handler, Context context) {
        super(handler);
        this.context = context;
    }

    public boolean deliverSelfNotifications() {
        return super.deliverSelfNotifications();
    }

    public void onChange(boolean selfChange) {
        super.onChange(selfChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(boolean selfChange, Uri uri) {
        block8: {
            try (Cursor cursor = null;){
                cursor = this.context.getContentResolver().query(uri, new String[]{"_display_name", "_data"}, null, null, null);
                if (cursor == null || !cursor.moveToLast()) break block8;
                int displayNameColumnIndex = cursor.getColumnIndex("_display_name");
                int dataColumnIndex = cursor.getColumnIndex("_data");
                String fileName = cursor.getString(displayNameColumnIndex);
                String path = cursor.getString(dataColumnIndex);
                if (new File(path).lastModified() >= System.currentTimeMillis() - 10000L) {
                    if (!(!this.isScreenshot(path) || this.isFromEdit || this.previousPath != null && this.previousPath.equals(path))) {
                        this.onScreenShot(path, fileName);
                    }
                    this.previousPath = path;
                    this.isFromEdit = false;
                    break block8;
                }
                cursor.close();
                return;
            }
        }
        super.onChange(selfChange, uri);
    }

    private boolean isScreenshot(String path) {
        return path != null && path.toLowerCase().contains("screenshot");
    }

    protected abstract void onScreenShot(String var1, String var2);
}

