/*
 * Decompiled with CFR 0.152.
 */
package com.arjinmc.recyclerviewdecoration;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;

public class RecyclerViewStickyHeadItemDecoration
extends RecyclerView.ItemDecoration {
    private View mStickyView;
    private RecyclerView mParent;
    private int mStickyViewHeight;
    private int mStickyViewMarginTop;
    private int mGroupViewType = 0;
    private List<Integer> mStickyPositionList = new ArrayList<Integer>();
    private int mBindStickyViewPosition = -1;
    private RecyclerView.ViewHolder mCurrentStickyViewHolder;

    public void setParam(Param param) {
        this.mGroupViewType = param.groupViewType;
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDrawOver(c, parent, state);
        if (parent == null || parent.getAdapter() == null || parent.getAdapter().getItemCount() == 0 || parent.getLayoutManager() == null) {
            return;
        }
        if (parent.getLayoutManager() instanceof LinearLayoutManager) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)parent.getLayoutManager();
            boolean findStickView = false;
            int itemCount = parent.getChildCount();
            for (int i = 0; i < itemCount; ++i) {
                View view = parent.getChildAt(i);
                if (!this.isGroupViewType(parent.getChildAdapterPosition(view))) continue;
                findStickView = true;
                if (this.mCurrentStickyViewHolder == null) {
                    this.mCurrentStickyViewHolder = parent.getAdapter().onCreateViewHolder((ViewGroup)parent, this.mGroupViewType);
                    this.mStickyView = this.mCurrentStickyViewHolder.itemView;
                }
                if (view.getTop() <= 0) {
                    this.bindDataForStickyView(layoutManager.findFirstVisibleItemPosition());
                } else if (this.mStickyPositionList.size() > 0) {
                    if (this.mStickyPositionList.size() == 1) {
                        this.bindDataForStickyView(this.mStickyPositionList.get(0));
                    } else {
                        int currentPosition = layoutManager.findFirstVisibleItemPosition() + i;
                        int indexOfCurrentPosition = this.mStickyPositionList.lastIndexOf(currentPosition);
                        this.bindDataForStickyView(this.mStickyPositionList.get(indexOfCurrentPosition - 1));
                    }
                }
                if (view.getTop() > 0 && view.getTop() <= this.mStickyViewHeight) {
                    this.mStickyViewMarginTop = this.mStickyViewHeight - view.getTop();
                } else {
                    this.mStickyViewMarginTop = 0;
                    View nextStickyView = this.getNextStickyView();
                    if (nextStickyView != null && nextStickyView.getTop() <= this.mStickyViewHeight) {
                        this.mStickyViewMarginTop = this.mStickyViewHeight - nextStickyView.getTop();
                    }
                }
                this.drawStickyView(c);
                break;
            }
            if (!findStickView) {
                this.mStickyViewMarginTop = 0;
                if (layoutManager.findFirstVisibleItemPosition() + parent.getChildCount() == parent.getAdapter().getItemCount() && this.mStickyPositionList.size() > 0) {
                    this.bindDataForStickyView(this.mStickyPositionList.get(this.mStickyPositionList.size() - 1));
                }
                this.drawStickyView(c);
            }
        } else {
            try {
                throw new IllegalAccessException("Only support RecyclerView LinearLayoutManager.VERTICAL");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        if (this.mParent == null) {
            if (parent.getLayoutManager() instanceof LinearLayoutManager && ((LinearLayoutManager)parent.getLayoutManager()).getOrientation() != 1) {
                throw new IllegalArgumentException("Only support LinearLayoutManager.VERTICAL");
            }
            this.mParent = parent;
            this.initListener();
        }
    }

    private void initListener() {
        this.mParent.getAdapter().registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                super.onChanged();
                RecyclerViewStickyHeadItemDecoration.this.initStickyPositionList();
            }

            public void onItemRangeChanged(int positionStart, int itemCount) {
                super.onItemRangeChanged(positionStart, itemCount);
                RecyclerViewStickyHeadItemDecoration.this.initStickyPositionList();
            }

            public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
                super.onItemRangeChanged(positionStart, itemCount, payload);
                RecyclerViewStickyHeadItemDecoration.this.initStickyPositionList();
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                super.onItemRangeInserted(positionStart, itemCount);
                RecyclerViewStickyHeadItemDecoration.this.initStickyPositionList();
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                super.onItemRangeMoved(fromPosition, toPosition, itemCount);
                RecyclerViewStickyHeadItemDecoration.this.initStickyPositionList();
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                super.onItemRangeRemoved(positionStart, itemCount);
                RecyclerViewStickyHeadItemDecoration.this.initStickyPositionList();
            }
        });
        this.initStickyPositionList();
    }

    private void initStickyPositionList() {
        if (this.mParent == null || this.mParent.getAdapter() == null) {
            return;
        }
        if (this.mStickyPositionList == null) {
            this.mStickyPositionList = new ArrayList<Integer>();
        } else {
            this.mStickyPositionList.clear();
        }
        this.mBindStickyViewPosition = -1;
        int itemCount = this.mParent.getAdapter().getItemCount();
        if (itemCount > 0) {
            for (int i = 0; i < itemCount; ++i) {
                if (!this.isGroupViewType(i)) continue;
                this.mStickyPositionList.add(i);
            }
            View lGroupView = this.mParent.getChildAt(this.mStickyPositionList.get(0).intValue());
            if (lGroupView != null) {
                lGroupView.measure(0, 0);
                this.mStickyViewHeight = lGroupView.getMeasuredHeight();
            }
        }
    }

    private void drawStickyView(Canvas canvas) {
        if (this.mStickyView == null) {
            return;
        }
        int saveCount = canvas.save();
        canvas.translate(0.0f, (float)(-this.mStickyViewMarginTop));
        this.mStickyView.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    private void bindDataForStickyView(int position) {
        if (this.mBindStickyViewPosition == position || this.mCurrentStickyViewHolder == null) {
            return;
        }
        this.mBindStickyViewPosition = position;
        this.mParent.getAdapter().onBindViewHolder(this.mCurrentStickyViewHolder, this.mBindStickyViewPosition);
        this.mStickyView = this.mCurrentStickyViewHolder.itemView;
        this.measureStickyView();
        this.mStickyViewHeight = this.mCurrentStickyViewHolder.itemView.getBottom() - this.mCurrentStickyViewHolder.itemView.getTop();
    }

    private View getNextStickyView() {
        if (this.mParent == null) {
            return null;
        }
        int num = 0;
        View nextStickyView = null;
        int size = this.mParent.getChildCount();
        for (int i = 0; i < size; ++i) {
            View view = this.mParent.getChildAt(i);
            if (this.isGroupViewType(this.mParent.getChildAdapterPosition(view))) {
                nextStickyView = view;
                ++num;
            }
            if (num == 2) break;
        }
        return num >= 2 ? nextStickyView : null;
    }

    private void measureStickyView() {
        if (this.mParent == null || this.mStickyView == null || !this.mStickyView.isLayoutRequested()) {
            return;
        }
        int parentWidth = this.mParent.getMeasuredWidth();
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)parentWidth, (int)0x40000000);
        ViewGroup.LayoutParams layoutParams = this.mStickyView.getLayoutParams();
        int heightSpec = layoutParams != null && layoutParams.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)layoutParams.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.mStickyView.measure(widthSpec, heightSpec);
        this.mStickyView.layout(0, 0, this.mStickyView.getMeasuredWidth(), this.mStickyView.getMeasuredHeight());
    }

    private boolean isGroupViewType(int position) {
        if (this.mParent == null || this.mParent.getAdapter() == null || position < 0) {
            return false;
        }
        return this.mParent.getAdapter().getItemCount() != 0 && this.mParent.getAdapter().getItemCount() > position && this.mParent.getAdapter().getItemViewType(position) == this.mGroupViewType;
    }

    private static class Param {
        public int groupViewType;

        private Param() {
        }
    }

    public static class Builder {
        private Param param = new Param();

        public Builder groupViewType(int groupViewType) {
            this.param.groupViewType = groupViewType;
            return this;
        }

        public RecyclerViewStickyHeadItemDecoration create() {
            RecyclerViewStickyHeadItemDecoration recyclerViewStickyHeadItemDecoration = new RecyclerViewStickyHeadItemDecoration();
            recyclerViewStickyHeadItemDecoration.setParam(this.param);
            return recyclerViewStickyHeadItemDecoration;
        }
    }
}

