/*
 * Decompiled with CFR 0.152.
 */
package com.arjinmc.recyclerviewdecoration;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.collection.ArrayMap;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.arjinmc.recyclerviewdecoration.RVItemDecorationUtil;

public class RecyclerViewLinearItemDecoration
extends RecyclerView.ItemDecoration {
    private static final String DEFAULT_COLOR = "#bdbdbd";
    private int mDrawableRid = 0;
    private int mColor = Color.parseColor((String)"#bdbdbd");
    private int mThickness;
    private int mDashWidth = 0;
    private int mDashGap = 0;
    private boolean mFirstLineVisible;
    private boolean mLastLineVisible;
    private int mPaddingStart = 0;
    private int mPaddingEnd = 0;
    private ArrayMap<Integer, Integer> mIgnoreTypes;
    private int mMode;
    private Paint mPaint;
    private Bitmap mBmp;
    private NinePatch mNinePatch;
    private int mCurrentThickness;
    private boolean hasNinePatch = false;
    private boolean hasGetParentLayoutMode = false;
    private Context mContext;

    public void setParams(Context context, Param params) {
        this.mContext = context;
        this.mDrawableRid = params.drawableRid;
        this.mColor = params.color;
        this.mThickness = params.thickness;
        this.mDashGap = params.dashGap;
        this.mDashWidth = params.dashWidth;
        this.mPaddingStart = params.paddingStart;
        this.mPaddingEnd = params.paddingEnd;
        this.mFirstLineVisible = params.firstLineVisible;
        this.mLastLineVisible = params.lastLineVisible;
        if (params.ignoreTypes != null && params.ignoreTypes.length != 0) {
            this.mIgnoreTypes = new ArrayMap();
            int ignoreTypeSize = params.ignoreTypes.length;
            for (int i = 0; i < ignoreTypeSize; ++i) {
                this.mIgnoreTypes.put((Object)params.ignoreTypes[i], (Object)params.ignoreTypes[i]);
            }
        }
    }

    private void initPaint(Context context) {
        this.mBmp = BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.mDrawableRid);
        if (this.mBmp != null) {
            if (this.mBmp.getNinePatchChunk() != null) {
                this.hasNinePatch = true;
                this.mNinePatch = new NinePatch(this.mBmp, this.mBmp.getNinePatchChunk(), null);
            }
            if (this.mMode == 0) {
                int n = this.mCurrentThickness = this.mThickness == 0 ? this.mBmp.getHeight() : this.mThickness;
            }
            if (this.mMode == 1) {
                this.mCurrentThickness = this.mThickness == 0 ? this.mBmp.getWidth() : this.mThickness;
            }
        } else {
            this.mCurrentThickness = this.mThickness;
        }
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.mCurrentThickness);
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (parent.getAdapter() == null || parent.getChildCount() == 0) {
            return;
        }
        this.mPaint.setColor(this.mColor);
        if (this.mMode == 0) {
            this.drawHorizontal(c, parent);
        } else if (this.mMode == 1) {
            this.drawVertical(c, parent);
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (!this.hasGetParentLayoutMode) {
            this.compatibleWithLayoutManager(parent);
            this.hasGetParentLayoutMode = true;
        }
        int viewPosition = parent.getLayoutManager().getPosition(view);
        if (this.mMode == 0) {
            if (!this.isIgnoreType(parent.getAdapter().getItemViewType(viewPosition))) {
                if (this.mLastLineVisible || viewPosition != parent.getAdapter().getItemCount() - 1) {
                    outRect.set(0, 0, 0, this.mCurrentThickness);
                }
                if (this.mFirstLineVisible && viewPosition == 0) {
                    outRect.set(0, this.mCurrentThickness, 0, this.mCurrentThickness);
                }
            } else {
                outRect.set(0, 0, 0, 0);
            }
        } else if (this.mMode == 1) {
            if (!this.isIgnoreType(parent.getAdapter().getItemViewType(viewPosition))) {
                if (this.mLastLineVisible || viewPosition != parent.getAdapter().getItemCount() - 1) {
                    outRect.set(0, 0, this.mCurrentThickness, 0);
                }
                if (this.mFirstLineVisible && viewPosition == 0) {
                    outRect.set(this.mCurrentThickness, 0, this.mCurrentThickness, 0);
                }
            } else {
                outRect.set(0, 0, 0, 0);
            }
        }
    }

    private boolean isPureLine() {
        return this.mDashGap == 0 && this.mDashWidth == 0;
    }

    private void drawHorizontal(Canvas c, RecyclerView parent) {
        int childrenCount = parent.getChildCount();
        if (parent.getClipToPadding()) {
            int top = parent.getPaddingTop();
            int bottom = parent.getHeight() - parent.getPaddingBottom();
            c.clipRect(parent.getPaddingLeft(), top, parent.getWidth() - parent.getPaddingRight(), bottom);
        }
        if (this.mDrawableRid != 0) {
            if (this.mFirstLineVisible) {
                View childView = parent.getChildAt(0);
                int myY = childView.getTop();
                if (!this.isIgnoreType(parent.getAdapter().getItemViewType(parent.getLayoutManager().getPosition(childView)))) {
                    if (this.hasNinePatch) {
                        Rect rect = new Rect(this.mPaddingStart + parent.getPaddingLeft(), myY - this.mCurrentThickness, parent.getWidth() - parent.getPaddingRight() - this.mPaddingEnd, myY);
                        this.mNinePatch.draw(c, rect);
                    } else {
                        c.drawBitmap(this.mBmp, (float)(this.mPaddingStart + parent.getPaddingLeft()), (float)(myY - this.mCurrentThickness), this.mPaint);
                    }
                }
            }
            for (int i = 0; i < childrenCount && (this.mLastLineVisible || i != childrenCount - 1); ++i) {
                View childView = parent.getChildAt(i);
                if (this.isIgnoreType(parent.getAdapter().getItemViewType(parent.getLayoutManager().getPosition(childView)))) continue;
                int myY = childView.getBottom();
                if (this.hasNinePatch) {
                    Rect rect = new Rect(this.mPaddingStart + parent.getPaddingLeft(), myY, parent.getWidth() - parent.getPaddingRight() - this.mPaddingEnd, myY + this.mCurrentThickness);
                    this.mNinePatch.draw(c, rect);
                    continue;
                }
                c.drawBitmap(this.mBmp, (float)(this.mPaddingStart + parent.getPaddingLeft()), (float)myY, this.mPaint);
            }
        } else {
            boolean isPureLine = this.isPureLine();
            if (!isPureLine) {
                DashPathEffect effects = new DashPathEffect(new float[]{0.0f, 0.0f, this.mDashWidth, this.mCurrentThickness}, (float)this.mDashGap);
                this.mPaint.setPathEffect((PathEffect)effects);
            }
            if (this.mFirstLineVisible) {
                View childView = parent.getChildAt(0);
                if (!this.isIgnoreType(parent.getAdapter().getItemViewType(parent.getLayoutManager().getPosition(childView)))) {
                    int myY = childView.getTop() - this.mCurrentThickness / 2;
                    Path path = new Path();
                    path.moveTo((float)(this.mPaddingStart + parent.getPaddingLeft()), (float)myY);
                    path.lineTo((float)(parent.getWidth() - this.mPaddingEnd - parent.getPaddingRight()), (float)myY);
                    c.drawPath(path, this.mPaint);
                }
            }
            for (int i = 0; i < childrenCount && (this.mLastLineVisible || i != childrenCount - 1); ++i) {
                View childView = parent.getChildAt(i);
                if (this.isIgnoreType(parent.getAdapter().getItemViewType(parent.getLayoutManager().getPosition(childView)))) continue;
                int myY = childView.getBottom() + this.mCurrentThickness / 2;
                Path path = new Path();
                path.moveTo((float)(this.mPaddingStart + parent.getPaddingLeft()), (float)myY);
                path.lineTo((float)(parent.getWidth() - this.mPaddingEnd - parent.getPaddingRight()), (float)myY);
                c.drawPath(path, this.mPaint);
            }
        }
    }

    private void drawVertical(Canvas c, RecyclerView parent) {
        int childrenCount = parent.getChildCount();
        if (parent.getClipToPadding()) {
            int left = parent.getPaddingLeft();
            int right = parent.getWidth() - parent.getPaddingRight();
            c.clipRect(left, parent.getPaddingTop(), right, parent.getHeight() - parent.getPaddingBottom());
        }
        if (this.mDrawableRid != 0) {
            if (this.mFirstLineVisible) {
                View childView = parent.getChildAt(0);
                if (!this.isIgnoreType(parent.getAdapter().getItemViewType(parent.getLayoutManager().getPosition(childView)))) {
                    int myX = childView.getLeft();
                    if (this.hasNinePatch) {
                        Rect rect = new Rect(myX - this.mCurrentThickness, this.mPaddingStart + parent.getPaddingLeft(), myX, parent.getHeight() - this.mPaddingEnd - parent.getPaddingRight());
                        this.mNinePatch.draw(c, rect);
                    } else {
                        c.drawBitmap(this.mBmp, (float)(myX - this.mCurrentThickness), (float)(this.mPaddingStart + parent.getPaddingLeft()), this.mPaint);
                    }
                }
            }
            for (int i = 0; i < childrenCount && (this.mLastLineVisible || i != childrenCount - 1); ++i) {
                View childView = parent.getChildAt(i);
                if (this.isIgnoreType(parent.getAdapter().getItemViewType(parent.getLayoutManager().getPosition(childView)))) continue;
                int myX = childView.getRight();
                if (this.hasNinePatch) {
                    Rect rect = new Rect(myX, this.mPaddingStart + parent.getPaddingLeft(), myX + this.mCurrentThickness, parent.getHeight() - this.mPaddingEnd - parent.getPaddingRight());
                    this.mNinePatch.draw(c, rect);
                    continue;
                }
                c.drawBitmap(this.mBmp, (float)myX, (float)(this.mPaddingStart + parent.getPaddingLeft()), this.mPaint);
            }
        } else {
            boolean isPureLine = this.isPureLine();
            if (!isPureLine) {
                DashPathEffect effects = new DashPathEffect(new float[]{0.0f, 0.0f, this.mDashWidth, this.mCurrentThickness}, (float)this.mDashGap);
                this.mPaint.setPathEffect((PathEffect)effects);
            }
            if (this.mFirstLineVisible) {
                View childView = parent.getChildAt(0);
                if (!this.isIgnoreType(parent.getAdapter().getItemViewType(parent.getLayoutManager().getPosition(childView)))) {
                    int myX = childView.getLeft() - this.mCurrentThickness / 2;
                    Path path = new Path();
                    path.moveTo((float)myX, (float)(this.mPaddingStart + parent.getPaddingLeft()));
                    path.lineTo((float)myX, (float)(parent.getHeight() - this.mPaddingEnd - parent.getPaddingRight()));
                    c.drawPath(path, this.mPaint);
                }
            }
            for (int i = 0; i < childrenCount && (this.mLastLineVisible || i != childrenCount - 1); ++i) {
                View childView = parent.getChildAt(i);
                if (this.isIgnoreType(parent.getAdapter().getItemViewType(parent.getLayoutManager().getPosition(childView)))) continue;
                int myX = childView.getRight() + this.mCurrentThickness / 2;
                Path path = new Path();
                path.moveTo((float)myX, (float)(this.mPaddingStart + parent.getPaddingLeft()));
                path.lineTo((float)myX, (float)(parent.getHeight() - this.mPaddingEnd - parent.getPaddingRight()));
                c.drawPath(path, this.mPaint);
            }
        }
    }

    private boolean isFirstGridColumn(int position, int columnSize) {
        return position % columnSize == 0;
    }

    private boolean isLastGridColumn(int position, int itemSize, int columnSize) {
        boolean isLast = false;
        if ((position + 1) % columnSize == 0) {
            isLast = true;
        }
        return isLast;
    }

    private boolean isFirstGridRow(int position, int columnSize) {
        return position < columnSize;
    }

    private boolean isLastGridRow(int position, int itemSize, int columnSize) {
        int temp = itemSize % columnSize;
        if (temp == 0 && position >= itemSize - columnSize) {
            return true;
        }
        return position >= itemSize / columnSize * columnSize;
    }

    private boolean isLastSecondGridRowNotDivided(int position, int itemSize, int columnSize) {
        int temp = itemSize % columnSize;
        return temp != 0 && itemSize - 1 - temp == position;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void compatibleWithLayoutManager(RecyclerView parent) {
        block7: {
            if (parent.getLayoutManager() != null) {
                if (parent.getLayoutManager() instanceof LinearLayoutManager) {
                    this.mMode = ((LinearLayoutManager)parent.getLayoutManager()).getOrientation() == 0 ? 1 : 0;
                    break block7;
                } else {
                    try {
                        throw new IllegalAccessException("RecyclerViewLinearItemDecoration only support LinearLayoutManager");
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            }
            try {
                throw new IllegalAccessException("RecyclerViewLinearItemDecoration only support LinearLayoutManager");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return;
            }
        }
        this.initPaint(this.mContext);
    }

    private boolean isIgnoreType(int viewType) {
        if (this.mIgnoreTypes == null || this.mIgnoreTypes.isEmpty()) {
            return false;
        }
        return this.mIgnoreTypes.containsKey((Object)viewType);
    }

    private static class Param {
        public int drawableRid = 0;
        public int color = Color.parseColor((String)"#bdbdbd");
        public int thickness;
        public int dashWidth = 0;
        public int dashGap = 0;
        public boolean lastLineVisible;
        public boolean firstLineVisible;
        public int paddingStart;
        public int paddingEnd;
        public int[] ignoreTypes;

        private Param() {
        }
    }

    public static class Builder {
        private Param params = new Param();
        private Context context;

        public Builder(Context context) {
            this.context = context;
        }

        public RecyclerViewLinearItemDecoration create() {
            RecyclerViewLinearItemDecoration recyclerViewLinearItemDecoration = new RecyclerViewLinearItemDecoration();
            recyclerViewLinearItemDecoration.setParams(this.context, this.params);
            return recyclerViewLinearItemDecoration;
        }

        public Builder drawableID(@DrawableRes int drawableID) {
            this.params.drawableRid = drawableID;
            return this;
        }

        public Builder color(@ColorInt int color) {
            this.params.color = color;
            return this;
        }

        public Builder color(String color) {
            if (RVItemDecorationUtil.isColorString(color)) {
                this.params.color = Color.parseColor((String)color);
            }
            return this;
        }

        public Builder thickness(int thickness) {
            if (thickness % 2 != 0) {
                ++thickness;
            }
            if (thickness <= 2) {
                thickness = 2;
            }
            this.params.thickness = thickness;
            return this;
        }

        public Builder dashWidth(int dashWidth) {
            if (dashWidth < 0) {
                dashWidth = 0;
            }
            this.params.dashWidth = dashWidth;
            return this;
        }

        public Builder dashGap(int dashGap) {
            if (dashGap < 0) {
                dashGap = 0;
            }
            this.params.dashGap = dashGap;
            return this;
        }

        public Builder lastLineVisible(boolean visible) {
            this.params.lastLineVisible = visible;
            return this;
        }

        public Builder firstLineVisible(boolean visible) {
            this.params.firstLineVisible = visible;
            return this;
        }

        public Builder paddingStart(int padding) {
            if (padding < 0) {
                padding = 0;
            }
            this.params.paddingStart = padding;
            return this;
        }

        public Builder paddingEnd(int padding) {
            if (padding < 0) {
                padding = 0;
            }
            this.params.paddingEnd = padding;
            return this;
        }

        public Builder ignoreTypes(int[] ignoreTypes) {
            this.params.ignoreTypes = ignoreTypes;
            return this;
        }
    }
}

