/*
 * Decompiled with CFR 0.152.
 */
package com.arjinmc.recyclerviewdecoration;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

public class RecyclerViewGridSpaceItemDecoration
extends RecyclerView.ItemDecoration {
    private int mHorizontalSpacing;
    private int mVerticalSpacing;
    private boolean mBorderVisible;

    public RecyclerViewGridSpaceItemDecoration() {
    }

    public RecyclerViewGridSpaceItemDecoration(int spacing, boolean borderVisible) {
        this.mHorizontalSpacing = spacing;
        this.mVerticalSpacing = spacing;
        this.mBorderVisible = borderVisible;
    }

    public RecyclerViewGridSpaceItemDecoration(int horizontalSpacing, int verticalSpacing, boolean borderVisible) {
        this.mHorizontalSpacing = horizontalSpacing;
        this.mVerticalSpacing = verticalSpacing;
        this.mBorderVisible = borderVisible;
    }

    public RecyclerViewGridSpaceItemDecoration(int spacing) {
        this.mHorizontalSpacing = spacing;
        this.mVerticalSpacing = spacing;
    }

    public RecyclerViewGridSpaceItemDecoration(int horizontalSpacing, int verticalSpacing) {
        this.mHorizontalSpacing = horizontalSpacing;
        this.mVerticalSpacing = verticalSpacing;
    }

    public void setParams(Param params) {
        if (params.margin > 0) {
            this.mHorizontalSpacing = params.margin;
            this.mVerticalSpacing = params.margin;
        } else {
            this.mHorizontalSpacing = params.marginHorizontal;
            this.mVerticalSpacing = params.marginVertical;
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (parent.getChildCount() == 0) {
            return;
        }
        if (parent.getLayoutManager() instanceof GridLayoutManager) {
            GridLayoutManager layoutManager = (GridLayoutManager)parent.getLayoutManager();
            if (layoutManager.getOrientation() == 0) {
                try {
                    throw new IllegalAccessException("RecyclerViewGridSpaceItemDecoration only support GridLayoutManager/StaggeredGridLayoutManager Vertical");
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return;
                }
            }
            int position = parent.getChildAdapterPosition(view);
            int spanCount = layoutManager.getSpanCount();
            GridLayoutManager.LayoutParams lp = (GridLayoutManager.LayoutParams)view.getLayoutParams();
            int column = lp.getSpanIndex();
            this.getGridItemOffsets(outRect, position, column, spanCount);
        } else if (parent.getLayoutManager() instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager layoutManager = (StaggeredGridLayoutManager)parent.getLayoutManager();
            if (layoutManager.getOrientation() == 0) {
                try {
                    throw new IllegalAccessException("RecyclerViewGridSpaceItemDecoration only support GridLayoutManager/StaggeredGridLayoutManager Vertical");
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return;
                }
            }
            int position = parent.getChildAdapterPosition(view);
            int spanCount = layoutManager.getSpanCount();
            StaggeredGridLayoutManager.LayoutParams lp = (StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams();
            int column = lp.getSpanIndex();
            this.getGridItemOffsets(outRect, position, column, spanCount);
        } else {
            try {
                throw new IllegalAccessException("RecyclerViewGridSpaceItemDecoration only support GridLayoutManager/StaggeredGridLayoutManager");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void getGridItemOffsets(Rect outRect, int position, int column, int spanCount) {
        if (this.mBorderVisible) {
            outRect.left = this.mHorizontalSpacing * (spanCount - column) / spanCount;
            outRect.right = this.mHorizontalSpacing * (column + 1) / spanCount;
            if (position < spanCount) {
                outRect.top = this.mVerticalSpacing;
            }
            outRect.bottom = this.mVerticalSpacing;
        } else {
            outRect.left = this.mHorizontalSpacing * column / spanCount;
            outRect.right = this.mHorizontalSpacing * (spanCount - 1 - column) / spanCount;
            if (position >= spanCount) {
                outRect.top = this.mVerticalSpacing;
            }
        }
    }

    public static class Param {
        public int margin;
        public int marginHorizontal;
        public int marginVertical;
        public boolean borderVisible;
    }

    public static class Builder {
        private Context context;
        private Param param;

        public Builder(Context context) {
            this.context = context;
            this.param = new Param();
        }

        public Builder margin(int margin) {
            if (margin < 0) {
                margin = 0;
            }
            this.param.margin = margin;
            return this;
        }

        public Builder marginHorizontal(int margin) {
            if (margin < 0) {
                margin = 0;
            }
            this.param.marginHorizontal = margin;
            return this;
        }

        public Builder marginVertical(int margin) {
            if (margin < 0) {
                margin = 0;
            }
            this.param.marginVertical = margin;
            return this;
        }

        public Builder borderVisible(boolean visible) {
            this.param.borderVisible = visible;
            return this;
        }

        public RecyclerViewGridSpaceItemDecoration create() {
            RecyclerViewGridSpaceItemDecoration recyclerViewGridSpaceItemDecoration = new RecyclerViewGridSpaceItemDecoration();
            recyclerViewGridSpaceItemDecoration.setParams(this.param);
            return recyclerViewGridSpaceItemDecoration;
        }
    }
}

