/*
 * Decompiled with CFR 0.152.
 */
package com.arjinmc.recyclerviewdecoration;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.arjinmc.recyclerviewdecoration.RVItemDecorationUtil;

public class RecyclerViewGridItemDecoration
extends RecyclerView.ItemDecoration {
    private static final String DEFAULT_COLOR = "#bdbdbd";
    private int mColor;
    private int mHorizontalSpacing = 0;
    private int mVerticalSpacing = 0;
    private boolean mBorderVisible;
    private Paint mPaint;

    public void setParams(Param param) {
        this.mColor = param.color;
        this.mHorizontalSpacing = param.horizontalSpacing;
        this.mVerticalSpacing = param.verticalSpacing;
        this.mBorderVisible = param.borderVisible;
        this.initPaint();
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        GridLayoutManager layoutManager;
        if (parent.getChildCount() == 0) {
            return;
        }
        if (parent.getLayoutManager() instanceof GridLayoutManager) {
            layoutManager = (GridLayoutManager)parent.getLayoutManager();
            if (layoutManager.getOrientation() == 0) {
                try {
                    throw new IllegalAccessException("RecyclerViewGridSpaceItemDecoration only support GridLayoutManager Vertical");
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return;
                }
            }
        } else {
            try {
                throw new IllegalAccessException("RecyclerViewGridSpaceItemDecoration only support GridLayoutManager Vertical");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return;
            }
        }
        int position = parent.getChildAdapterPosition(view);
        int spanCount = layoutManager.getSpanCount();
        GridLayoutManager.LayoutParams lp = (GridLayoutManager.LayoutParams)view.getLayoutParams();
        int column = lp.getSpanIndex();
        this.getGridItemOffsets(outRect, position, column, spanCount);
    }

    public void onDraw(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.onDraw(c, parent, state);
        if (parent.getChildCount() == 0) {
            return;
        }
        this.drawGrid(c, parent);
    }

    private void drawGrid(Canvas c, RecyclerView parent) {
        int childrenCount = parent.getChildCount();
        int columnSize = ((GridLayoutManager)parent.getLayoutManager()).getSpanCount();
        int itemSize = parent.getAdapter().getItemCount();
        for (int i = 0; i < childrenCount; ++i) {
            Path path;
            View childView = parent.getChildAt(i);
            int myT = childView.getTop();
            int myB = childView.getBottom();
            int myL = childView.getLeft();
            int myR = childView.getRight();
            int viewPosition = parent.getLayoutManager().getPosition(childView);
            if (columnSize == 1) {
                Path path2;
                if (this.isFirstGridRow(viewPosition, columnSize)) {
                    if (this.mBorderVisible) {
                        this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                        path2 = new Path();
                        path2.moveTo((float)(myL - this.mHorizontalSpacing / 2), (float)myT);
                        path2.lineTo((float)(myL - this.mHorizontalSpacing / 2), (float)myB);
                        c.drawPath(path2, this.mPaint);
                    }
                    if (this.mBorderVisible) {
                        this.mPaint.setStrokeWidth((float)this.mVerticalSpacing);
                        path2 = new Path();
                        path2.moveTo((float)(myL - this.mHorizontalSpacing), (float)(myT - this.mVerticalSpacing / 2));
                        path2.lineTo((float)(myR + this.mHorizontalSpacing), (float)(myT - this.mVerticalSpacing / 2));
                        c.drawPath(path2, this.mPaint);
                    }
                    if (this.mBorderVisible) {
                        this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                        path2 = new Path();
                        path2.moveTo((float)(myR + this.mHorizontalSpacing / 2), (float)myT);
                        path2.lineTo((float)(myR + this.mHorizontalSpacing / 2), (float)myB);
                        c.drawPath(path2, this.mPaint);
                    }
                } else {
                    if (this.mBorderVisible) {
                        this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                        Path path3 = new Path();
                        path3.moveTo((float)(myL - this.mHorizontalSpacing / 2), (float)(myT - this.mVerticalSpacing));
                        path3.lineTo((float)(myL - this.mHorizontalSpacing / 2), (float)myB);
                        c.drawPath(path3, this.mPaint);
                    }
                    if (this.mBorderVisible) {
                        Path path4 = new Path();
                        this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                        path4.moveTo((float)(myR + this.mHorizontalSpacing / 2), (float)myT);
                        path4.lineTo((float)(myR + this.mHorizontalSpacing / 2), (float)myB);
                        c.drawPath(path4, this.mPaint);
                    }
                }
                if (this.isLastGridRow(viewPosition, itemSize, columnSize)) {
                    if (!this.mBorderVisible) continue;
                    this.mPaint.setStrokeWidth((float)this.mVerticalSpacing);
                    path2 = new Path();
                    path2.moveTo((float)(myL - this.mHorizontalSpacing), (float)(myB + this.mVerticalSpacing / 2));
                    path2.lineTo((float)(myR + this.mHorizontalSpacing), (float)(myB + this.mVerticalSpacing / 2));
                    c.drawPath(path2, this.mPaint);
                    continue;
                }
                this.mPaint.setStrokeWidth((float)this.mVerticalSpacing);
                path2 = new Path();
                path2.moveTo((float)myL, (float)(myB + this.mVerticalSpacing / 2));
                path2.lineTo((float)(myR + this.mHorizontalSpacing), (float)(myB + this.mVerticalSpacing / 2));
                c.drawPath(path2, this.mPaint);
                continue;
            }
            if (this.isFirstGridColumn(viewPosition, columnSize) && this.isFirstGridRow(viewPosition, columnSize)) {
                if (this.mBorderVisible) {
                    this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                    Path path5 = new Path();
                    path5.moveTo((float)(myL - this.mHorizontalSpacing / 2), (float)(myT - this.mVerticalSpacing));
                    path5.lineTo((float)(myL - this.mHorizontalSpacing / 2), (float)myB);
                    c.drawPath(path5, this.mPaint);
                }
                if (this.mBorderVisible) {
                    this.mPaint.setStrokeWidth((float)this.mVerticalSpacing);
                    Path path6 = new Path();
                    path6.moveTo((float)myL, (float)(myT - this.mVerticalSpacing / 2));
                    path6.lineTo((float)(myR + this.mHorizontalSpacing / 2), (float)(myT - this.mVerticalSpacing / 2));
                    c.drawPath(path6, this.mPaint);
                }
                if (itemSize == 1) {
                    if (this.mBorderVisible) {
                        this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                        Path path7 = new Path();
                        path7.moveTo((float)(myR + this.mHorizontalSpacing / 2), (float)(myT - this.mHorizontalSpacing));
                        path7.lineTo((float)(myR + this.mHorizontalSpacing / 2), (float)myB);
                        c.drawPath(path7, this.mPaint);
                    }
                } else {
                    this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                    Path path8 = new Path();
                    path8.moveTo((float)(myR + this.mHorizontalSpacing / 2), (float)myT);
                    path8.lineTo((float)(myR + this.mHorizontalSpacing / 2), (float)myB);
                    c.drawPath(path8, this.mPaint);
                }
            } else if (this.isFirstGridRow(viewPosition, columnSize)) {
                if (this.mBorderVisible) {
                    if (this.isLastGridColumn(viewPosition, itemSize, columnSize)) {
                        this.mPaint.setStrokeWidth((float)this.mVerticalSpacing);
                        Path path9 = new Path();
                        path9.moveTo((float)(myL - this.mHorizontalSpacing / 2), (float)(myT - this.mVerticalSpacing / 2));
                        path9.lineTo((float)myR, (float)(myT - this.mVerticalSpacing / 2));
                        c.drawPath(path9, this.mPaint);
                    } else {
                        this.mPaint.setStrokeWidth((float)this.mVerticalSpacing);
                        Path path10 = new Path();
                        path10.moveTo((float)(myL - this.mHorizontalSpacing / 2), (float)(myT - this.mVerticalSpacing / 2));
                        path10.lineTo((float)(myR + this.mHorizontalSpacing / 2), (float)(myT - this.mVerticalSpacing / 2));
                        c.drawPath(path10, this.mPaint);
                    }
                }
                if (this.isLastGridColumn(viewPosition, itemSize, columnSize)) {
                    this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                    if (this.mBorderVisible) {
                        int alterY = 0;
                        if (this.isLastSecondGridRowNotDivided(viewPosition, itemSize, columnSize)) {
                            alterY = this.mHorizontalSpacing;
                        }
                        path = new Path();
                        path.moveTo((float)(myR + this.mHorizontalSpacing / 2), (float)(myT - this.mHorizontalSpacing - this.mVerticalSpacing));
                        path.lineTo((float)(myR + this.mHorizontalSpacing / 2), (float)(myB + alterY + this.mVerticalSpacing / 2));
                        c.drawPath(path, this.mPaint);
                    }
                } else {
                    this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                    Path path11 = new Path();
                    path11.moveTo((float)(myR + this.mHorizontalSpacing / 2), (float)myT);
                    path11.lineTo((float)(myR + this.mHorizontalSpacing / 2), (float)myB);
                    c.drawPath(path11, this.mPaint);
                }
            } else if (this.isFirstGridColumn(viewPosition, columnSize)) {
                if (this.mBorderVisible) {
                    this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                    Path path12 = new Path();
                    path12.moveTo((float)(myL - this.mHorizontalSpacing / 2), (float)myT);
                    path12.lineTo((float)(myL - this.mHorizontalSpacing / 2), (float)myB);
                    c.drawPath(path12, this.mPaint);
                }
                this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                Path path13 = new Path();
                path13.moveTo((float)(myR + this.mHorizontalSpacing / 2), (float)myT);
                path13.lineTo((float)(myR + this.mHorizontalSpacing / 2), (float)myB);
                c.drawPath(path13, this.mPaint);
            } else {
                this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                if (this.isLastGridColumn(viewPosition, itemSize, columnSize)) {
                    if (this.mBorderVisible) {
                        int alterY = 0;
                        if (this.isLastSecondGridRowNotDivided(viewPosition, itemSize, columnSize)) {
                            alterY = this.mVerticalSpacing / 2;
                        }
                        path = new Path();
                        path.moveTo((float)(myR + this.mHorizontalSpacing / 2), (float)(myT - this.mVerticalSpacing / 2));
                        path.lineTo((float)(myR + this.mHorizontalSpacing / 2), (float)(myB + alterY + this.mVerticalSpacing / 2));
                        c.drawPath(path, this.mPaint);
                    }
                } else {
                    this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                    Path path14 = new Path();
                    path14.moveTo((float)(myR + this.mHorizontalSpacing / 2), (float)myT);
                    path14.lineTo((float)(myR + this.mHorizontalSpacing / 2), (float)myB);
                    c.drawPath(path14, this.mPaint);
                }
            }
            if (this.isLastGridRow(viewPosition, itemSize, columnSize)) {
                if (!this.mBorderVisible) continue;
                this.mPaint.setStrokeWidth((float)this.mHorizontalSpacing);
                if (itemSize == 1) {
                    Path path15 = new Path();
                    path15.moveTo((float)(myL - this.mHorizontalSpacing), (float)(myB + this.mHorizontalSpacing / 2));
                    path15.lineTo((float)(myR + this.mHorizontalSpacing), (float)(myB + this.mHorizontalSpacing / 2));
                    c.drawPath(path15, this.mPaint);
                    continue;
                }
                if (this.isLastGridColumn(viewPosition, itemSize, columnSize)) {
                    Path path16 = new Path();
                    path16.moveTo((float)(myL - this.mHorizontalSpacing), (float)(myB + this.mHorizontalSpacing / 2));
                    path16.lineTo((float)(myR + this.mHorizontalSpacing), (float)(myB + this.mHorizontalSpacing / 2));
                    c.drawPath(path16, this.mPaint);
                    continue;
                }
                if (this.isFirstGridColumn(viewPosition, columnSize)) {
                    this.mPaint.setStrokeWidth((float)this.mVerticalSpacing);
                    Path path17 = new Path();
                    path17.moveTo((float)(myL - this.mHorizontalSpacing), (float)(myB + this.mVerticalSpacing / 2));
                    path17.lineTo((float)(myR + this.mHorizontalSpacing), (float)(myB + this.mVerticalSpacing / 2));
                    c.drawPath(path17, this.mPaint);
                    continue;
                }
                this.mPaint.setStrokeWidth((float)this.mVerticalSpacing);
                Path path18 = new Path();
                path18.moveTo((float)myL, (float)(myB + this.mVerticalSpacing / 2));
                path18.lineTo((float)(myR + this.mHorizontalSpacing), (float)(myB + this.mVerticalSpacing / 2));
                c.drawPath(path18, this.mPaint);
                continue;
            }
            this.mPaint.setStrokeWidth((float)this.mVerticalSpacing);
            Path path19 = new Path();
            path19.moveTo((float)(myL - this.mHorizontalSpacing), (float)(myB + this.mVerticalSpacing / 2));
            path19.lineTo((float)myR, (float)(myB + this.mVerticalSpacing / 2));
            c.drawPath(path19, this.mPaint);
        }
    }

    private boolean isFirstGridColumn(int position, int columnSize) {
        return position % columnSize == 0;
    }

    private boolean isLastGridColumn(int position, int itemSize, int columnSize) {
        boolean isLast = false;
        if ((position + 1) % columnSize == 0) {
            isLast = true;
        }
        return isLast;
    }

    private boolean isFirstGridRow(int position, int columnSize) {
        return position < columnSize;
    }

    private boolean isLastGridRow(int position, int itemSize, int columnSize) {
        int temp = itemSize % columnSize;
        if (temp == 0 && position >= itemSize - columnSize) {
            return true;
        }
        return position >= itemSize / columnSize * columnSize;
    }

    private boolean isLastSecondGridRowNotDivided(int position, int itemSize, int columnSize) {
        int temp = itemSize % columnSize;
        return temp != 0 && itemSize - 1 - temp == position;
    }

    private void getGridItemOffsets(Rect outRect, int position, int column, int spanCount) {
        if (this.mBorderVisible) {
            outRect.left = this.mHorizontalSpacing * (spanCount - column) / spanCount;
            outRect.right = this.mHorizontalSpacing * (column + 1) / spanCount;
            if (position < spanCount) {
                outRect.top = this.mVerticalSpacing;
            }
            outRect.bottom = this.mVerticalSpacing;
        } else {
            outRect.left = this.mHorizontalSpacing * column / spanCount;
            outRect.right = this.mHorizontalSpacing * (spanCount - 1 - column) / spanCount;
            if (position >= spanCount) {
                outRect.top = this.mVerticalSpacing;
            }
        }
    }

    private static class Param {
        public int color = Color.parseColor((String)"#bdbdbd");
        public int horizontalSpacing = 0;
        public int verticalSpacing = 0;
        public boolean borderVisible;

        private Param() {
        }
    }

    public static class Builder {
        private Param params = new Param();

        public Builder(Context context) {
        }

        public RecyclerViewGridItemDecoration create() {
            RecyclerViewGridItemDecoration recyclerViewItemDecoration = new RecyclerViewGridItemDecoration();
            recyclerViewItemDecoration.setParams(this.params);
            return recyclerViewItemDecoration;
        }

        public Builder color(@ColorInt int color) {
            this.params.color = color;
            return this;
        }

        public Builder color(String color) {
            if (RVItemDecorationUtil.isColorStringWithoutAlpha(color)) {
                this.params.color = Color.parseColor((String)color);
            }
            return this;
        }

        public Builder horizontalSpacing(int spacing) {
            if (spacing < 0) {
                spacing = 0;
            }
            if (spacing % 2 != 0) {
                ++spacing;
            }
            this.params.horizontalSpacing = spacing;
            return this;
        }

        public Builder verticalSpacing(int spacing) {
            if (spacing < 0) {
                spacing = 0;
            }
            if (spacing % 2 != 0) {
                ++spacing;
            }
            this.params.verticalSpacing = spacing;
            return this;
        }

        public Builder borderVisible(boolean borderVisible) {
            this.params.borderVisible = borderVisible;
            return this;
        }
    }
}

