/*
 * Decompiled with CFR 0.152.
 */
package com.arlib.floatingsearchview.util.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;

public class SearchInputView
extends EditText {
    private OnKeyboardSearchKeyClickListener mSearchKeyListener;
    private OnKeyboardDismissedListener mOnKeyboardDismissedListener;
    private View.OnKeyListener mOnKeyListener = new View.OnKeyListener(){

        public boolean onKey(View view, int keyCode, KeyEvent keyEvent) {
            if (keyCode == 66 && SearchInputView.this.mSearchKeyListener != null) {
                SearchInputView.this.mSearchKeyListener.onSearchKeyClicked();
                return true;
            }
            return false;
        }
    };

    public SearchInputView(Context context) {
        super(context);
        this.init();
    }

    public SearchInputView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SearchInputView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.setOnKeyListener(this.mOnKeyListener);
    }

    public boolean onKeyPreIme(int keyCode, KeyEvent ev) {
        if (ev.getKeyCode() == 4 && this.mOnKeyboardDismissedListener != null) {
            this.mOnKeyboardDismissedListener.onKeyboardDismissed();
        }
        return super.onKeyPreIme(keyCode, ev);
    }

    public void setOnKeyboardDismissedListener(OnKeyboardDismissedListener onKeyboardDismissedListener) {
        this.mOnKeyboardDismissedListener = onKeyboardDismissedListener;
    }

    public void setOnSearchKeyListener(OnKeyboardSearchKeyClickListener searchKeyListener) {
        this.mSearchKeyListener = searchKeyListener;
    }

    public static interface OnKeyboardSearchKeyClickListener {
        public void onSearchKeyClicked();
    }

    public static interface OnKeyboardDismissedListener {
        public void onKeyboardDismissed();
    }
}

