/*
 * Decompiled with CFR 0.152.
 */
package com.arlib.floatingsearchview.suggestions;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.arlib.floatingsearchview.R;
import com.arlib.floatingsearchview.suggestions.model.SearchSuggestion;
import com.arlib.floatingsearchview.util.Util;
import com.arlib.floatingsearchview.util.view.BodyTextView;
import com.arlib.floatingsearchview.util.view.IconImageView;
import java.util.ArrayList;
import java.util.List;

public class SearchSuggestionsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = "";
    private List<SearchSuggestion> mSearchSuggestions;
    private Listener mListener;
    private Context mContext;
    private SearchSuggestion mSelectedItem;
    private Drawable mRightIconDrawable;
    private int mBodyTextSizePx;
    private int mTextColor = -1;
    private int mRightIconColor = -1;
    private OnBindSuggestionCallback mOnBindSuggestionCallback;

    public void setOnBindSuggestionCallback(OnBindSuggestionCallback callback) {
        this.mOnBindSuggestionCallback = callback;
    }

    public void setTextColor(int color2) {
        boolean notify = false;
        if (this.mTextColor != color2) {
            notify = true;
        }
        this.mTextColor = color2;
        if (notify) {
            this.notifyDataSetChanged();
        }
    }

    public void setRightIconColor(int color2) {
        boolean notify = false;
        if (this.mRightIconColor != color2) {
            notify = true;
        }
        this.mRightIconColor = color2;
        if (notify) {
            this.notifyDataSetChanged();
        }
    }

    public SearchSuggestionsAdapter(Context context, int suggestionTextSize, Listener listener) {
        this.mContext = context;
        this.mListener = listener;
        this.mBodyTextSizePx = suggestionTextSize;
        this.mSearchSuggestions = new ArrayList<SearchSuggestion>();
        this.mRightIconDrawable = this.mContext.getResources().getDrawable(R.drawable.ic_arrow_back_black_24dp);
        this.mRightIconDrawable = DrawableCompat.wrap((Drawable)this.mRightIconDrawable);
        DrawableCompat.setTint((Drawable)this.mRightIconDrawable, (int)this.mContext.getResources().getColor(R.color.gray_active_icon));
    }

    public List<? extends SearchSuggestion> getDataSet() {
        return this.mSearchSuggestions;
    }

    public void swapData(List<? extends SearchSuggestion> searchSuggestions) {
        this.mSearchSuggestions.clear();
        this.mSearchSuggestions.addAll(searchSuggestions);
        this.notifyDataSetChanged();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.search_suggestion_item, viewGroup, false);
        SearchSuggestionViewHolder viewHolder = new SearchSuggestionViewHolder(view, new SearchSuggestionViewHolder.Listener(){

            @Override
            public void onItemClicked(int adapterPosition) {
                if (SearchSuggestionsAdapter.this.mListener != null) {
                    SearchSuggestionsAdapter.this.mListener.onItemSelected((SearchSuggestion)SearchSuggestionsAdapter.this.mSearchSuggestions.get(adapterPosition));
                }
            }

            @Override
            public void onMoveItemToSearchClicked(int adapterPosition) {
                if (SearchSuggestionsAdapter.this.mListener != null) {
                    SearchSuggestionsAdapter.this.mListener.onMoveItemToSearchClicked((SearchSuggestion)SearchSuggestionsAdapter.this.mSearchSuggestions.get(adapterPosition));
                }
            }
        });
        viewHolder.rightIcon.setImageDrawable(this.mRightIconDrawable);
        viewHolder.body.setTextSize(0, this.mBodyTextSizePx);
        return viewHolder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder vh, int position) {
        SearchSuggestion item = this.mSearchSuggestions.get(position);
        SearchSuggestionViewHolder viewHolder = (SearchSuggestionViewHolder)vh;
        this.resetImageView(viewHolder.leftIcon);
        viewHolder.body.setText(item.getBody());
        viewHolder.leftIcon.setImageDrawable(null);
        if (this.mTextColor != -1) {
            viewHolder.body.setTextColor(this.mTextColor);
        }
        if (this.mRightIconColor != -1) {
            Util.setIconColor(viewHolder.rightIcon.getDrawable(), this.mRightIconColor);
        }
        if (this.mOnBindSuggestionCallback != null) {
            viewHolder.body.lock();
            viewHolder.leftIcon.lock();
            this.mOnBindSuggestionCallback.onBindSuggestion(viewHolder.leftIcon, viewHolder.body, item, position);
            viewHolder.body.unlock();
            viewHolder.leftIcon.unlock();
        }
    }

    public int getItemCount() {
        return this.mSearchSuggestions != null ? this.mSearchSuggestions.size() : 0;
    }

    public void clearDataSet() {
        int rage = this.mSearchSuggestions.size();
        this.mSearchSuggestions.clear();
        this.notifyItemRangeRemoved(0, rage);
    }

    private void resetImageView(ImageView imageView) {
        imageView.setImageDrawable(null);
        imageView.setAlpha(1.0f);
    }

    public static class SearchSuggestionViewHolder
    extends RecyclerView.ViewHolder {
        private static final String TAG = "";
        public BodyTextView body;
        public IconImageView leftIcon;
        public IconImageView rightIcon;
        private Listener mListener;

        public SearchSuggestionViewHolder(View v, Listener listener) {
            super(v);
            this.mListener = listener;
            this.body = (BodyTextView)v.findViewById(R.id.body);
            this.leftIcon = (IconImageView)v.findViewById(R.id.left_icon);
            this.rightIcon = (IconImageView)v.findViewById(R.id.right_icon);
            this.rightIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (SearchSuggestionViewHolder.this.mListener != null) {
                        SearchSuggestionViewHolder.this.mListener.onMoveItemToSearchClicked(SearchSuggestionViewHolder.this.getAdapterPosition());
                    }
                }
            });
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (SearchSuggestionViewHolder.this.mListener != null) {
                        SearchSuggestionViewHolder.this.mListener.onItemClicked(SearchSuggestionViewHolder.this.getAdapterPosition());
                    }
                }
            });
        }

        public static interface Listener {
            public void onItemClicked(int var1);

            public void onMoveItemToSearchClicked(int var1);
        }
    }

    public static interface Listener {
        public void onItemSelected(SearchSuggestion var1);

        public void onMoveItemToSearchClicked(SearchSuggestion var1);
    }

    public static interface OnBindSuggestionCallback {
        public void onBindSuggestion(IconImageView var1, BodyTextView var2, SearchSuggestion var3, int var4);
    }
}

