/*
 * Decompiled with CFR 0.152.
 */
package com.arlib.floatingsearchview;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.support.v7.graphics.drawable.DrawerArrowDrawable;
import android.support.v7.view.SupportMenuInflater;
import android.support.v7.view.ViewPropertyAnimatorCompatSet;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.arlib.floatingsearchview.R;
import com.arlib.floatingsearchview.suggestions.SearchSuggestionsAdapter;
import com.arlib.floatingsearchview.suggestions.model.SearchSuggestion;
import com.arlib.floatingsearchview.util.MenuPopupHelper;
import com.arlib.floatingsearchview.util.Util;
import com.arlib.floatingsearchview.util.adapter.GestureDetectorListenerAdapter;
import com.arlib.floatingsearchview.util.adapter.OnItemTouchListenerAdapter;
import com.arlib.floatingsearchview.util.adapter.TextWatcherAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FloatingSearchView
extends FrameLayout {
    private static final String TAG = "FloatingSearchView";
    private final int BACKGROUND_DRAWABLE_ALPHA_SEARCH_ACTIVE = 150;
    private final int BACKGROUND_DRAWABLE_ALPHA_SEARCH_INACTIVE = 0;
    private final int MENU_ICON_ANIM_DURATION = 250;
    private final int BACKGROUND_FADE__ANIM_DURATION = 250;
    private final int ATTRS_SEARCH_BAR_MARGIN_DEFAULT = 0;
    private final boolean ATTRS_SEARCH_BAR_SHOW_MENU_ACTION_DEFAULT = true;
    private final boolean ATTRS_DISMISS_ON_OUTSIDE_TOUCH_DEFAULT = false;
    private final boolean ATTRS_SEARCH_BAR_SHOW_VOICE_ACTION_DEFAULT = false;
    private final boolean ATTRS_SEARCH_BAR_SHOW_SEARCH_KEY_DEFAULT = true;
    private final boolean ATTRS_SEARCH_BAR_SHOW_SEARCH_HINT_NOT_FOCUSED_DEFAULT = true;
    private final boolean ATTRS_HIDE_OVERFLOW_MENU_FOCUSED_DEFAULT = true;
    private final boolean ATTRS_SHOW_OVERFLOW_MENU_DEFAULT = true;
    private final int ATTRS_SUGGESTION_TEXT_SIZE_SP_DEFAULT = 18;
    private final int SUGGEST_LIST_COLLAPSE_ANIM_DURATION = 200;
    private final Interpolator SUGGEST_LIST_COLLAPSE_ANIM_INTERPOLATOR = new LinearInterpolator();
    private final int SUGGEST_ITEM_ADD_ANIM_DURATION = 250;
    private final Interpolator SUGGEST_ITEM_ADD_ANIM_INTERPOLATOR = new LinearInterpolator();
    private final int VOICE_REC_DEFAULT_REQUEST_CODE = 1024;
    private final int SUGGESTION_ITEM_ANIM_DURATION = 120;
    private final int OVERFLOW_ICON_WIDTH_DP = 36;
    private Activity mHostActivity;
    private Drawable mBackgroundDrawable;
    private boolean mDismissOnOutsideTouch = true;
    private View mQuerySection;
    private ImageView mVoiceInputOrClearButton;
    private EditText mSearchInput;
    private boolean mShowSearchKey;
    private boolean mIsFocused;
    private TextView mSearchBarTitle;
    private OnQueryChangeListener mQueryListener;
    private ProgressBar mSearchProgress;
    private ImageView mMenuSearchOrExitButton;
    private OnLeftMenuClickListener mOnMenuClickListener;
    private DrawerArrowDrawable mMenuBtnDrawable;
    private Drawable mIconClear;
    private Drawable mIconMic;
    private Drawable mIconOverflowMenu;
    private Drawable mIconBackArrow;
    private Drawable mIconSearch;
    private OnFocusChangeListener mFocusChangeListener;
    private boolean mShowMenuAction;
    private String mOldQuery = "";
    private OnSearchListener mSearchListener;
    private int mVoiceRecRequestCode = 1024;
    private String mVoiceRecHint;
    private boolean mShowVoiceInput;
    private boolean mShowHintNotFocused;
    private String mSearchHint;
    private boolean mMenuOpen = false;
    private boolean mIsActiveOnClick;
    private ImageView mOverflowMenu;
    private MenuBuilder mMenuBuilder;
    private MenuPopupHelper mMenuPopupHelper;
    private SupportMenuInflater mMenuInflater;
    private OnMenuItemClickListener mOnOverflowMenuItemListener;
    private boolean mHideOverflowMenuFocused;
    private boolean mShowOverFlowMenu;
    private boolean mSearchEnabled;
    private boolean mSkipQueryFocusChangeEvent;
    private boolean mSkipTextChangeEvent;
    private View mDivider;
    private RelativeLayout mSuggestionsSection;
    private View mSuggestionListContainer;
    private RecyclerView mSuggestionsList;
    private SearchSuggestionsAdapter mSuggestionsAdapter;
    private boolean mIsCollapsing = false;
    private int mSuggestionsTextSizePx;
    private boolean mIsInitialLayout = true;

    public FloatingSearchView(Context context) {
        this(context, null);
    }

    public FloatingSearchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.mHostActivity = this.getHostActivity();
        LayoutInflater layoutInflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        FloatingSearchView.inflate((Context)this.getContext(), (int)R.layout.floating_search_layout, (ViewGroup)this);
        this.mBackgroundDrawable = new ColorDrawable(-16777216);
        this.mQuerySection = this.findViewById(R.id.search_query_section);
        this.mVoiceInputOrClearButton = (ImageView)this.findViewById(R.id.search_bar_mic_or_ex);
        this.mSearchInput = (EditText)this.findViewById(R.id.search_bar_text);
        this.mSearchBarTitle = (TextView)this.findViewById(R.id.search_bar_title);
        this.mMenuSearchOrExitButton = (ImageView)this.findViewById(R.id.search_bar_exit);
        this.mSearchProgress = (ProgressBar)this.findViewById(R.id.search_bar_search_progress);
        this.mShowMenuAction = true;
        this.mOverflowMenu = (ImageView)this.findViewById(R.id.search_bar_overflow_menu);
        this.mMenuBuilder = new MenuBuilder(this.getContext());
        this.mMenuPopupHelper = new MenuPopupHelper(this.getContext(), this.mMenuBuilder, (View)this.mOverflowMenu);
        this.initDrawables();
        this.mVoiceInputOrClearButton.setImageDrawable(this.mIconMic);
        this.mOverflowMenu.setImageDrawable(this.mIconOverflowMenu);
        this.mDivider = this.findViewById(R.id.divider);
        this.mSuggestionsSection = (RelativeLayout)this.findViewById(R.id.search_suggestions_section);
        this.mSuggestionListContainer = this.findViewById(R.id.suggestions_list_container);
        this.mSuggestionsList = (RecyclerView)this.findViewById(R.id.suggestions_list);
        this.setupViews(attrs);
    }

    private void initDrawables() {
        this.mMenuBtnDrawable = new DrawerArrowDrawable(this.getContext());
        this.mIconClear = this.getResources().getDrawable(R.drawable.ic_clear_black_24dp);
        this.mIconClear = DrawableCompat.wrap((Drawable)this.mIconClear);
        this.mIconMic = this.getResources().getDrawable(R.drawable.ic_mic_black_24dp);
        this.mIconMic = DrawableCompat.wrap((Drawable)this.mIconMic);
        this.mIconOverflowMenu = this.getResources().getDrawable(R.drawable.ic_more_vert_black_24dp);
        this.mIconOverflowMenu = DrawableCompat.wrap((Drawable)this.mIconOverflowMenu);
        this.mIconBackArrow = this.getResources().getDrawable(R.drawable.ic_arrow_back_black_24dp);
        this.mIconBackArrow = DrawableCompat.wrap((Drawable)this.mIconBackArrow);
        this.mIconSearch = this.getResources().getDrawable(R.drawable.ic_search_black_24dp);
        this.mIconSearch = DrawableCompat.wrap((Drawable)this.mIconSearch);
        this.setIconsColor(this.getResources().getColor(R.color.gray_active_icon));
    }

    private void setIconsColor(int color2) {
        this.mMenuBtnDrawable.setColor(color2);
        DrawableCompat.setTint((Drawable)this.mIconClear, (int)color2);
        DrawableCompat.setTint((Drawable)this.mIconMic, (int)color2);
        DrawableCompat.setTint((Drawable)this.mIconOverflowMenu, (int)color2);
        DrawableCompat.setTint((Drawable)this.mIconBackArrow, (int)color2);
        DrawableCompat.setTint((Drawable)this.mIconSearch, (int)color2);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mIsInitialLayout) {
            int addedHeight = Util.dpToPx(15);
            this.mSuggestionsSection.getLayoutParams().height = this.mSuggestionsSection.getMeasuredHeight() + addedHeight;
            this.mIsInitialLayout = false;
        }
        this.adjustSearchInputPadding();
        super.onLayout(changed, l, t, r, b);
    }

    private void setupViews(AttributeSet attrs) {
        if (attrs != null) {
            this.applyXmlAttributes(attrs);
        }
        this.mBackgroundDrawable.setAlpha(0);
        int sdkVersion = Build.VERSION.SDK_INT;
        if (sdkVersion < 16) {
            this.setBackgroundDrawable(this.mBackgroundDrawable);
        } else {
            this.setBackground(this.mBackgroundDrawable);
        }
        this.setupQueryBar();
        if (!this.isInEditMode()) {
            this.setupSuggestionSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyXmlAttributes(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.FloatingSearchView);
        try {
            int searchBarWidth;
            this.setDismissOnOutsideClick(true);
            this.mQuerySection.getLayoutParams().width = searchBarWidth = a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchBarWidth, -1);
            this.mDivider.getLayoutParams().width = searchBarWidth;
            this.mSuggestionListContainer.getLayoutParams().width = searchBarWidth;
            int searchBarLeftMargin = a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchBarMarginLeft, 0);
            int searchBarTopMargin = a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchBarMarginTop, 0);
            int searchBarRightMargin = a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchBarMarginRight, 0);
            FrameLayout.LayoutParams querySectionLP = (FrameLayout.LayoutParams)this.mQuerySection.getLayoutParams();
            FrameLayout.LayoutParams dividerLP = (FrameLayout.LayoutParams)this.mDivider.getLayoutParams();
            LinearLayout.LayoutParams suggestListSectionLP = (LinearLayout.LayoutParams)this.mSuggestionsSection.getLayoutParams();
            querySectionLP.setMargins(searchBarLeftMargin, searchBarTopMargin, searchBarRightMargin, 0);
            dividerLP.setMargins(searchBarLeftMargin, 0, searchBarRightMargin, ((ViewGroup.MarginLayoutParams)this.mDivider.getLayoutParams()).bottomMargin);
            suggestListSectionLP.setMargins(searchBarLeftMargin, 0, searchBarRightMargin, 0);
            this.mQuerySection.setLayoutParams((ViewGroup.LayoutParams)querySectionLP);
            this.mDivider.setLayoutParams((ViewGroup.LayoutParams)dividerLP);
            this.mSuggestionsSection.setLayoutParams((ViewGroup.LayoutParams)suggestListSectionLP);
            this.setSearchHint(a.getString(R.styleable.FloatingSearchView_floatingSearch_searchHint));
            this.setShowHintWhenNotFocused(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_showSearchHintWhenNotFocused, true));
            this.setLeftShowMenu(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_showMenuAction, true));
            this.setShowVoiceInput(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_showVoiceInput, false));
            this.setShowSearchKey(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_showSearchKey, true));
            this.setVoiceSearchHint(a.getString(R.styleable.FloatingSearchView_floatingSearch_voiceRecHint));
            this.setDismissOnOutsideClick(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_dismissOnOutsideTouch, false));
            this.setShowOverflowMenu(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_showOverFlowMenu, true));
            this.setSuggestionItemTextSize(a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchSuggestionTextSize, Util.spToPx(18)));
            if (a.hasValue(R.styleable.FloatingSearchView_floatingSearch_menu)) {
                this.inflateOverflowMenu(a.getResourceId(R.styleable.FloatingSearchView_floatingSearch_menu, 0));
            }
            this.setHideOverflowMenuWhenFocused(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_hideOverflowMenuWhenFocused, true));
        }
        finally {
            a.recycle();
        }
    }

    private Activity getHostActivity() {
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    private void setupQueryBar() {
        if (!this.isInEditMode() && this.mHostActivity != null) {
            this.mHostActivity.getWindow().setSoftInputMode(32);
        }
        this.mOverflowMenu.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingSearchView.this.mMenuPopupHelper.show();
            }
        });
        this.mMenuBuilder.setCallback(new MenuBuilder.Callback(){

            public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
                if (FloatingSearchView.this.mOnOverflowMenuItemListener != null) {
                    FloatingSearchView.this.mOnOverflowMenuItemListener.onMenuItemSelected(item);
                }
                return false;
            }

            public void onMenuModeChange(MenuBuilder menu) {
            }
        });
        this.mVoiceInputOrClearButton.setVisibility(this.mShowVoiceInput ? 0 : 4);
        this.mVoiceInputOrClearButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FloatingSearchView.this.mSearchInput.getText().length() == 0) {
                    FloatingSearchView.this.startVoiceInput();
                } else {
                    FloatingSearchView.this.mSearchInput.setText((CharSequence)"");
                }
            }
        });
        this.mSearchBarTitle.setVisibility(8);
        this.mSearchBarTitle.setTextColor(this.getResources().getColor(R.color.gray_active_icon));
        this.mSearchInput.addTextChangedListener((TextWatcher)new TextWatcherAdapter(){

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (FloatingSearchView.this.mSkipTextChangeEvent) {
                    FloatingSearchView.this.mSkipTextChangeEvent = false;
                } else {
                    if (FloatingSearchView.this.mSearchInput.getText().length() == 0) {
                        if (FloatingSearchView.this.mShowVoiceInput) {
                            FloatingSearchView.this.changeIcon(FloatingSearchView.this.mVoiceInputOrClearButton, FloatingSearchView.this.mIconMic, true);
                        } else {
                            FloatingSearchView.this.mVoiceInputOrClearButton.setVisibility(4);
                        }
                    } else if (FloatingSearchView.this.mOldQuery.length() == 0) {
                        FloatingSearchView.this.changeIcon(FloatingSearchView.this.mVoiceInputOrClearButton, FloatingSearchView.this.mIconClear, true);
                        FloatingSearchView.this.mVoiceInputOrClearButton.setVisibility(0);
                    }
                    if (FloatingSearchView.this.mQueryListener != null && FloatingSearchView.this.mIsFocused) {
                        FloatingSearchView.this.mQueryListener.onSearchTextChanged(FloatingSearchView.this.mOldQuery, FloatingSearchView.this.mSearchInput.getText().toString());
                    }
                    FloatingSearchView.this.mOldQuery = FloatingSearchView.this.mSearchInput.getText().toString();
                }
            }
        });
        this.mSearchInput.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (FloatingSearchView.this.mSkipQueryFocusChangeEvent) {
                    FloatingSearchView.this.mSkipQueryFocusChangeEvent = false;
                } else if (hasFocus != FloatingSearchView.this.mIsFocused) {
                    FloatingSearchView.this.setSearchFocused(hasFocus);
                }
            }
        });
        this.mSearchInput.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int keyCode, KeyEvent keyEvent) {
                if (FloatingSearchView.this.mShowSearchKey && keyCode == 66) {
                    FloatingSearchView.this.setSearchFocused(false);
                    if (FloatingSearchView.this.mSearchListener != null) {
                        FloatingSearchView.this.mSearchListener.onSearchAction();
                    }
                    return true;
                }
                return false;
            }
        });
        this.refreshLeftIcon();
        this.mMenuSearchOrExitButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FloatingSearchView.this.mSearchInput.isFocused()) {
                    FloatingSearchView.this.setSearchFocused(false);
                } else if (FloatingSearchView.this.mShowMenuAction) {
                    FloatingSearchView.this.toggleMenu();
                } else {
                    FloatingSearchView.this.setSearchFocused(true);
                }
            }
        });
    }

    private void refreshLeftIcon() {
        if (this.mShowMenuAction) {
            this.mMenuSearchOrExitButton.setImageDrawable((Drawable)this.mMenuBtnDrawable);
        } else {
            this.mMenuSearchOrExitButton.setImageDrawable(this.mIconSearch);
        }
    }

    public void setLeftMenuIconColor(int color2) {
        this.mMenuBtnDrawable.setColor(color2);
    }

    public void setSearchEnabled(boolean enabled) {
        if (enabled) {
            this.showSearchDependentActions();
        } else {
            this.hideSearchDependentActions();
        }
        this.mSearchEnabled = enabled;
        this.mSearchInput.setEnabled(enabled);
    }

    private void showSearchDependentActions() {
        ViewCompat.animate((View)this.mSearchBarTitle).alpha(0.0f).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationStart(View view) {
                FloatingSearchView.this.mSearchBarTitle.setVisibility(4);
            }
        }).start();
        ViewCompat.animate((View)this.mSearchInput).alpha(1.0f).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationStart(View view) {
                FloatingSearchView.this.mSearchInput.setVisibility(0);
            }
        }).start();
        ViewCompat.animate((View)this.mVoiceInputOrClearButton).alpha(1.0f).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationEnd(View view) {
                FloatingSearchView.this.mVoiceInputOrClearButton.setVisibility(0);
            }
        }).start();
    }

    private void hideSearchDependentActions() {
        ViewCompat.animate((View)this.mSearchBarTitle).alpha(1.0f).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationStart(View view) {
                FloatingSearchView.this.mSearchBarTitle.setVisibility(0);
            }
        }).start();
        ViewCompat.animate((View)this.mSearchInput).alpha(0.0f).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationStart(View view) {
                FloatingSearchView.this.mSearchInput.setVisibility(4);
            }
        }).start();
        ViewCompat.animate((View)this.mVoiceInputOrClearButton).alpha(0.0f).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationEnd(View view) {
                FloatingSearchView.this.mVoiceInputOrClearButton.setVisibility(4);
            }
        }).start();
    }

    private void adjustSearchInputPadding() {
        int newPaddingEnd = 0;
        newPaddingEnd += this.mVoiceInputOrClearButton.getWidth();
        if (!(!this.mShowOverFlowMenu || this.mHideOverflowMenuFocused && this.mSearchInput.isFocused())) {
            newPaddingEnd += this.mOverflowMenu.getWidth();
        }
        this.mSearchInput.setPadding(0, 0, newPaddingEnd, 0);
        this.mSearchBarTitle.setPadding(0, 0, newPaddingEnd, 0);
    }

    public void openMenu(boolean withAnim) {
        this.openMenu(true, withAnim, false);
    }

    public void closeMenu(boolean withAnim) {
        this.closeMenu(true, withAnim, false);
    }

    public void setLeftShowMenu(boolean show) {
        this.mShowMenuAction = show;
        this.refreshLeftIcon();
    }

    public void setHideOverflowMenuWhenFocused(boolean hide) {
        this.mHideOverflowMenuFocused = hide;
    }

    public void setShowOverflowMenu(boolean show) {
        this.mShowOverFlowMenu = show;
        if (this.mShowVoiceInput) {
            if (show) {
                this.showOverflowMenuWithAnim(false);
            } else {
                this.hideOverflowMenu(false);
            }
        }
    }

    private void showOverflowMenuWithAnim(boolean withAnim) {
        this.mOverflowMenu.setClickable(true);
        if (withAnim) {
            ViewPropertyAnimatorCompatSet hidAnimSet = new ViewPropertyAnimatorCompatSet();
            hidAnimSet.playSequentially(ViewCompat.animate((View)this.mVoiceInputOrClearButton).translationX(0.0f), ViewCompat.animate((View)this.mOverflowMenu).alpha(1.0f)).setDuration(150L).start();
        } else {
            this.mOverflowMenu.setAlpha(1.0f);
            this.mVoiceInputOrClearButton.setTranslationX(0.0f);
        }
    }

    private void hideOverflowMenu(boolean withAnim) {
        int deltaX;
        this.mOverflowMenu.setClickable(false);
        int n = deltaX = this.isRTL() ? -Util.dpToPx(36) : Util.dpToPx(36);
        if (withAnim) {
            ViewPropertyAnimatorCompatSet hidAnimSet = new ViewPropertyAnimatorCompatSet();
            hidAnimSet.playSequentially(ViewCompat.animate((View)this.mOverflowMenu).alpha(0.0f), ViewCompat.animate((View)this.mVoiceInputOrClearButton).translationXBy((float)deltaX)).setDuration(150L).start();
        } else {
            this.mOverflowMenu.setAlpha(0.0f);
            this.mVoiceInputOrClearButton.setTranslationX((float)deltaX);
        }
    }

    public void inflateOverflowMenu(int menuId) {
        this.mMenuBuilder.clearAll();
        this.getMenuInflater().inflate(menuId, (Menu)this.mMenuBuilder);
    }

    private MenuInflater getMenuInflater() {
        if (this.mMenuInflater == null) {
            this.mMenuInflater = new SupportMenuInflater(this.getContext());
        }
        return this.mMenuInflater;
    }

    private void toggleMenu() {
        if (this.mMenuOpen) {
            this.closeMenu(true, true, true);
        } else {
            this.openMenu(true, true, true);
        }
    }

    private void openMenu(boolean changeMenuIcon, boolean withAnim, boolean notifyListener) {
        if (this.mOnMenuClickListener != null && notifyListener) {
            this.mOnMenuClickListener.onMenuOpened();
        }
        this.mMenuOpen = true;
        if (changeMenuIcon) {
            this.openMenuDrawable(this.mMenuBtnDrawable, withAnim);
        }
    }

    private void closeMenu(boolean changeMenuIcon, boolean withAnim, boolean notifyListener) {
        if (this.mOnMenuClickListener != null && notifyListener) {
            this.mOnMenuClickListener.onMenuClosed();
        }
        this.mMenuOpen = false;
        if (changeMenuIcon) {
            this.closeMenuDrawable(this.mMenuBtnDrawable, withAnim);
        }
    }

    public void setMenuIconProgress(float progress) {
        this.mMenuBtnDrawable.setProgress(progress);
        if (progress == 0.0f) {
            this.closeMenu(false, true, true);
        } else if ((double)progress == 1.0) {
            this.openMenu(false);
        }
    }

    public void setSearchHint(String searchHint) {
        String string2 = this.mSearchHint = searchHint != null ? searchHint : this.getResources().getString(R.string.abc_search_hint);
        if (this.mShowHintNotFocused || this.mSearchInput.isFocused()) {
            this.mSearchInput.setHint((CharSequence)this.mSearchHint);
        } else {
            this.mSearchInput.setHint((CharSequence)"");
        }
    }

    public void setShowHintWhenNotFocused(boolean show) {
        this.mShowHintNotFocused = show;
        if (this.mShowHintNotFocused) {
            this.mSearchInput.setHint((CharSequence)this.mSearchHint);
        }
    }

    public void setSearchBarTitle(CharSequence title) {
        this.mSearchBarTitle.setText(title);
    }

    public void setShowVoiceInput(boolean show) {
        this.mShowVoiceInput = show;
        this.mVoiceInputOrClearButton.setVisibility(this.mShowVoiceInput ? 0 : 8);
    }

    public void setVoiceRecRequestCode(int requestCode) {
        this.mVoiceRecRequestCode = requestCode;
    }

    private void startVoiceInput() {
        Intent voiceIntent = this.createVoiceRecIntent(this.mHostActivity, this.mVoiceRecHint);
        if (this.mHostActivity != null) {
            try {
                this.mHostActivity.startActivityForResult(voiceIntent, this.mVoiceRecRequestCode);
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                // empty catch block
            }
        }
    }

    private Intent createVoiceRecIntent(Activity activity, String hint) {
        Intent intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        intent.putExtra("android.speech.extra.PROMPT", hint);
        intent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
        intent.putExtra("android.speech.extra.MAX_RESULTS", 1);
        return intent;
    }

    public void setVoiceSearchHint(String hint) {
        this.mVoiceRecHint = hint != null ? hint : this.getResources().getString(R.string.abc_search_hint);
    }

    public void onHostActivityResult(int requestCode, int resultCode, Intent data) {
        ArrayList matches;
        if (requestCode == this.mVoiceRecRequestCode && resultCode == -1 && !(matches = data.getStringArrayListExtra("android.speech.extra.RESULTS")).isEmpty()) {
            String newQuery = (String)matches.get(0);
            this.mSearchInput.requestFocus();
            this.mSearchInput.setText((CharSequence)newQuery);
            this.mSearchInput.setSelection(this.mSearchInput.getText().length());
        }
    }

    public void setShowSearchKey(boolean show) {
        this.mShowSearchKey = show;
        if (show) {
            this.mSearchInput.setImeOptions(3);
        } else {
            this.mSearchInput.setImeOptions(1);
        }
    }

    public String getQuery() {
        return this.mSearchInput.getText().toString();
    }

    public void showProgress() {
        this.mMenuSearchOrExitButton.setVisibility(8);
        this.mSearchProgress.setVisibility(0);
        new ObjectAnimator();
        ObjectAnimator fadeInProgress = ObjectAnimator.ofFloat((Object)this.mSearchProgress, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        fadeInProgress.start();
    }

    public void hideProgress() {
        this.mMenuSearchOrExitButton.setVisibility(0);
        this.mSearchProgress.setVisibility(8);
        new ObjectAnimator();
        ObjectAnimator fadeInExit = ObjectAnimator.ofFloat((Object)this.mMenuSearchOrExitButton, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        fadeInExit.start();
    }

    private void setSuggestionItemTextSize(int sizePx) {
        this.mSuggestionsTextSizePx = sizePx;
    }

    private void setupSuggestionSection() {
        boolean showItemsFromBottom = true;
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext(), 1, showItemsFromBottom);
        this.mSuggestionsList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mSuggestionsList.setItemAnimator(null);
        final GestureDetector gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetectorListenerAdapter(){

            @Override
            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (FloatingSearchView.this.mHostActivity != null) {
                    Util.closeSoftKeyboard(FloatingSearchView.this.mHostActivity);
                }
                return false;
            }
        });
        this.mSuggestionsList.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new OnItemTouchListenerAdapter(){

            @Override
            public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
                gestureDetector.onTouchEvent(e);
                return false;
            }
        });
        this.mSuggestionsAdapter = new SearchSuggestionsAdapter(this.getContext(), this.mSuggestionsTextSizePx, new SearchSuggestionsAdapter.Listener(){

            @Override
            public void onItemSelected(SearchSuggestion item) {
                FloatingSearchView.this.setSearchFocused(false);
                if (FloatingSearchView.this.mSearchListener != null) {
                    FloatingSearchView.this.mSearchListener.onSuggestionClicked(item);
                }
            }

            @Override
            public void onMoveItemToSearchClicked(SearchSuggestion item) {
                FloatingSearchView.this.mSearchInput.setText((CharSequence)item.getBody());
                FloatingSearchView.this.mSearchInput.setSelection(FloatingSearchView.this.mSearchInput.getText().length());
            }
        });
        this.mSuggestionsList.setAdapter((RecyclerView.Adapter)this.mSuggestionsAdapter);
        int cardViewBottomPadding = Util.dpToPx(5);
        this.mSuggestionsSection.setTranslationY((float)(-cardViewBottomPadding));
    }

    private void moveSuggestListToInitialPos() {
        this.mSuggestionListContainer.setTranslationY((float)(-this.mSuggestionListContainer.getMeasuredHeight()));
    }

    public void swapSuggestions(List<? extends SearchSuggestion> newSearchSuggestions) {
        Collections.reverse(newSearchSuggestions);
        this.swapSuggestions(newSearchSuggestions, true);
    }

    private void swapSuggestions(List<? extends SearchSuggestion> newSearchSuggestions, boolean withAnim) {
        float newTranslationY;
        this.mDivider.setVisibility(8);
        this.mSuggestionsAdapter.swapData(newSearchSuggestions);
        this.mSuggestionsList.scrollBy(0, -(newSearchSuggestions.size() * this.getTotalItemsHeight(newSearchSuggestions)));
        int fiveDp = Util.dpToPx(6);
        int threeDp = Util.dpToPx(3);
        ViewCompat.animate((View)this.mSuggestionListContainer).cancel();
        float translationY = -this.mSuggestionListContainer.getHeight() + this.getVisibleItemsHeight(newSearchSuggestions);
        float f = translationY < 0.0f ? (newSearchSuggestions.size() == 0 ? translationY : translationY + (float)threeDp) : (newTranslationY = (float)(-fiveDp));
        if (withAnim) {
            ViewCompat.animate((View)this.mSuggestionListContainer).setStartDelay(120L).setInterpolator(this.SUGGEST_ITEM_ADD_ANIM_INTERPOLATOR).setDuration(250L).translationY(newTranslationY).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                public void onAnimationCancel(View view) {
                    FloatingSearchView.this.mSuggestionListContainer.setTranslationY(newTranslationY);
                }
            }).start();
        } else {
            float transY = translationY < 0.0f ? (newSearchSuggestions.size() == 0 ? translationY : translationY + (float)threeDp - (float)(3 * fiveDp)) : (float)(-fiveDp);
            this.mSuggestionListContainer.setTranslationY(transY);
        }
        if (newSearchSuggestions.size() > 0) {
            this.mDivider.setVisibility(0);
        } else {
            this.mDivider.setVisibility(8);
        }
    }

    private int getVisibleItemsHeight(List<? extends SearchSuggestion> suggestions) {
        int visibleItemsHeight = 0;
        for (SearchSuggestion searchSuggestion : suggestions) {
            if ((visibleItemsHeight += this.getSuggestionItemHeight(searchSuggestion)) > this.mSuggestionListContainer.getHeight()) break;
        }
        return visibleItemsHeight;
    }

    private int getTotalItemsHeight(List<? extends SearchSuggestion> suggestions) {
        int totalItemHeight = 0;
        for (SearchSuggestion searchSuggestion : suggestions) {
            totalItemHeight += this.getSuggestionItemHeight(searchSuggestion);
        }
        return totalItemHeight;
    }

    private int getSuggestionItemHeight(SearchSuggestion suggestion) {
        int leftRightMarginsWidth = Util.dpToPx(124);
        TextView textView = new TextView(this.getContext());
        textView.setTypeface(Typeface.DEFAULT);
        textView.setText((CharSequence)suggestion.getBody(), TextView.BufferType.SPANNABLE);
        textView.setTextSize(0, (float)this.mSuggestionsTextSizePx);
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.mSuggestionsList.getWidth() - leftRightMarginsWidth), (int)Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        textView.measure(widthMeasureSpec, heightMeasureSpec);
        int heightPlusPadding = textView.getMeasuredHeight() + Util.dpToPx(8);
        int minHeight = Util.dpToPx(48);
        int height = heightPlusPadding >= minHeight ? heightPlusPadding : minHeight;
        return heightPlusPadding >= minHeight ? heightPlusPadding : minHeight;
    }

    public void clearSuggestions() {
        this.clearSuggestions(null);
    }

    private void clearSuggestions(final OnSuggestionsClearListener listener) {
        if (!this.mIsCollapsing) {
            this.collapseSuggestionsSection(new OnSuggestionsCollapsedListener(){

                @Override
                public void onCollapsed() {
                    FloatingSearchView.this.mSuggestionsAdapter.clearDataSet();
                    if (listener != null) {
                        listener.onCleared();
                    }
                    FloatingSearchView.this.mDivider.setVisibility(8);
                }
            });
        }
    }

    private void collapseSuggestionsSection(final OnSuggestionsCollapsedListener listener) {
        this.mIsCollapsing = true;
        final int destTranslationY = -(this.mSuggestionListContainer.getHeight() + Util.dpToPx(3));
        ViewCompat.animate((View)this.mSuggestionListContainer).translationY((float)destTranslationY).setDuration(200L).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationEnd(View view) {
                if (listener != null) {
                    listener.onCollapsed();
                }
                FloatingSearchView.this.mIsCollapsing = false;
            }

            public void onAnimationCancel(View view) {
                FloatingSearchView.this.mSuggestionListContainer.setTranslationY((float)destTranslationY);
            }
        }).start();
    }

    public void clearSearchFocus() {
        this.setSearchFocused(false);
    }

    public boolean isSearchBarFocused() {
        return this.mIsFocused;
    }

    private void setSearchFocused(boolean focused) {
        this.mIsFocused = focused;
        if (focused) {
            if (this.mShowMenuAction && !this.mMenuOpen) {
                this.openMenuDrawable(this.mMenuBtnDrawable, true);
            } else if (!this.mShowMenuAction) {
                this.changeIcon(this.mMenuSearchOrExitButton, this.mIconBackArrow, true);
            }
            if (this.mMenuOpen) {
                this.closeMenu(false, true, true);
            }
            this.moveSuggestListToInitialPos();
            this.mSuggestionsSection.setVisibility(0);
            this.fadeInBackground();
            this.mSearchInput.requestFocus();
            if (this.mShowOverFlowMenu && this.mHideOverflowMenuFocused) {
                this.hideOverflowMenu(true);
            }
            this.adjustSearchInputPadding();
            Util.showSoftKeyboard(this.getContext(), this.mSearchInput);
            if (this.mFocusChangeListener != null) {
                this.mFocusChangeListener.onFocus();
            }
        } else {
            if (this.mShowMenuAction) {
                this.closeMenuDrawable(this.mMenuBtnDrawable, true);
            } else {
                this.changeIcon(this.mMenuSearchOrExitButton, this.mIconSearch, true);
            }
            this.clearSuggestions(new OnSuggestionsClearListener(){

                @Override
                public void onCleared() {
                    FloatingSearchView.this.mSuggestionsSection.setVisibility(4);
                }
            });
            this.fadeOutBackground();
            this.findViewById(R.id.search_bar).requestFocus();
            if (this.mHostActivity != null) {
                Util.closeSoftKeyboard(this.mHostActivity);
            }
            if (this.mShowVoiceInput && !this.mHideOverflowMenuFocused) {
                this.changeIcon(this.mVoiceInputOrClearButton, this.mIconMic, true);
            }
            if (this.mSearchInput.length() != 0) {
                this.mSearchInput.setText((CharSequence)"");
            }
            if (this.mShowOverFlowMenu && this.mHideOverflowMenuFocused) {
                this.showOverflowMenuWithAnim(true);
            }
            this.adjustSearchInputPadding();
            if (this.mFocusChangeListener != null) {
                this.mFocusChangeListener.onFocusCleared();
            }
        }
    }

    private void changeIcon(ImageView imageView, Drawable newIcon, boolean withAnim) {
        imageView.setImageDrawable(newIcon);
        if (withAnim) {
            new ObjectAnimator();
            ObjectAnimator fadeInVoiceInputOrClear = ObjectAnimator.ofFloat((Object)imageView, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            fadeInVoiceInputOrClear.start();
        } else {
            imageView.setAlpha(1.0f);
        }
    }

    public void setOnQueryChangeListener(OnQueryChangeListener listener) {
        this.mQueryListener = listener;
    }

    public void setOnSearchListener(OnSearchListener listener) {
        this.mSearchListener = listener;
    }

    public void setOnFocusChangeListener(OnFocusChangeListener listener) {
        this.mFocusChangeListener = listener;
    }

    public void setOnLeftMenuClickListener(OnLeftMenuClickListener listener) {
        this.mOnMenuClickListener = listener;
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener listener) {
        this.mOnOverflowMenuItemListener = listener;
    }

    private void openMenuDrawable(final DrawerArrowDrawable drawerArrowDrawable, boolean withAnim) {
        if (withAnim) {
            ValueAnimator anim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    drawerArrowDrawable.setProgress(value);
                }
            });
            anim.setDuration(250L);
            anim.start();
        } else {
            drawerArrowDrawable.setProgress(1.0f);
        }
    }

    private void closeMenuDrawable(final DrawerArrowDrawable drawerArrowDrawable, boolean withAnim) {
        if (withAnim) {
            ValueAnimator anim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    drawerArrowDrawable.setProgress(value);
                }
            });
            anim.setDuration(250L);
            anim.start();
        } else {
            drawerArrowDrawable.setProgress(0.0f);
        }
    }

    private void fadeOutBackground() {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{150, 0});
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                FloatingSearchView.this.mBackgroundDrawable.setAlpha(value);
            }
        });
        anim.setDuration(250L);
        anim.start();
    }

    private void fadeInBackground() {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{0, 150});
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                FloatingSearchView.this.mBackgroundDrawable.setAlpha(value);
            }
        });
        anim.setDuration(250L);
        anim.start();
    }

    public void setDismissOnOutsideClick(boolean enable) {
        this.mDismissOnOutsideTouch = enable;
        this.mSuggestionsSection.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (FloatingSearchView.this.mDismissOnOutsideTouch && FloatingSearchView.this.mIsFocused) {
                    FloatingSearchView.this.setSearchFocused(false);
                }
                return true;
            }
        });
    }

    private boolean isRTL() {
        Configuration config = this.getResources().getConfiguration();
        return ViewCompat.getLayoutDirection((View)this) == 1;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mIsFocused, this.mSuggestionsAdapter.getDataSet(), this.getQuery());
    }

    public void onRestoreInstanceState(Parcelable state) {
        final SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.isFocused) {
            this.mBackgroundDrawable.setAlpha(150);
            this.mSkipTextChangeEvent = savedState.isFocused;
            this.mSkipQueryFocusChangeEvent = savedState.isFocused;
            this.mIsFocused = savedState.isFocused;
            this.mSuggestionsSection.setVisibility(0);
            ViewTreeObserver vto = this.mSuggestionListContainer.getViewTreeObserver();
            vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT < 16) {
                        FloatingSearchView.this.mSuggestionListContainer.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        FloatingSearchView.this.mSuggestionListContainer.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    FloatingSearchView.this.swapSuggestions(savedState.suggestions, false);
                }
            });
            if (savedState.mQuery.length() == 0) {
                if (this.mShowVoiceInput) {
                    this.changeIcon(this.mVoiceInputOrClearButton, this.mIconMic, false);
                } else {
                    this.mVoiceInputOrClearButton.setVisibility(4);
                }
            } else if (this.mOldQuery.length() == 0) {
                this.changeIcon(this.mVoiceInputOrClearButton, this.mIconClear, false);
                this.mVoiceInputOrClearButton.setVisibility(0);
            }
            if (this.mShowOverFlowMenu && this.mHideOverflowMenuFocused) {
                this.hideOverflowMenu(false);
            }
            if (this.mShowMenuAction && !this.mMenuOpen) {
                this.openMenuDrawable(this.mMenuBtnDrawable, false);
            } else if (!this.mShowMenuAction) {
                this.changeIcon(this.mMenuSearchOrExitButton, this.mIconBackArrow, false);
            }
            this.adjustSearchInputPadding();
            Util.showSoftKeyboard(this.getContext(), this.mSearchInput);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ViewCompat.animate((View)this.mSuggestionListContainer).cancel();
    }

    static class SavedState
    extends View.BaseSavedState {
        List<? extends SearchSuggestion> suggestions = new ArrayList<SearchSuggestion>();
        Parcelable.Creator SUGGEST_CREATOR;
        boolean isFocused;
        String mQuery;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState, boolean isFocused, List<? extends SearchSuggestion> suggestions, String query) {
            super(superState);
            this.isFocused = isFocused;
            this.suggestions = suggestions;
            if (!suggestions.isEmpty()) {
                this.SUGGEST_CREATOR = suggestions.get(0).getCreator();
            }
            this.mQuery = query;
        }

        private SavedState(Parcel in) {
            super(in);
            boolean bl = this.isFocused = in.readInt() != 0;
            if (this.SUGGEST_CREATOR != null) {
                in.readTypedList(this.suggestions, this.SUGGEST_CREATOR);
            }
            this.mQuery = in.readString();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.isFocused ? 1 : 0);
            out.writeTypedList(this.suggestions);
            out.writeString(this.mQuery);
        }
    }

    private static interface OnSuggestionsCollapsedListener {
        public void onCollapsed();
    }

    private static interface OnSuggestionsClearListener {
        public void onCleared();
    }

    public static interface OnFocusChangeListener {
        public void onFocus();

        public void onFocusCleared();
    }

    public static interface OnQueryChangeListener {
        public void onSearchTextChanged(String var1, String var2);
    }

    public static interface OnMenuItemClickListener {
        public void onMenuItemSelected(MenuItem var1);
    }

    public static interface OnSearchListener {
        public void onSuggestionClicked(SearchSuggestion var1);

        public void onSearchAction();
    }

    public static interface OnLeftMenuClickListener {
        public void onMenuOpened();

        public void onMenuClosed();
    }
}

