/*
 * Decompiled with CFR 0.152.
 */
package com.arlib.floatingsearchview.suggestions;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.arlib.floatingsearchview.R;
import com.arlib.floatingsearchview.suggestions.model.SearchSuggestion;
import java.util.ArrayList;
import java.util.List;

public class SearchSuggestionsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = "";
    private List<SearchSuggestion> mSearchSuggestions;
    private Listener mListener;
    private Context mContext;
    private SearchSuggestion mSelectedItem;
    private Drawable mRightIconDrawable;

    public SearchSuggestionsAdapter(Context context, Listener listener) {
        this.mContext = context;
        this.mListener = listener;
        this.mSearchSuggestions = new ArrayList<SearchSuggestion>();
        this.mRightIconDrawable = this.mContext.getResources().getDrawable(R.drawable.ic_arrow_back_black_24dp);
        this.mRightIconDrawable = DrawableCompat.wrap((Drawable)this.mRightIconDrawable);
        DrawableCompat.setTint((Drawable)this.mRightIconDrawable, (int)this.mContext.getResources().getColor(R.color.gray_active_icon));
    }

    public List<? extends SearchSuggestion> getDataSet() {
        return this.mSearchSuggestions;
    }

    public void swapData(List<? extends SearchSuggestion> searchSuggestions) {
        this.mSearchSuggestions.clear();
        this.mSearchSuggestions.addAll(searchSuggestions);
        this.notifyDataSetChanged();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.search_suggestion_item, viewGroup, false);
        SearchSuggestionViewHolder viewHolder = new SearchSuggestionViewHolder(view, new SearchSuggestionViewHolder.Listener(){

            @Override
            public void onItemClicked(int adapterPosition) {
                if (SearchSuggestionsAdapter.this.mListener != null) {
                    SearchSuggestionsAdapter.this.mListener.onItemSelected((SearchSuggestion)SearchSuggestionsAdapter.this.mSearchSuggestions.get(adapterPosition));
                }
            }

            @Override
            public void onMoveItemToSearchClicked(int adapterPosition) {
                if (SearchSuggestionsAdapter.this.mListener != null) {
                    SearchSuggestionsAdapter.this.mListener.onMoveItemToSearchClicked((SearchSuggestion)SearchSuggestionsAdapter.this.mSearchSuggestions.get(adapterPosition));
                }
            }
        });
        viewHolder.rightIcon.setImageDrawable(this.mRightIconDrawable);
        return viewHolder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder vh, int position) {
        SearchSuggestion item = this.mSearchSuggestions.get(position);
        SearchSuggestionViewHolder viewHolder = (SearchSuggestionViewHolder)vh;
        this.resetImageView(viewHolder.leftIcon);
        viewHolder.body.setText((CharSequence)item.getBody());
        item.setBodyText(viewHolder.body);
        if (item.setLeftIcon(viewHolder.leftIcon)) {
            viewHolder.leftIcon.setVisibility(0);
        } else {
            viewHolder.leftIcon.setVisibility(4);
        }
    }

    public int getItemCount() {
        return this.mSearchSuggestions != null ? this.mSearchSuggestions.size() : 0;
    }

    public void clearDataSet() {
        int rage = this.mSearchSuggestions.size();
        this.mSearchSuggestions.clear();
        this.notifyItemRangeRemoved(0, rage);
    }

    private void resetImageView(ImageView imageView) {
        imageView.setImageDrawable(null);
        imageView.setAlpha(1.0f);
    }

    public static class SearchSuggestionViewHolder
    extends RecyclerView.ViewHolder {
        private static final String TAG = "";
        public TextView body;
        public ImageView leftIcon;
        public ImageView rightIcon;
        private Listener mListener;

        public SearchSuggestionViewHolder(View v, Listener listener) {
            super(v);
            this.mListener = listener;
            this.body = (TextView)v.findViewById(R.id.body);
            this.leftIcon = (ImageView)v.findViewById(R.id.left_icon);
            this.rightIcon = (ImageView)v.findViewById(R.id.right_icon);
            this.rightIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (SearchSuggestionViewHolder.this.mListener != null) {
                        SearchSuggestionViewHolder.this.mListener.onMoveItemToSearchClicked(SearchSuggestionViewHolder.this.getAdapterPosition());
                    }
                }
            });
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (SearchSuggestionViewHolder.this.mListener != null) {
                        SearchSuggestionViewHolder.this.mListener.onItemClicked(SearchSuggestionViewHolder.this.getAdapterPosition());
                    }
                }
            });
        }

        public static interface Listener {
            public void onItemClicked(int var1);

            public void onMoveItemToSearchClicked(int var1);
        }
    }

    public static interface Listener {
        public void onItemSelected(SearchSuggestion var1);

        public void onMoveItemToSearchClicked(SearchSuggestion var1);
    }
}

