/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadrosid.svgloader;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.PictureDrawable;
import android.net.Uri;
import android.util.Log;
import android.widget.ImageView;
import com.ahmadrosid.svgloader.SvgDecoder;
import com.ahmadrosid.svgloader.SvgDrawableTranscoder;
import com.ahmadrosid.svgloader.SvgSoftwareLayerSetter;
import com.bumptech.glide.GenericRequestBuilder;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Encoder;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.model.StreamEncoder;
import com.bumptech.glide.load.resource.file.FileToStreamDecoder;
import com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.caverock.androidsvg.SVG;
import java.io.File;
import java.io.InputStream;

public class SvgParser {
    private final Activity activity;
    private GenericRequestBuilder<Uri, InputStream, SVG, PictureDrawable> requestBuilder;
    private static final String TAG = "SvgParser";

    public SvgParser(Activity activity) {
        this.activity = activity;
        this.createRequestBuilder();
    }

    private void createRequestBuilder() {
        this.requestBuilder = Glide.with((Activity)this.activity).using(Glide.buildStreamModelLoader(Uri.class, (Context)this.activity), InputStream.class).from(Uri.class).as(SVG.class).transcode((ResourceTranscoder)new SvgDrawableTranscoder(), PictureDrawable.class).sourceEncoder((Encoder)new StreamEncoder()).cacheDecoder((ResourceDecoder)new FileToStreamDecoder((ResourceDecoder)new SvgDecoder())).decoder((ResourceDecoder)new SvgDecoder()).animate(0x10A0000).listener(new SvgSoftwareLayerSetter());
    }

    public void setPlaceHolder(int placeHolderLoding, int placeHolderError) {
        this.requestBuilder.placeholder(placeHolderLoding).error(placeHolderError);
    }

    public void loadImage(Uri uri, ImageView imageView) {
        this.requestBuilder.diskCacheStrategy(DiskCacheStrategy.SOURCE).load((Object)uri).into(imageView);
    }

    public void clearCache() {
        Glide.get((Context)this.activity).clearMemory();
        File cacheDir = Glide.getPhotoCacheDir((Context)this.activity);
        if (cacheDir.isDirectory()) {
            for (File child : cacheDir.listFiles()) {
                if (child.delete()) continue;
                Log.w((String)TAG, (String)("cannot delete: " + child));
            }
        }
    }
}

