/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.apexcharts.config.responsive.builder;

import com.github.appreciated.apexcharts.config.Annotations;
import com.github.appreciated.apexcharts.config.Chart;
import com.github.appreciated.apexcharts.config.DataLabels;
import com.github.appreciated.apexcharts.config.Fill;
import com.github.appreciated.apexcharts.config.Grid;
import com.github.appreciated.apexcharts.config.Legend;
import com.github.appreciated.apexcharts.config.Markers;
import com.github.appreciated.apexcharts.config.NoData;
import com.github.appreciated.apexcharts.config.PlotOptions;
import com.github.appreciated.apexcharts.config.States;
import com.github.appreciated.apexcharts.config.Stroke;
import com.github.appreciated.apexcharts.config.Theme;
import com.github.appreciated.apexcharts.config.TitleSubtitle;
import com.github.appreciated.apexcharts.config.Tooltip;
import com.github.appreciated.apexcharts.config.XAxis;
import com.github.appreciated.apexcharts.config.YAxis;
import com.github.appreciated.apexcharts.config.responsive.Options;

public class OptionsBuilder {
    private Annotations annotations;
    private Chart chart;
    private String[] colors;
    private DataLabels dataLabels;
    private Fill fill;
    private Grid grid;
    private String[] labels;
    private Legend legend;
    private Markers markers;
    private NoData noData;
    private PlotOptions plotOptions;
    private States states;
    private Stroke stroke;
    private TitleSubtitle subtitle;
    private Theme theme;
    private TitleSubtitle title;
    private Tooltip tooltip;
    private XAxis xaxis;
    private YAxis[] yaxis;

    private OptionsBuilder() {
    }

    public static OptionsBuilder get() {
        return new OptionsBuilder();
    }

    public OptionsBuilder withApexAnnotations(Annotations apexAnnotations) {
        this.annotations = apexAnnotations;
        return this;
    }

    public OptionsBuilder withChart(Chart apexChart) {
        this.chart = apexChart;
        return this;
    }

    public OptionsBuilder withColors(String[] colors) {
        this.colors = colors;
        return this;
    }

    public OptionsBuilder withDataLabels(DataLabels dataLabels) {
        this.dataLabels = dataLabels;
        return this;
    }

    public OptionsBuilder withFill(Fill fill) {
        this.fill = fill;
        return this;
    }

    public OptionsBuilder withGrid(Grid grid) {
        this.grid = grid;
        return this;
    }

    public OptionsBuilder withLabels(String[] labels) {
        this.labels = labels;
        return this;
    }

    public OptionsBuilder withLegend(Legend legend) {
        this.legend = legend;
        return this;
    }

    public OptionsBuilder withMarkers(Markers markers) {
        this.markers = markers;
        return this;
    }

    public OptionsBuilder withNoData(NoData noData) {
        this.noData = noData;
        return this;
    }

    public OptionsBuilder withPlotOptions(PlotOptions plotOptions) {
        this.plotOptions = plotOptions;
        return this;
    }

    public OptionsBuilder withStates(States states) {
        this.states = states;
        return this;
    }

    public OptionsBuilder withStroke(Stroke stroke) {
        this.stroke = stroke;
        return this;
    }

    public OptionsBuilder withSubtitle(TitleSubtitle subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public OptionsBuilder withTheme(Theme theme) {
        this.theme = theme;
        return this;
    }

    public OptionsBuilder withTitle(TitleSubtitle title) {
        this.title = title;
        return this;
    }

    public OptionsBuilder withTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public OptionsBuilder withXAxis(XAxis xAxis) {
        this.xaxis = xAxis;
        return this;
    }

    public OptionsBuilder withYAxes(YAxis[] yAxes) {
        this.yaxis = yAxes;
        return this;
    }

    public Options build() {
        Options options = new Options();
        options.setAnnotations(this.annotations);
        options.setChart(this.chart);
        options.setColors(this.colors);
        options.setDataLabels(this.dataLabels);
        options.setFill(this.fill);
        options.setGrid(this.grid);
        options.setLabels(this.labels);
        options.setLegend(this.legend);
        options.setMarkers(this.markers);
        options.setNoData(this.noData);
        options.setPlotOptions(this.plotOptions);
        options.setStates(this.states);
        options.setStroke(this.stroke);
        options.setSubtitle(this.subtitle);
        options.setTheme(this.theme);
        options.setTitle(this.title);
        options.setTooltip(this.tooltip);
        options.setXAxis(this.xaxis);
        options.setYAxes(this.yaxis);
        return options;
    }
}

