/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.apexcharts.config.locale.builder;

import com.github.appreciated.apexcharts.config.locale.Toolbar;

public class ToolbarBuilder {
    private String exportToSVG;
    private String exportToPNG;
    private String menu;
    private String selection;
    private String selectionZoom;
    private String zoomIn;
    private String zoomOut;
    private String pan;
    private String reset;

    private ToolbarBuilder() {
    }

    public static ToolbarBuilder get() {
        return new ToolbarBuilder();
    }

    public ToolbarBuilder withExportToSVG(String exportToSVG) {
        this.exportToSVG = exportToSVG;
        return this;
    }

    public ToolbarBuilder withExportToPNG(String exportToPNG) {
        this.exportToPNG = exportToPNG;
        return this;
    }

    public ToolbarBuilder withMenu(String menu) {
        this.menu = menu;
        return this;
    }

    public ToolbarBuilder withSelection(String selection) {
        this.selection = selection;
        return this;
    }

    public ToolbarBuilder withSelectionZoom(String selectionZoom) {
        this.selectionZoom = selectionZoom;
        return this;
    }

    public ToolbarBuilder withZoomIn(String zoomIn) {
        this.zoomIn = zoomIn;
        return this;
    }

    public ToolbarBuilder withZoomOut(String zoomOut) {
        this.zoomOut = zoomOut;
        return this;
    }

    public ToolbarBuilder withPan(String pan) {
        this.pan = pan;
        return this;
    }

    public ToolbarBuilder withReset(String reset) {
        this.reset = reset;
        return this;
    }

    public Toolbar build() {
        Toolbar toolbar = new Toolbar();
        toolbar.setExportToSVG(this.exportToSVG);
        toolbar.setExportToPNG(this.exportToPNG);
        toolbar.setMenu(this.menu);
        toolbar.setSelection(this.selection);
        toolbar.setSelectionZoom(this.selectionZoom);
        toolbar.setZoomIn(this.zoomIn);
        toolbar.setZoomOut(this.zoomOut);
        toolbar.setPan(this.pan);
        toolbar.setReset(this.reset);
        return toolbar;
    }
}

