/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.apexcharts.config.builder;

import com.github.appreciated.apexcharts.config.Tooltip;
import com.github.appreciated.apexcharts.config.XAxis;
import com.github.appreciated.apexcharts.config.xaxis.AxisBorder;
import com.github.appreciated.apexcharts.config.xaxis.AxisTicks;
import com.github.appreciated.apexcharts.config.xaxis.Crosshairs;
import com.github.appreciated.apexcharts.config.xaxis.Labels;
import com.github.appreciated.apexcharts.config.xaxis.TickPlacement;
import com.github.appreciated.apexcharts.config.xaxis.Title;
import com.github.appreciated.apexcharts.config.xaxis.XAxisType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

public class XAxisBuilder {
    private XAxisType type;
    private List<String> categories;
    private AxisBorder axisBorder;
    private AxisTicks axisTicks;
    private BigDecimal tickAmount;
    private TickPlacement tickPlacement;
    private Double min;
    private Double max;
    private Double range;
    private Boolean floating;
    private String position;
    private Title title;
    private Crosshairs crosshairs;
    private Tooltip tooltip;
    private Labels labels;

    private XAxisBuilder() {
    }

    public static XAxisBuilder get() {
        return new XAxisBuilder();
    }

    public XAxisBuilder withType(XAxisType type) {
        this.type = type;
        return this;
    }

    public XAxisBuilder withCategories(String ... categories) {
        this.categories = Arrays.asList(categories);
        return this;
    }

    public XAxisBuilder withCategories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    public XAxisBuilder withAxisBorder(AxisBorder axisBorder) {
        this.axisBorder = axisBorder;
        return this;
    }

    public XAxisBuilder withAxisTicks(AxisTicks axisTicks) {
        this.axisTicks = axisTicks;
        return this;
    }

    public XAxisBuilder withTickAmount(BigDecimal tickAmount) {
        this.tickAmount = tickAmount;
        return this;
    }

    public XAxisBuilder withTickPlacement(TickPlacement tickPlacement) {
        this.tickPlacement = tickPlacement;
        return this;
    }

    public XAxisBuilder withMin(Double min) {
        this.min = min;
        return this;
    }

    public XAxisBuilder withMax(Double max) {
        this.max = max;
        return this;
    }

    public XAxisBuilder withRange(Double range) {
        this.range = range;
        return this;
    }

    public XAxisBuilder withFloating(Boolean floating) {
        this.floating = floating;
        return this;
    }

    public XAxisBuilder withPosition(String position) {
        this.position = position;
        return this;
    }

    public XAxisBuilder withTitle(Title title) {
        this.title = title;
        return this;
    }

    public XAxisBuilder withCrosshairs(Crosshairs crosshairs) {
        this.crosshairs = crosshairs;
        return this;
    }

    public XAxisBuilder withTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public XAxisBuilder withLabels(Labels labels) {
        this.labels = labels;
        return this;
    }

    public XAxis build() {
        XAxis xAxis = new XAxis();
        xAxis.setType(this.type);
        xAxis.setCategories(this.categories);
        xAxis.setAxisBorder(this.axisBorder);
        xAxis.setAxisTicks(this.axisTicks);
        xAxis.setTickAmount(this.tickAmount);
        xAxis.setTickPlacement(this.tickPlacement);
        xAxis.setMin(this.min);
        xAxis.setMax(this.max);
        xAxis.setRange(this.range);
        xAxis.setFloating(this.floating);
        xAxis.setPosition(this.position);
        xAxis.setTitle(this.title);
        xAxis.setCrosshairs(this.crosshairs);
        xAxis.setTooltip(this.tooltip);
        xAxis.setLabels(this.labels);
        return xAxis;
    }
}

