/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.apexcharts.config.builder;

import com.github.appreciated.apexcharts.config.Chart;
import com.github.appreciated.apexcharts.config.Locale;
import com.github.appreciated.apexcharts.config.chart.Animations;
import com.github.appreciated.apexcharts.config.chart.Brush;
import com.github.appreciated.apexcharts.config.chart.DropShadow;
import com.github.appreciated.apexcharts.config.chart.Events;
import com.github.appreciated.apexcharts.config.chart.Selection;
import com.github.appreciated.apexcharts.config.chart.Sparkline;
import com.github.appreciated.apexcharts.config.chart.StackType;
import com.github.appreciated.apexcharts.config.chart.Toolbar;
import com.github.appreciated.apexcharts.config.chart.Type;
import com.github.appreciated.apexcharts.config.chart.Zoom;

public class ChartBuilder {
    private Type type;
    private String foreColor;
    private String fontFamily;
    private String background;
    private Double offsetX;
    private Double offsetY;
    private String width;
    private String height;
    private DropShadow dropShadow;
    private Brush brush;
    private String id;
    private String defaultLocale;
    private Sparkline sparkline;
    private Boolean stacked;
    private StackType stackType;
    private Toolbar toolbar;
    private Zoom zoom;
    private Selection selection;
    private Animations animations;
    private Locale[] locales;
    private String group;
    private Events events;

    private ChartBuilder() {
    }

    public static ChartBuilder get() {
        return new ChartBuilder();
    }

    public ChartBuilder withType(Type type) {
        this.type = type;
        return this;
    }

    public ChartBuilder withForeColor(String foreColor) {
        this.foreColor = foreColor;
        return this;
    }

    public ChartBuilder withFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
        return this;
    }

    public ChartBuilder withBackground(String background) {
        this.background = background;
        return this;
    }

    public ChartBuilder withOffsetX(Double offsetX) {
        this.offsetX = offsetX;
        return this;
    }

    public ChartBuilder withOffsetY(Double offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    public ChartBuilder withDropShadow(DropShadow dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public ChartBuilder withBrush(Brush brush) {
        this.brush = brush;
        return this;
    }

    public ChartBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public ChartBuilder withDefaultLocale(String defaultLocale) {
        this.defaultLocale = defaultLocale;
        return this;
    }

    public ChartBuilder withSparkline(Sparkline sparkline) {
        this.sparkline = sparkline;
        return this;
    }

    public ChartBuilder withEvents(Events events) {
        this.events = events;
        return this;
    }

    public ChartBuilder withStacked(Boolean stacked) {
        this.stacked = stacked;
        return this;
    }

    public ChartBuilder withStackType(StackType stackType) {
        this.stackType = stackType;
        return this;
    }

    public ChartBuilder withToolbar(Toolbar toolbar) {
        this.toolbar = toolbar;
        return this;
    }

    public ChartBuilder withZoom(Zoom zoom) {
        this.zoom = zoom;
        return this;
    }

    public ChartBuilder withSelection(Selection selection) {
        this.selection = selection;
        return this;
    }

    public ChartBuilder withAnimations(Animations animations) {
        this.animations = animations;
        return this;
    }

    public ChartBuilder withWidth(String width) {
        this.width = width;
        return this;
    }

    public ChartBuilder withHeight(String height) {
        this.height = height;
        return this;
    }

    public ChartBuilder withLocales(Locale ... locales) {
        this.locales = locales;
        return this;
    }

    public ChartBuilder withGroup(String group) {
        this.group = group;
        return this;
    }

    public Chart build() {
        Chart chart = new Chart();
        chart.setWidth(this.width);
        chart.setHeight(this.height);
        chart.setType(this.type);
        chart.setForeColor(this.foreColor);
        chart.setFontFamily(this.fontFamily);
        chart.setBackground(this.background);
        chart.setOffsetX(this.offsetX);
        chart.setOffsetY(this.offsetY);
        chart.setDropShadow(this.dropShadow);
        chart.setBrush(this.brush);
        chart.setId(this.id);
        chart.setDefaultLocale(this.defaultLocale);
        chart.setSparkline(this.sparkline);
        chart.setStacked(this.stacked);
        chart.setStackType(this.stackType);
        chart.setToolbar(this.toolbar);
        chart.setZoom(this.zoom);
        chart.setSelection(this.selection);
        chart.setAnimations(this.animations);
        chart.setLocales(this.locales);
        chart.setGroup(this.group);
        chart.setEvents(this.events);
        return chart;
    }
}

