/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.apexcharts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.appreciated.apexcharts.ApexCharts;
import com.github.appreciated.apexcharts.config.Annotations;
import com.github.appreciated.apexcharts.config.Chart;
import com.github.appreciated.apexcharts.config.DataLabels;
import com.github.appreciated.apexcharts.config.Fill;
import com.github.appreciated.apexcharts.config.ForecastDataPoints;
import com.github.appreciated.apexcharts.config.Grid;
import com.github.appreciated.apexcharts.config.Legend;
import com.github.appreciated.apexcharts.config.Markers;
import com.github.appreciated.apexcharts.config.NoData;
import com.github.appreciated.apexcharts.config.PlotOptions;
import com.github.appreciated.apexcharts.config.Responsive;
import com.github.appreciated.apexcharts.config.States;
import com.github.appreciated.apexcharts.config.Stroke;
import com.github.appreciated.apexcharts.config.Theme;
import com.github.appreciated.apexcharts.config.TitleSubtitle;
import com.github.appreciated.apexcharts.config.Tooltip;
import com.github.appreciated.apexcharts.config.XAxis;
import com.github.appreciated.apexcharts.config.YAxis;
import com.github.appreciated.apexcharts.helper.Series;

public class ApexChartsBuilder {
    private Chart chart;
    private Annotations annotations;
    private String[] colors;
    private DataLabels dataLabels;
    private Fill fill;
    private ForecastDataPoints forecastDataPoints;
    private Grid grid;
    private String[] labels;
    private Legend legend;
    private Markers markers;
    private NoData noData;
    private PlotOptions plotOptions;
    private Responsive[] responsive;
    private States states;
    private Stroke stroke;
    private TitleSubtitle subtitle;
    private Theme theme;
    private TitleSubtitle title;
    private Tooltip tooltip;
    private XAxis xaxis;
    private YAxis[] yaxis;
    private Series[] series;
    private Double[] doubleSeries;
    private boolean debug;
    private ObjectMapper objectMapper;

    public ApexChartsBuilder() {
    }

    public ApexChartsBuilder(ApexCharts apexCharts) {
    }

    public static ApexChartsBuilder get(ApexCharts apexCharts) {
        return new ApexChartsBuilder();
    }

    public static ApexChartsBuilder get() {
        return new ApexChartsBuilder();
    }

    public ApexChartsBuilder withAnnotations(Annotations annotations) {
        this.annotations = annotations;
        return this;
    }

    public ApexChartsBuilder withChart(Chart chart) {
        this.chart = chart;
        return this;
    }

    public ApexChartsBuilder withColors(String ... colors) {
        this.colors = colors;
        return this;
    }

    public ApexChartsBuilder withDataLabels(DataLabels dataLabels) {
        this.dataLabels = dataLabels;
        return this;
    }

    public ApexChartsBuilder withFill(Fill fill) {
        this.fill = fill;
        return this;
    }

    public ApexChartsBuilder withForecastDataPoints(ForecastDataPoints forecastDataPoints) {
        this.forecastDataPoints = forecastDataPoints;
        return this;
    }

    public ApexChartsBuilder withGrid(Grid grid) {
        this.grid = grid;
        return this;
    }

    public ApexChartsBuilder withLabels(String ... labels) {
        this.labels = labels;
        return this;
    }

    public ApexChartsBuilder withLegend(Legend legend) {
        this.legend = legend;
        return this;
    }

    public ApexChartsBuilder withMarkers(Markers markers) {
        this.markers = markers;
        return this;
    }

    public ApexChartsBuilder withNoData(NoData noData) {
        this.noData = noData;
        return this;
    }

    public ApexChartsBuilder withPlotOptions(PlotOptions plotOptions) {
        this.plotOptions = plotOptions;
        return this;
    }

    public ApexChartsBuilder withResponsive(Responsive ... responsive) {
        this.responsive = responsive;
        return this;
    }

    public ApexChartsBuilder withStates(States states) {
        this.states = states;
        return this;
    }

    public ApexChartsBuilder withStroke(Stroke stroke) {
        this.stroke = stroke;
        return this;
    }

    public ApexChartsBuilder withSubtitle(TitleSubtitle subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public ApexChartsBuilder withTheme(Theme theme) {
        this.theme = theme;
        return this;
    }

    public ApexChartsBuilder withDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public ApexChartsBuilder withTitle(TitleSubtitle title) {
        this.title = title;
        return this;
    }

    public ApexChartsBuilder withTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ApexChartsBuilder withXaxis(XAxis xaxis) {
        this.xaxis = xaxis;
        return this;
    }

    public ApexChartsBuilder withYaxis(YAxis ... yaxis) {
        this.yaxis = yaxis;
        return this;
    }

    public ApexChartsBuilder withSeries(Series ... series) {
        this.series = series;
        return this;
    }

    public ApexChartsBuilder withSeries(Double ... series) {
        this.doubleSeries = series;
        return this;
    }

    public ApexChartsBuilder withObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public ApexCharts build() {
        ApexCharts apexCharts;
        ApexCharts apexCharts2 = apexCharts = this.objectMapper == null ? new ApexCharts() : new ApexCharts(this.objectMapper);
        if (this.annotations != null) {
            apexCharts.setAnnotations(this.annotations);
        }
        if (this.chart != null) {
            apexCharts.setChart(this.chart);
        }
        if (this.colors != null) {
            apexCharts.setColors(this.colors);
        }
        if (this.dataLabels != null) {
            apexCharts.setDataLabels(this.dataLabels);
        }
        if (this.fill != null) {
            apexCharts.setFill(this.fill);
        }
        if (this.forecastDataPoints != null) {
            apexCharts.setForecastDataPoints(this.forecastDataPoints);
        }
        if (this.grid != null) {
            apexCharts.setGrid(this.grid);
        }
        if (this.labels != null) {
            apexCharts.setLabels(this.labels);
        }
        if (this.legend != null) {
            apexCharts.setLegend(this.legend);
        }
        if (this.markers != null) {
            apexCharts.setMarkers(this.markers);
        }
        if (this.noData != null) {
            apexCharts.setNoData(this.noData);
        }
        if (this.plotOptions != null) {
            apexCharts.setPlotOptions(this.plotOptions);
        }
        if (this.responsive != null) {
            apexCharts.setResponsive(this.responsive);
        }
        if (this.states != null) {
            apexCharts.setStates(this.states);
        }
        if (this.stroke != null) {
            apexCharts.setStroke(this.stroke);
        }
        if (this.subtitle != null) {
            apexCharts.setSubtitle(this.subtitle);
        }
        if (this.theme != null) {
            apexCharts.setTheme(this.theme);
        }
        if (this.title != null) {
            apexCharts.setTitle(this.title);
        }
        if (this.tooltip != null) {
            apexCharts.setTooltip(this.tooltip);
        }
        if (this.xaxis != null) {
            apexCharts.setXaxis(this.xaxis);
        }
        if (this.yaxis != null) {
            apexCharts.setYaxis(this.yaxis);
        }
        apexCharts.setDebug(this.debug);
        if (this.series != null) {
            apexCharts.setSeries(this.series);
        } else if (this.doubleSeries != null) {
            apexCharts.setSeries(this.doubleSeries);
        }
        return apexCharts;
    }
}

