/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.apexcharts;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.appreciated.apexcharts.config.Annotations;
import com.github.appreciated.apexcharts.config.Chart;
import com.github.appreciated.apexcharts.config.DataLabels;
import com.github.appreciated.apexcharts.config.Fill;
import com.github.appreciated.apexcharts.config.ForecastDataPoints;
import com.github.appreciated.apexcharts.config.Grid;
import com.github.appreciated.apexcharts.config.Legend;
import com.github.appreciated.apexcharts.config.Markers;
import com.github.appreciated.apexcharts.config.NoData;
import com.github.appreciated.apexcharts.config.PlotOptions;
import com.github.appreciated.apexcharts.config.Responsive;
import com.github.appreciated.apexcharts.config.States;
import com.github.appreciated.apexcharts.config.Stroke;
import com.github.appreciated.apexcharts.config.Theme;
import com.github.appreciated.apexcharts.config.TitleSubtitle;
import com.github.appreciated.apexcharts.config.Tooltip;
import com.github.appreciated.apexcharts.config.XAxis;
import com.github.appreciated.apexcharts.config.YAxis;
import com.github.appreciated.apexcharts.helper.Series;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.littemplate.LitTemplate;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@Tag(value="apex-charts-wrapper")
@NpmPackage.Container(value={@NpmPackage(value="apexcharts", version="3.35.0"), @NpmPackage(value="onecolor", version="3.1.0")})
@JsModule(value="./com/github/appreciated/apexcharts/apexcharts-wrapper.ts")
@CssImport(value="./com/github/appreciated/apexcharts/apexcharts-wrapper-styles.css", id="apex-charts-style")
public class ApexCharts
extends LitTemplate
implements HasSize,
HasStyle,
HasTheme {
    private static final Logger LOG = Logger.getLogger(ApexCharts.class.getName());
    private final ObjectMapper objectMapper;

    public ApexCharts() {
        this(new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL));
    }

    public ApexCharts(ObjectMapper objectMapper) {
        assert (objectMapper != null) : "objectMapper may not be null";
        this.objectMapper = objectMapper;
        this.setWidth("100%");
    }

    private void setPropertyObject(String property, Object value) {
        try {
            this.getElement().setProperty(property, this.objectMapper.writeValueAsString(value));
        }
        catch (JsonProcessingException ex) {
            LOG.log(Level.SEVERE, String.format("Error mapping [%s] to json: %s", property, ex.getMessage()), ex);
        }
    }

    private void setProperty(String property, String value) {
        this.getElement().setProperty(property, value);
    }

    private <T> void setPropertyList(String property, List<T> value) {
        this.getElement().setPropertyList(property, value);
    }

    public void setWidth(String width) {
        super.setWidth(width);
        this.setProperty("width", width);
    }

    public void setHeight(String height) {
        super.setHeight(height);
        this.setProperty("height", height);
    }

    public void setAnnotations(Annotations annotations) {
        this.setPropertyObject("annotations", annotations);
    }

    public void setChart(Chart chart) {
        this.setPropertyObject("chart", chart);
    }

    public void setColors(String ... colors) {
        this.setPropertyObject("colors", colors);
    }

    public void setDataLabels(DataLabels dataLabels) {
        this.setPropertyObject("dataLabels", dataLabels);
    }

    public void setFill(Fill fill) {
        this.setPropertyObject("fill", fill);
    }

    public void setGrid(Grid grid) {
        this.setPropertyObject("grid", grid);
    }

    public void setLabels(String ... labels) {
        this.setPropertyList("labels", Arrays.asList(labels));
    }

    public void setLegend(Legend legend) {
        this.setPropertyObject("legend", legend);
    }

    public void setForecastDataPoints(ForecastDataPoints forecastDataPoints) {
        this.setPropertyObject("forecastDataPoints", forecastDataPoints);
    }

    public void setMarkers(Markers markers) {
        this.setPropertyObject("markers", markers);
    }

    public void setNoData(NoData noData) {
        this.setPropertyObject("noData", noData);
    }

    public void setPlotOptions(PlotOptions plotOptions) {
        this.setPropertyObject("plotOptions", plotOptions);
    }

    public void setResponsive(Responsive ... responsive) {
        this.setPropertyObject("responsive", responsive);
    }

    public void setStates(States states) {
        this.setPropertyObject("states", states);
    }

    public void setStroke(Stroke stroke) {
        this.setPropertyObject("stroke", stroke);
    }

    public void setSubtitle(TitleSubtitle subtitle) {
        this.setPropertyObject("subtitle", subtitle);
    }

    public void setTheme(Theme theme) {
        this.setPropertyObject("theme", theme);
    }

    public void setTitle(TitleSubtitle chartTitle) {
        this.setPropertyObject("chartTitle", chartTitle);
    }

    public void setTooltip(Tooltip tooltip) {
        this.setPropertyObject("tooltip", tooltip);
    }

    public void setXaxis(XAxis xaxis) {
        this.setPropertyObject("xaxis", xaxis);
    }

    public void setYaxis(YAxis[] yaxis) {
        this.setPropertyObject("yaxis", yaxis);
    }

    public void render() {
        this.getElement().callJsFunction("reRender", new Serializable[0]);
    }

    public PendingJavaScriptResult dataURI() {
        return this.getElement().callJsFunction("dataURI", new Serializable[0]);
    }

    public void setDebug(boolean enabled) {
        this.getElement().setProperty("debug", enabled);
    }

    public void updateSeries(Double ... series) {
        this.setSeries(series);
        this.getElement().callJsFunction("updateData", new Serializable[0]);
    }

    public void updateSeries(Series ... series) {
        this.setSeries(series);
        this.getElement().callJsFunction("updateData", new Serializable[0]);
    }

    public void setSeries(Series ... series) {
        this.setPropertyObject("series", series);
    }

    public void setSeries(Double ... series) {
        this.setPropertyObject("series", series);
    }

    public PendingJavaScriptResult toggleSeries(String seriesName) {
        return this.getElement().callJsFunction("toggleSeries", new Serializable[]{seriesName});
    }

    public void showSeries(String seriesName) {
        this.getElement().callJsFunction("showSeries", new Serializable[]{seriesName});
    }

    public void hideSeries(String seriesName) {
        this.getElement().callJsFunction("hideSeries", new Serializable[]{seriesName});
    }

    public void resetSeries(Boolean shouldUpdateChart, Boolean shouldResetZoom) {
        this.getElement().callJsFunction("resetSeries", new Serializable[]{shouldUpdateChart, shouldResetZoom});
    }
}

